/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.newretail.busi.ActSeckCycSkuQueryBusiService;
import com.tydic.newretail.busi.bo.ActSeckCycSkuQueryBusiReqBO;
import com.tydic.newretail.busi.bo.ActSeckCycSkuQueryBusiRspBO;
import com.tydic.newretail.busi.bo.SeckillSkuBusiBO;
import com.tydic.newretail.dao.CommodityKillCycleMapper;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillCyclePO;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSeckCycSkuQueryBusiService")
public class ActSeckCycSkuQueryBusiServiceImpl
implements ActSeckCycSkuQueryBusiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isDebugable = this.logger.isDebugEnabled();
    private static final String SUCCESS_MSG = "\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u6210\u529f";
    private static final String ERROR_MSG = "\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u5931\u8d25";
    @Autowired
    private CommodityKillCycleMapper commodityKillCycleMapper;
    @Autowired
    private CommodityKillSkuMapper commodityKillSkuMapper;

    public ActSeckCycSkuQueryBusiRspBO querySeckCycSku(ActSeckCycSkuQueryBusiReqBO reqBO) {
        ActSeckCycSkuQueryBusiRspBO rspBO = new ActSeckCycSkuQueryBusiRspBO();
        ArrayList<SeckillSkuBusiBO> seckillSkuList = new ArrayList<SeckillSkuBusiBO>();
        CommodityKillCyclePO killCyclePO = new CommodityKillCyclePO();
        if (!StringUtils.isBlank((CharSequence)reqBO.getPlateId())) {
            killCyclePO.setPlateId(Long.valueOf(reqBO.getPlateId()));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getCycId())) {
            killCyclePO.setKillCycleId(Long.valueOf(reqBO.getCycId()));
        }
        killCyclePO.setStatus(1);
        try {
            killCyclePO.setStartTime(new SimpleDateFormat("yyyyMMdd").parse(reqBO.getQueryDay()));
            killCyclePO.setEndTime(new SimpleDateFormat("yyyyMMdd").parse(reqBO.getQueryDay()));
        }
        catch (ParseException e) {
            this.logger.error("\u6d3b\u52a8\u4e2d\u5fc3\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2\u67e5\u8be2\u65e5\u671f[queryDay]\uff0c\u7531String\u8f6c\u6362\u4e3aDate\u5f02\u5e38");
            throw new BusinessException("6001", ERROR_MSG, (Throwable)e);
        }
        List<CommodityKillCyclePO> killCyclePOList = this.commodityKillCycleMapper.getList(killCyclePO);
        if (null == killCyclePOList) {
            rspBO.setRespCode("2011");
            rspBO.setRespDesc(ERROR_MSG);
            return rspBO;
        }
        for (CommodityKillCyclePO cyclePO : killCyclePOList) {
            CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
            commodityKillSkuPO.setSkuId(reqBO.getSkuId());
            commodityKillSkuPO.setKillCycleId(cyclePO.getKillCycleId());
            CommodityKillSkuPO killSkuPO = null;
            try {
                killSkuPO = this.commodityKillSkuMapper.getModelBy(commodityKillSkuPO);
            }
            catch (Exception e) {
                this.logger.error(ERROR_MSG, (Throwable)e);
                rspBO.setRespCode("2012");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            if (null == killSkuPO) {
                rspBO.setRespCode("2012");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            SeckillSkuBusiBO seckillSkuBusiBO = new SeckillSkuBusiBO();
            BeanUtils.copyProperties((Object)killSkuPO, (Object)seckillSkuBusiBO);
            try {
                seckillSkuBusiBO.setKillPrice(MoneyUtils.Long2BigDecimal((Long)killSkuPO.getKillPrice()));
                seckillSkuBusiBO.setSkuPrice(MoneyUtils.Long2BigDecimal((Long)killSkuPO.getSkuPrice()));
            }
            catch (Exception e) {
                this.logger.error("\u6d3b\u52a8\u4e2d\u5fc3\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1,\u91d1\u989d\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
                throw new BusinessException("6002", ERROR_MSG, (Throwable)e);
            }
            seckillSkuList.add(seckillSkuBusiBO);
        }
        rspBO.setSeckillSkuList(seckillSkuList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        return rspBO;
    }
}

