/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActCreateActivityAtomService;
import com.tydic.newretail.atom.bo.ActCreateActivityAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityAtomRspBO;
import com.tydic.newretail.atom.bo.ActiveAttributeAtomBO;
import com.tydic.newretail.atom.bo.ActiveGiftAtomBO;
import com.tydic.newretail.atom.bo.ActiveTemplateAtomBO;
import com.tydic.newretail.atom.bo.ShopActiveAtomBO;
import com.tydic.newretail.atom.bo.SkuActiveAtomBO;
import com.tydic.newretail.busi.ActCreateActivityBusiService;
import com.tydic.newretail.busi.bo.ActCreateActivityBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateActivityBusiRspBO;
import com.tydic.newretail.busi.bo.ActiveAttributeBusiBO;
import com.tydic.newretail.busi.bo.ActiveGiftBusiBO;
import com.tydic.newretail.busi.bo.ShopActiveBusiBO;
import com.tydic.newretail.busi.bo.SkuActiveBusiBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.TemplateMapper;
import com.tydic.newretail.dao.po.TemplatePO;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateActivityBusiService")
public class ActCreateActivityBusiServiceImpl
implements ActCreateActivityBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateActivityBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Autowired
    ActCreateActivityAtomService actCreateActivityAtomService;
    @Autowired
    TemplateMapper templateMapper;

    public ActCreateActivityBusiRspBO createActivity(ActCreateActivityBusiReqBO reqBO) {
        ActCreateActivityBusiRspBO rspBO = new ActCreateActivityBusiRspBO();
        ActCreateActivityAtomReqBO atomReqBO = this.generateAtomReqBO(reqBO);
        if ("10".equals(reqBO.getActiveType())) {
            this.setFullSubAtomReqBO(atomReqBO, reqBO);
        } else if ("11".equals(reqBO.getActiveType())) {
            this.setFullGiftAtomReqBO(atomReqBO, reqBO);
        } else if ("12".equals(reqBO.getActiveType())) {
            this.setFullDiscountAtomReqBO(atomReqBO, reqBO);
        } else if ("13".equals(reqBO.getActiveType())) {
            this.setSingleSubAtomReqBO(atomReqBO, reqBO);
        } else if (!"14".equals(reqBO.getActiveType())) {
            if ("15".equals(reqBO.getActiveType())) {
                this.setSingleDiscount(atomReqBO, reqBO);
            } else {
                rspBO.setRespCode("2021");
                rspBO.setRespDesc("\u672a\u77e5\u7684\u6d3b\u52a8\u7c7b\u578b");
                return rspBO;
            }
        }
        ActCreateActivityAtomRspBO atomRspBO = this.actCreateActivityAtomService.createActivity(atomReqBO);
        if (!"0000".equals((Object)atomRspBO)) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5931\u8d25" + atomRspBO.getRespDesc());
            }
            throw new BusinessException("6011", atomRspBO.getRespDesc());
        }
        rspBO.setRespCode(atomRspBO.getRespCode());
        rspBO.setRespDesc(atomRspBO.getRespDesc());
        return rspBO;
    }

    private ActCreateActivityAtomReqBO generateAtomReqBO(ActCreateActivityBusiReqBO reqBO) {
        ActCreateActivityAtomReqBO atomReqBO = new ActCreateActivityAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getActiveAttributeList())) {
            ArrayList<ActiveAttributeAtomBO> activeAttributeAtomBOList = new ArrayList<ActiveAttributeAtomBO>();
            for (ActiveAttributeBusiBO activeAttributeBusiBO : reqBO.getActiveAttributeList()) {
                ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
                BeanUtils.copyProperties((Object)activeAttributeBusiBO, (Object)activeAttributeAtomBO);
                activeAttributeAtomBOList.add(activeAttributeAtomBO);
            }
            atomReqBO.setActiveAttributeList(activeAttributeAtomBOList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getActiveGiftList())) {
            ArrayList<ActiveGiftAtomBO> activeGiftAtomBOList = new ArrayList<ActiveGiftAtomBO>();
            for (ActiveGiftBusiBO activeGiftBusiBO : reqBO.getActiveGiftList()) {
                ActiveGiftAtomBO activeGiftAtomBO = new ActiveGiftAtomBO();
                BeanUtils.copyProperties((Object)activeGiftBusiBO, (Object)activeGiftAtomBO);
                activeGiftAtomBOList.add(activeGiftAtomBO);
            }
            atomReqBO.setActiveGiftList(activeGiftAtomBOList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getActiveSkuList())) {
            ArrayList<SkuActiveAtomBO> skuActiveAtomBOList = new ArrayList<SkuActiveAtomBO>();
            for (SkuActiveBusiBO skuActiveBusiBO : reqBO.getActiveSkuList()) {
                SkuActiveAtomBO skuActiveAtomBO = new SkuActiveAtomBO();
                BeanUtils.copyProperties((Object)skuActiveBusiBO, (Object)skuActiveAtomBO);
                skuActiveAtomBOList.add(skuActiveAtomBO);
            }
            atomReqBO.setActiveSkuList(skuActiveAtomBOList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getShopActiveList())) {
            ArrayList<ShopActiveAtomBO> shopActiveAtomBOList = new ArrayList<ShopActiveAtomBO>();
            for (ShopActiveBusiBO shopActiveBusiBO : reqBO.getShopActiveList()) {
                ShopActiveAtomBO shopActiveAtomBO = new ShopActiveAtomBO();
                BeanUtils.copyProperties((Object)shopActiveBusiBO, (Object)shopActiveAtomBO);
                shopActiveAtomBOList.add(shopActiveAtomBO);
            }
            atomReqBO.setShopActiveList(shopActiveAtomBOList);
        }
        return atomReqBO;
    }

    private void setFullSubAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ArrayList<ActiveTemplateAtomBO> activeTemplateAtomBOList = new ArrayList<ActiveTemplateAtomBO>();
        atomReqBO.setActiveTemplateList(activeTemplateAtomBOList);
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(reqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO1.setParaName(templatePO1.getTemplateName());
        activeAttributeAtomBO1.setParaType(templatePO1.getTemplateType());
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activeAttributeAtomBO1.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(atomReqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO2.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO2.setParaName(templatePO2.getTemplateName());
        activeAttributeAtomBO2.setParaType(templatePO2.getTemplateType());
        activeAttributeAtomBO2.setParaCode("total_fee_discount");
        activeAttributeAtomBO2.setParaValue(reqBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO3 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO3.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO3.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO3.setParaName(templatePO2.getTemplateName());
        activeAttributeAtomBO3.setParaType(templatePO2.getTemplateType());
        activeAttributeAtomBO3.setParaCode("accumulate_flag");
        activeAttributeAtomBO3.setParaValue(reqBO.getAccumulateFlag());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO3);
    }

    private void setFullGiftAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ArrayList<ActiveTemplateAtomBO> activeTemplateAtomBOList = new ArrayList<ActiveTemplateAtomBO>();
        atomReqBO.setActiveTemplateList(activeTemplateAtomBOList);
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO.setParaName(templatePO.getTemplateName());
        activeAttributeAtomBO.setParaType(templatePO.getTemplateType());
        activeAttributeAtomBO.setParaCode("total_fee_reach");
        activeAttributeAtomBO.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setFullDiscountAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ArrayList<ActiveTemplateAtomBO> activeTemplateAtomBOList = new ArrayList<ActiveTemplateAtomBO>();
        atomReqBO.setActiveTemplateList(activeTemplateAtomBOList);
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(reqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO1.setParaName(templatePO1.getTemplateName());
        activeAttributeAtomBO1.setParaType(templatePO1.getTemplateType());
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activeAttributeAtomBO1.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(atomReqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO2.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO2.setParaName(templatePO2.getTemplateName());
        activeAttributeAtomBO2.setParaType(templatePO2.getTemplateType());
        activeAttributeAtomBO2.setParaCode("total_fee_discount_rate");
        activeAttributeAtomBO2.setParaValue(reqBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
    }

    private void setSingleSubAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ArrayList<ActiveTemplateAtomBO> activeTemplateAtomBOList = new ArrayList<ActiveTemplateAtomBO>();
        atomReqBO.setActiveTemplateList(activeTemplateAtomBOList);
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO.setParaName(templatePO.getTemplateName());
        activeAttributeAtomBO.setParaType(templatePO.getTemplateType());
        activeAttributeAtomBO.setParaCode("sku_price_discount");
        activeAttributeAtomBO.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setSingleDiscount(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ArrayList<ActiveTemplateAtomBO> activeTemplateAtomBOList = new ArrayList<ActiveTemplateAtomBO>();
        atomReqBO.setActiveTemplateList(activeTemplateAtomBOList);
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        activeTemplateAtomBOList.add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO.setParaName(templatePO.getTemplateName());
        activeAttributeAtomBO.setParaType(templatePO.getTemplateType());
        activeAttributeAtomBO.setParaCode("sku_price_discount_rate");
        activeAttributeAtomBO.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }
}

