/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActSkuDiscountAtomService;
import com.tydic.newretail.atom.bo.ActSkuDiscountReqBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountRspBO;
import com.tydic.newretail.atom.bo.SkuDetailActRspAtomBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSkuDiscountAtomService")
public class ActSkuDiscountAtomServiceImpl
implements ActSkuDiscountAtomService {
    @Autowired
    private ActiveAttrMapper activeAttrMapper;

    @Override
    public ActSkuDiscountRspBO skuDiscount(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        ActSkuDiscountRspBO rspBO;
        String errorCommonMsg = "\u5f53\u524d\u6a21\u677fID[" + actSkuDiscountReqBO.getTemplateId() + "]";
        if (ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID.equals(actSkuDiscountReqBO.getTemplateId())) {
            rspBO = this.calculateReducedPrice(actSkuDiscountReqBO, "sku_price_discount");
        } else if (ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID.equals(actSkuDiscountReqBO.getTemplateId())) {
            rspBO = this.calculateReducedPrice(actSkuDiscountReqBO, "sku_price_discount_rate");
        } else {
            rspBO = new ActSkuDiscountRspBO();
            rspBO.setRespCode("1002");
            rspBO.setRespDesc(errorCommonMsg + "\u4e0d\u652f\u6301\u5355\u54c1\u4f18\u60e0\u8ba1\u7b97");
        }
        return rspBO;
    }

    private ActSkuDiscountRspBO calculateReducedPrice(ActSkuDiscountReqBO actSkuDiscountReqBO, String activityParamName) {
        String errorCommonMsg = "\u5f53\u524d\u6a21\u677fID[" + actSkuDiscountReqBO.getTemplateId() + "]";
        ActSkuDiscountRspBO rspBO = new ActSkuDiscountRspBO();
        ActiveAttrPO activeAttrModel = new ActiveAttrPO();
        activeAttrModel.setActiveId(actSkuDiscountReqBO.getActId());
        activeAttrModel.setTemplateId(actSkuDiscountReqBO.getTemplateId());
        activeAttrModel.setParaCode(activityParamName);
        ActiveAttrPO activeAttrPO = this.activeAttrMapper.getModelBy(activeAttrModel);
        if (activeAttrPO == null) {
            rspBO.setRespCode("1002");
            rspBO.setRespDesc(errorCommonMsg + "\u672a\u67e5\u8be2\u5230\u6b64\u6a21\u677fID\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((CharSequence)activeAttrPO.getParaValue())) {
            rspBO.setRespCode("1002");
            rspBO.setRespDesc(errorCommonMsg + "\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u672a\u8bbe\u7f6e\u6d3b\u52a8\u5177\u4f53\u503c");
        }
        Map<String, BigDecimal> disPriceMap = this.calculateReducedPrice(actSkuDiscountReqBO.getTemplateId(), actSkuDiscountReqBO.getDisCountAmont(), actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuPrice(), activeAttrPO.getParaValue());
        BigDecimal skuDisPrice = disPriceMap.get("skuDisPrice");
        BigDecimal skuDisAmount = disPriceMap.get("skuDisAmount");
        SkuDetailActRspAtomBO skuDetailActRspAtomBO = new SkuDetailActRspAtomBO();
        skuDetailActRspAtomBO.setSkuId(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuId());
        skuDetailActRspAtomBO.setSkuNum(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuNum());
        skuDetailActRspAtomBO.setShopId(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getShopId());
        skuDetailActRspAtomBO.setSkuPrice(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuPrice());
        skuDetailActRspAtomBO.setSkuDisPrice(skuDisPrice);
        skuDetailActRspAtomBO.setSkuDisAmount(skuDisAmount);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u4e2a\u5546\u54c1[" + actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuId() + "]\u91d1\u989d\u4f18\u60e0\u6210\u529f");
        rspBO.setSkuDetailActRspAtomBO(skuDetailActRspAtomBO);
        return rspBO;
    }

    private Map<String, BigDecimal> calculateReducedPrice(Long templateId, BigDecimal disCountAmont, BigDecimal skuPrice, String activityParaValue) {
        Map<String, BigDecimal> disPriceMap = null;
        if (ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID.equals(templateId)) {
            disPriceMap = this.calculateCashDiscount(activityParaValue, disCountAmont, skuPrice);
        } else if (ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID.equals(templateId)) {
            disPriceMap = this.calculateDiscount(activityParaValue, disCountAmont, skuPrice);
        }
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateCashDiscount(String activityParaValue, BigDecimal disCountAmont, BigDecimal skuPrice) {
        BigDecimal skuDisAmount = new BigDecimal(activityParaValue);
        if (disCountAmont != null) {
            skuDisAmount = skuDisAmount.add(disCountAmont);
        }
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(2);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateDiscount(String activityParaValue, BigDecimal disCountAmont, BigDecimal skuPrice) {
        BigDecimal discountNum = new BigDecimal(activityParaValue);
        BigDecimal skuDisAmount = skuPrice.multiply(discountNum);
        if (disCountAmont != null) {
            skuDisAmount = skuDisAmount.add(disCountAmont);
        }
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(2);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }
}

