/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.busi.ActSeckNumUpdateBusiService;
import com.tydic.newretail.busi.bo.ActSeckNumUpdateBusiReqBO;
import com.tydic.newretail.busi.bo.ActSeckNumUpdateBusiRspBO;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSeckNumUpdateBusiService")
public class ActSeckNumUpdateBusiServiceImpl
implements ActSeckNumUpdateBusiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUCCESS_MSG = "\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u6210\u529f";
    private static final String ERROR_MSG = "\u79d2\u6740\u6570\u91cf\u66f4\u65b0\u5931\u8d25";
    private static final String INCREASE = "0";
    private static final String REDUCE = "1";
    @Autowired
    private CommodityKillSkuMapper commodityKillSkuMapper;

    public ActSeckNumUpdateBusiRspBO updateSeckNum(ActSeckNumUpdateBusiReqBO reqBO) {
        ActSeckNumUpdateBusiRspBO rspBO = new ActSeckNumUpdateBusiRspBO();
        if (INCREASE.equals(reqBO.getOperType())) {
            CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
            killSkuPO.setSkuState(1);
            if (!StringUtils.isBlank((CharSequence)reqBO.getCycId())) {
                killSkuPO.setKillCycleId(Long.valueOf(reqBO.getCycId()));
            }
            killSkuPO.setShopId(Long.valueOf(reqBO.getShopId()));
            killSkuPO.setSkuId(reqBO.getSkuId());
            CommodityKillSkuPO skuPO = null;
            try {
                skuPO = this.commodityKillSkuMapper.getModelBy(killSkuPO);
            }
            catch (Exception e) {
                this.logger.error(ERROR_MSG, (Throwable)e);
                rspBO.setRespCode("2001");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            if (null == skuPO) {
                rspBO.setRespCode("2001");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            if (skuPO.getLockNum() + Integer.valueOf(reqBO.getOperNum()) > skuPO.getActualNum()) {
                rspBO.setRespCode("2002");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
            commodityKillSkuPO.setPlateRelId(skuPO.getPlateRelId());
            commodityKillSkuPO.setLockNum(skuPO.getLockNum() + Integer.valueOf(reqBO.getOperNum()));
            int result = this.commodityKillSkuMapper.updateById(commodityKillSkuPO);
            if (result != 1) {
                rspBO.setRespCode("2003");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
        } else if (REDUCE.equals(reqBO.getOperType())) {
            CommodityKillSkuPO killSkuPO = new CommodityKillSkuPO();
            killSkuPO.setSkuState(1);
            killSkuPO.setKillCycleId(Long.valueOf(reqBO.getCycId()));
            killSkuPO.setShopId(Long.valueOf(reqBO.getShopId()));
            killSkuPO.setSkuId(reqBO.getSkuId());
            CommodityKillSkuPO skuPO = null;
            try {
                skuPO = this.commodityKillSkuMapper.getModelBy(killSkuPO);
            }
            catch (Exception e) {
                this.logger.error(ERROR_MSG, (Throwable)e);
                rspBO.setRespCode("2001");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            if (null == skuPO) {
                rspBO.setRespCode("2001");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            if (skuPO.getLockNum() - Integer.valueOf(reqBO.getOperNum()) < 0) {
                rspBO.setRespCode("2002");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
            CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
            commodityKillSkuPO.setPlateRelId(skuPO.getPlateRelId());
            commodityKillSkuPO.setLockNum(skuPO.getLockNum() - Integer.valueOf(reqBO.getOperNum()));
            int result = this.commodityKillSkuMapper.updateById(commodityKillSkuPO);
            if (result != 1) {
                rspBO.setRespCode("2003");
                rspBO.setRespDesc(ERROR_MSG);
                return rspBO;
            }
        } else {
            rspBO.setRespCode("2003");
            rspBO.setRespDesc("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        return rspBO;
    }
}

