/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.ActOrderActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.ActivityChoiceAtomBO;
import com.tydic.newretail.atom.bo.GiftAtomBo;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.busi.ActActivityCountBusiService;
import com.tydic.newretail.busi.bo.ActActivityCountBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityCountBusiRspBO;
import com.tydic.newretail.busi.bo.ActivityChoiceBusiBO;
import com.tydic.newretail.busi.bo.GiftBusiBO;
import com.tydic.newretail.busi.bo.SkuDetailReqBusiBO;
import com.tydic.newretail.busi.bo.SkuDetailRspBusiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityCountBusiService")
public class ActActivityCountBusiServiceImpl
implements ActActivityCountBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActivityCountBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Autowired
    ActOrderActivityCountAtomService actOrderActivityCountAtomService;
    @Autowired
    ActSkuActivityCountAtomService actSkuActivityCountAtomService;

    public ActActivityCountBusiRspBO countActivity(ActActivityCountBusiReqBO reqBO) {
        ActActivityCountBusiRspBO rspBO = new ActActivityCountBusiRspBO();
        ArrayList<SkuDetailRspBusiBO> skuDetailRspBusiBOList = new ArrayList<SkuDetailRspBusiBO>();
        ArrayList<GiftBusiBO> giftBusiBOList = new ArrayList<GiftBusiBO>();
        for (Object skuDetailReqBusiBO : reqBO.getSkuDetailList()) {
            ActSkuActivityCountRspBO skuAtomRspBO = this.callSkuActivityCount((SkuDetailReqBusiBO)skuDetailReqBusiBO);
            if (!"0000".equals(skuAtomRspBO.getRespCode())) {
                if (IS_DEBUGABLE) {
                    LOG.debug("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5355\u54c1\u6d3b\u52a8\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25" + skuAtomRspBO.getRespDesc());
                }
                rspBO.setRespCode("2011");
                rspBO.setRespDesc(skuAtomRspBO.getRespDesc());
                continue;
            }
            if (null == skuAtomRspBO.getSkuDetailRspAtomBO()) continue;
            SkuDetailRspBusiBO skuDetailRspBusiBO = new SkuDetailRspBusiBO();
            BeanUtils.copyProperties((Object)skuAtomRspBO.getSkuDetailRspAtomBO(), (Object)skuDetailRspBusiBO);
            if (!CollectionUtils.isEmpty(skuAtomRspBO.getSkuDetailRspAtomBO().getGiftAtomBos())) {
                ArrayList<GiftBusiBO> giftBusiBOS = new ArrayList<GiftBusiBO>();
                for (GiftAtomBo giftAtomBo : skuAtomRspBO.getSkuDetailRspAtomBO().getGiftAtomBos()) {
                    GiftBusiBO giftBusiBO = new GiftBusiBO();
                    BeanUtils.copyProperties((Object)giftAtomBo, (Object)giftBusiBO);
                    giftBusiBOS.add(giftBusiBO);
                }
                skuDetailRspBusiBO.setSkuGiftList(giftBusiBOS);
            }
            skuDetailRspBusiBOList.add(skuDetailRspBusiBO);
        }
        BigDecimal totalSkuDisCount = new BigDecimal("0");
        for (SkuDetailRspBusiBO skuDetailRspBusiBO : skuDetailRspBusiBOList) {
            totalSkuDisCount = totalSkuDisCount.add(skuDetailRspBusiBO.getSkuDisAmount());
        }
        ActOrderActivityCountAtomRspBO orderAtomRspBO = this.callOrderActiveCount(reqBO, skuDetailRspBusiBOList);
        if (!"0000".equals(orderAtomRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25" + orderAtomRspBO.getRespDesc());
            }
            rspBO.setRespCode("2011");
            rspBO.setRespCode(orderAtomRspBO.getRespDesc());
            return rspBO;
        }
        rspBO.setDisTotalAmo(orderAtomRspBO.getDisTotalAmo().add(totalSkuDisCount));
        rspBO.setTotalAmount(orderAtomRspBO.getTotalAmount());
        if (!CollectionUtils.isEmpty(orderAtomRspBO.getOrderGiftList())) {
            for (GiftAtomBo giftAtomBo : orderAtomRspBO.getOrderGiftList()) {
                GiftBusiBO giftBusiBO = new GiftBusiBO();
                BeanUtils.copyProperties((Object)giftAtomBo, (Object)giftBusiBO);
                giftBusiBOList.add(giftBusiBO);
            }
        }
        rspBO.setSkuDetailList(skuDetailRspBusiBOList);
        rspBO.setOrderGiftList(giftBusiBOList);
        rspBO.setRespTime(new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private ActSkuActivityCountRspBO callSkuActivityCount(SkuDetailReqBusiBO skuDetailReqBusiBO) {
        ActSkuActivityCountReqBO skuAtomReqBO = new ActSkuActivityCountReqBO();
        SkuDetailReqAtomBO skuDetailActivityReqBO = new SkuDetailReqAtomBO();
        BeanUtils.copyProperties((Object)skuDetailReqBusiBO, (Object)skuDetailActivityReqBO);
        if (!CollectionUtils.isEmpty((Collection)skuDetailReqBusiBO.getSkuActivityList())) {
            ArrayList<ActivityChoiceAtomBO> activityChoiceAtomBOS = new ArrayList<ActivityChoiceAtomBO>();
            for (ActivityChoiceBusiBO activityChoiceBusiBO : skuDetailReqBusiBO.getSkuActivityList()) {
                ActivityChoiceAtomBO activityChoiceAtomBO = new ActivityChoiceAtomBO();
                BeanUtils.copyProperties((Object)activityChoiceBusiBO, (Object)activityChoiceAtomBO);
                activityChoiceAtomBOS.add(activityChoiceAtomBO);
            }
            skuDetailActivityReqBO.setActivityChoiceAtomBOS(activityChoiceAtomBOS);
        }
        skuAtomReqBO.setActSkuActivityDetailReqBO(skuDetailActivityReqBO);
        return this.actSkuActivityCountAtomService.skuActivityCount(skuAtomReqBO);
    }

    private ActOrderActivityCountAtomRspBO callOrderActiveCount(ActActivityCountBusiReqBO reqBO, List<SkuDetailRspBusiBO> orderAtomReqList) {
        ActOrderActivityCountAtomReqBO orderAtomReqBO = new ActOrderActivityCountAtomReqBO();
        ArrayList<SkuDetailActReqAtomBO> skuDetailActReqAtomBOList = new ArrayList<SkuDetailActReqAtomBO>();
        for (SkuDetailRspBusiBO atomSkuDetailReqBusiBO : orderAtomReqList) {
            SkuDetailActReqAtomBO skuDetailActReqAtomBO = new SkuDetailActReqAtomBO();
            BeanUtils.copyProperties((Object)atomSkuDetailReqBusiBO, (Object)skuDetailActReqAtomBO);
            skuDetailActReqAtomBO.setSkuPrice(atomSkuDetailReqBusiBO.getSkuDisPrice());
            skuDetailActReqAtomBOList.add(skuDetailActReqAtomBO);
        }
        orderAtomReqBO.setSkuDetailAtomList(skuDetailActReqAtomBOList);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderActivityList())) {
            ArrayList<ActivityChoiceAtomBO> activityChoiceAtomBOList = new ArrayList<ActivityChoiceAtomBO>();
            for (ActivityChoiceBusiBO activityChoiceBusiBO : reqBO.getOrderActivityList()) {
                ActivityChoiceAtomBO activityChoiceAtomBO = new ActivityChoiceAtomBO();
                BeanUtils.copyProperties((Object)activityChoiceBusiBO, (Object)activityChoiceAtomBO);
                activityChoiceAtomBOList.add(activityChoiceAtomBO);
            }
            orderAtomReqBO.setActivityAtomList(activityChoiceAtomBOList);
        }
        return this.actOrderActivityCountAtomService.orderActivityCount(orderAtomReqBO);
    }
}

