/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActActivityCountAbilityService;
import com.tydic.newretail.ability.bo.ActActivityCountAbilityReqBO;
import com.tydic.newretail.ability.bo.ActActivityCountAbilityRspBO;
import com.tydic.newretail.ability.bo.ActivityChoiceAbilityBO;
import com.tydic.newretail.ability.bo.GiftAbilityBO;
import com.tydic.newretail.ability.bo.SkuDetailReqAbilityBO;
import com.tydic.newretail.ability.bo.SkuDetailRspAbilityBO;
import com.tydic.newretail.busi.ActActivityCountBusiService;
import com.tydic.newretail.busi.bo.ActActivityCountBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityCountBusiRspBO;
import com.tydic.newretail.busi.bo.ActivityChoiceBusiBO;
import com.tydic.newretail.busi.bo.GiftBusiBO;
import com.tydic.newretail.busi.bo.SkuDetailReqBusiBO;
import com.tydic.newretail.busi.bo.SkuDetailRspBusiBO;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityCountAbilityService")
public class ActActivityCountAbilityServiceImpl
implements ActActivityCountAbilityService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActivityCountAbilityServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private static final String PARAM_MSG = "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    @Autowired
    ActActivityCountBusiService actActivityCountBusiService;

    public ActActivityCountAbilityRspBO countActivity(ActActivityCountAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActActivityCountAbilityRspBO rspBO = new ActActivityCountAbilityRspBO();
        ActActivityCountBusiReqBO busiReqBO = this.generateReqBO(reqBO);
        ActActivityCountBusiRspBO busiRspBO = this.actActivityCountBusiService.countActivity(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u5931\u8d25" + busiRspBO.getRespDesc());
            }
            rspBO.setRespCode(busiRspBO.getRespCode());
            rspBO.setRespDesc(busiRspBO.getRespDesc());
            return rspBO;
        }
        BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
        if (!CollectionUtils.isEmpty((Collection)busiRspBO.getSkuDetailList())) {
            ArrayList<SkuDetailRspAbilityBO> skuDetailRspAbilityBOS = new ArrayList<SkuDetailRspAbilityBO>();
            for (SkuDetailRspBusiBO skuDetailRspBusiBO : busiRspBO.getSkuDetailList()) {
                SkuDetailRspAbilityBO skuDetailRspAbilityBO = new SkuDetailRspAbilityBO();
                BeanUtils.copyProperties((Object)skuDetailRspBusiBO, (Object)skuDetailRspAbilityBO);
                if (!CollectionUtils.isEmpty((Collection)skuDetailRspBusiBO.getSkuGiftList())) {
                    ArrayList<GiftAbilityBO> giftAbilityBOList = new ArrayList<GiftAbilityBO>();
                    for (GiftBusiBO giftBusiBO : skuDetailRspBusiBO.getSkuGiftList()) {
                        GiftAbilityBO giftAbilityBO = new GiftAbilityBO();
                        BeanUtils.copyProperties((Object)giftBusiBO, (Object)giftAbilityBO);
                        giftAbilityBOList.add(giftAbilityBO);
                    }
                    skuDetailRspAbilityBO.setSkuGiftList(giftAbilityBOList);
                }
                skuDetailRspAbilityBOS.add(skuDetailRspAbilityBO);
            }
            rspBO.setSkuDetailList(skuDetailRspAbilityBOS);
        }
        if (!CollectionUtils.isEmpty((Collection)busiRspBO.getOrderGiftList())) {
            ArrayList<GiftAbilityBO> giftAbilityBOList = new ArrayList<GiftAbilityBO>();
            for (GiftBusiBO giftBusiBO : busiRspBO.getOrderGiftList()) {
                GiftAbilityBO giftAbilityBO = new GiftAbilityBO();
                BeanUtils.copyProperties((Object)giftBusiBO, (Object)giftAbilityBO);
                giftAbilityBOList.add(giftAbilityBO);
            }
            rspBO.setOrderGiftList(giftAbilityBOList);
        }
        return rspBO;
    }

    private ActActivityCountBusiReqBO generateReqBO(ActActivityCountAbilityReqBO reqBO) {
        ActActivityCountBusiReqBO busiReqBO = new ActActivityCountBusiReqBO();
        ArrayList<SkuDetailReqBusiBO> skuDetailReqBusiBOList = new ArrayList<SkuDetailReqBusiBO>();
        for (SkuDetailReqAbilityBO skuDetailReqAbilityBO : reqBO.getSkuDetailList()) {
            SkuDetailReqBusiBO skuDetailReqBusiBO = new SkuDetailReqBusiBO();
            BeanUtils.copyProperties((Object)skuDetailReqAbilityBO, (Object)skuDetailReqBusiBO);
            if (!CollectionUtils.isEmpty((Collection)skuDetailReqAbilityBO.getSkuActivityList())) {
                ArrayList<ActivityChoiceBusiBO> activityChoiceBusiBOList = new ArrayList<ActivityChoiceBusiBO>();
                for (ActivityChoiceAbilityBO activityChoiceAbilityBO : skuDetailReqAbilityBO.getSkuActivityList()) {
                    ActivityChoiceBusiBO activityChoiceBusiBO = new ActivityChoiceBusiBO();
                    BeanUtils.copyProperties((Object)activityChoiceAbilityBO, (Object)activityChoiceBusiBO);
                    activityChoiceBusiBOList.add(activityChoiceBusiBO);
                }
                skuDetailReqBusiBO.setSkuActivityList(activityChoiceBusiBOList);
            }
            skuDetailReqBusiBOList.add(skuDetailReqBusiBO);
        }
        busiReqBO.setSkuDetailList(skuDetailReqBusiBOList);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderActivityList())) {
            ArrayList<ActivityChoiceBusiBO> activityChoiceBusiBOList = new ArrayList<ActivityChoiceBusiBO>();
            for (ActivityChoiceAbilityBO activityChoiceAbilityBO : reqBO.getOrderActivityList()) {
                ActivityChoiceBusiBO activityChoiceBusiBO = new ActivityChoiceBusiBO();
                BeanUtils.copyProperties((Object)activityChoiceAbilityBO, (Object)activityChoiceBusiBO);
                activityChoiceBusiBOList.add(activityChoiceBusiBO);
            }
            busiReqBO.setOrderActivityList(activityChoiceBusiBOList);
        }
        return busiReqBO;
    }

    private void validateArg(ActActivityCountAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuDetailList())) {
            throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SkuDetailReqAbilityBO skuDetailReqAbilityBO : reqBO.getSkuDetailList()) {
            if (StringUtils.isBlank((CharSequence)skuDetailReqAbilityBO.getSkuId())) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5355\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getShopId()) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getSkuNum()) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5355\u54c1\u6570\u91cf[skuNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailReqAbilityBO.getSkuPrice()) {
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5546\u54c1\u5355\u4ef7[skuPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)skuDetailReqAbilityBO.getSkuActivityList())) continue;
            for (ActivityChoiceAbilityBO activityChoiceAbilityBO : skuDetailReqAbilityBO.getSkuActivityList()) {
                if (null != activityChoiceAbilityBO.getActiveId()) continue;
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5355\u54c1\u5217\u8868[skuDetailList]\u4e2d\u7684\u5355\u54c1\u5df2\u9009\u6d3b\u52a8\u5217\u8868[skuActivityList]\u4e2d\u7684\u6d3b\u52a8ID[activeId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderActivityList())) {
            for (ActivityChoiceAbilityBO activityChoiceAbilityBO : reqBO.getOrderActivityList()) {
                if (null == activityChoiceAbilityBO.getActiveId()) {
                    throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5df2\u9009\u6d3b\u52a8\u5217\u8868[orderActivityList]\u4e2d\u7684\u6d3b\u52a8ID[activeId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != activityChoiceAbilityBO.getShopId()) continue;
                throw new BusinessException("8000", "\u6d3b\u52a8\u8ba1\u7b97\u80fd\u529b\u670d\u52a1\u5165\u53c2\u8ba2\u5355\u5df2\u9009\u6d3b\u52a8\u5217\u8868[orderActivityList]\u4e2d\u7684\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

