/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActActivityValidCheckAtomService;
import com.tydic.newretail.atom.ActGiftQueryAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuDiscountAtomService;
import com.tydic.newretail.atom.ActSkuJudgeAtomService;
import com.tydic.newretail.atom.ActSkuSeckPriceQueryAtomService;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActCalcPriceAtomBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountReqBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountRspBO;
import com.tydic.newretail.atom.bo.ActSkuJudgeAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuJudgeAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomRspBO;
import com.tydic.newretail.atom.bo.ActivityChoiceAtomBO;
import com.tydic.newretail.atom.bo.GiftAtomBo;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailRspAtomBO;
import com.tydic.newretail.dao.ActiveTemplateMapper;
import com.tydic.newretail.dao.po.ActiveTemplatePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSkuActivityCountAtomService")
public class ActSkuActivityCountAtomServiceImpl
implements ActSkuActivityCountAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSkuActivityCountAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SECK_KILL_SKU_YES = "1";
    private static final String SECK_KILL_SKU_NO = "0";
    private ActActivityValidCheckAtomService actActivityValidCheckAtomService;
    private ActSkuJudgeAtomService actSkuJudgeAtomService;
    private ActSkuDiscountAtomService actSkuDiscountAtomService;
    private ActGiftQueryAtomService actGiftQueryAtomService;
    private ActiveTemplateMapper activeTemplateMapper;
    private ActSkuSeckPriceQueryAtomService actSkuSeckPriceQueryAtomService;

    @Autowired
    public ActSkuActivityCountAtomServiceImpl(ActActivityValidCheckAtomService actActivityValidCheckAtomService, ActSkuJudgeAtomService actSkuJudgeAtomService, ActSkuDiscountAtomService actSkuDiscountAtomService, ActGiftQueryAtomService actGiftQueryAtomService, ActiveTemplateMapper activeTemplateMapper, ActSkuSeckPriceQueryAtomService actSkuSeckPriceQueryAtomService) {
        this.actActivityValidCheckAtomService = actActivityValidCheckAtomService;
        this.actSkuJudgeAtomService = actSkuJudgeAtomService;
        this.actSkuDiscountAtomService = actSkuDiscountAtomService;
        this.actGiftQueryAtomService = actGiftQueryAtomService;
        this.activeTemplateMapper = activeTemplateMapper;
        this.actSkuSeckPriceQueryAtomService = actSkuSeckPriceQueryAtomService;
    }

    @Override
    public ActSkuActivityCountRspBO skuActivityCount(ActSkuActivityCountReqBO actSkuActivityCountReqBO) {
        SkuDetailReqAtomBO skuDetailReqAtomBO = actSkuActivityCountReqBO.getActSkuActivityDetailReqBO();
        List<ActivityChoiceAtomBO> activityChoiceAtomBOS = skuDetailReqAtomBO.getActivityChoiceAtomBOS();
        ActSkuActivityCountRspBO originalRspBO = this.returnOriginalInfo(activityChoiceAtomBOS, skuDetailReqAtomBO, SECK_KILL_SKU_NO, BigDecimal.ZERO);
        if (originalRspBO != null) {
            return originalRspBO;
        }
        ActSkuSeckPriceQueryAtomRspBO actSkuSeckPriceQueryAtomRspBO = this.qrySkuSeckPrice(skuDetailReqAtomBO.getSkuId(), skuDetailReqAtomBO.getShopId());
        if (SECK_KILL_SKU_YES.equals(actSkuSeckPriceQueryAtomRspBO.getSeckillFlag()) && (originalRspBO = this.returnOriginalInfo(activityChoiceAtomBOS, skuDetailReqAtomBO, SECK_KILL_SKU_YES, BigDecimal.valueOf(actSkuSeckPriceQueryAtomRspBO.getKillPrice()))) != null) {
            return originalRspBO;
        }
        Collections.sort(activityChoiceAtomBOS);
        ActSkuActivityCountRspBO rspBO = new ActSkuActivityCountRspBO();
        ActCalcPriceAtomBO actCalcPriceAtomBO = this.obtainDisPriceAndGifts(activityChoiceAtomBOS, skuDetailReqAtomBO);
        if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
            rspBO.setRespCode(actCalcPriceAtomBO.getRespCode());
            rspBO.setRespDesc(actCalcPriceAtomBO.getRespDesc());
            rspBO.setSkuDetailRspAtomBO(null);
            return rspBO;
        }
        BigDecimal disCountAmont = actCalcPriceAtomBO.getDisCountAmont();
        BigDecimal disPrice = actCalcPriceAtomBO.getDisSkuPrice();
        List<GiftAtomBo> giftAtomBos = actCalcPriceAtomBO.getGiftAtomBos();
        SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
        skuDetailRspAtomBO.setSeckillFlag(SECK_KILL_SKU_NO);
        skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailRspAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        skuDetailRspAtomBO.setSkuDisAmount(disCountAmont);
        if (disPrice.compareTo(BigDecimal.ZERO) < 0) {
            skuDetailRspAtomBO.setSkuDisPrice(BigDecimal.ZERO);
        } else {
            skuDetailRspAtomBO.setSkuDisPrice(disPrice);
        }
        skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailRspAtomBO.setGiftAtomBos(giftAtomBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u54c1\u4ef7\u683c\u8ba1\u7b97\u6210\u529f");
        rspBO.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
        return rspBO;
    }

    private ActSkuActivityCountRspBO returnOriginalInfo(List<ActivityChoiceAtomBO> activityChoiceAtomBOS, SkuDetailReqAtomBO skuDetailReqAtomBO, String seckillFlag, BigDecimal killPrice) {
        if (activityChoiceAtomBOS == null || activityChoiceAtomBOS.isEmpty() || SECK_KILL_SKU_YES.equals(seckillFlag)) {
            ActSkuActivityCountRspBO rspBO = new ActSkuActivityCountRspBO();
            SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
            skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
            skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
            skuDetailRspAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
            skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
            skuDetailRspAtomBO.setSkuDisAmount(BigDecimal.ZERO);
            if (SECK_KILL_SKU_YES.equals(seckillFlag)) {
                skuDetailRspAtomBO.setSkuDisPrice(killPrice);
            } else {
                skuDetailRspAtomBO.setSkuDisPrice(skuDetailReqAtomBO.getSkuPrice());
            }
            skuDetailRspAtomBO.setSeckillFlag(seckillFlag);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5b8c\u6210");
            rspBO.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
            return rspBO;
        }
        return null;
    }

    private ActSkuSeckPriceQueryAtomRspBO qrySkuSeckPrice(String skuId, Long shopId) {
        ActSkuSeckPriceQueryAtomReqBO reqBO = new ActSkuSeckPriceQueryAtomReqBO();
        reqBO.setSkuId(skuId);
        reqBO.setShopId(shopId);
        return this.actSkuSeckPriceQueryAtomService.querySkuSeckPrice(reqBO);
    }

    private ActCalcPriceAtomBO obtainDisPriceAndGifts(List<ActivityChoiceAtomBO> activityChoiceAtomBOS, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        ArrayList<GiftAtomBo> allGiftAtomBos = new ArrayList<GiftAtomBo>();
        for (ActivityChoiceAtomBO activityChoiceAtomBO : activityChoiceAtomBOS) {
            boolean isCheckSuccess = this.checkActivityValid(activityChoiceAtomBO, skuDetailReqAtomBO);
            if (!isCheckSuccess) {
                actCalcPriceAtomBO.setRespCode("1003");
                actCalcPriceAtomBO.setRespDesc("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u65e0\u6548");
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u65e0\u6548");
                }
                return actCalcPriceAtomBO;
            }
            List<ActiveTemplatePO> activeTemplatePOS = this.checkTempateValid(activityChoiceAtomBO);
            if (activeTemplatePOS == null) {
                actCalcPriceAtomBO.setRespCode("1004");
                actCalcPriceAtomBO.setRespDesc("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                }
                return actCalcPriceAtomBO;
            }
            actCalcPriceAtomBO = this.calculatePriceByTemp(activeTemplatePOS, activityChoiceAtomBO, skuDetailReqAtomBO);
            if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
                return actCalcPriceAtomBO;
            }
            this.qryGifts(activityChoiceAtomBO.getActiveId(), allGiftAtomBos);
        }
        actCalcPriceAtomBO.setGiftAtomBos(allGiftAtomBos);
        return actCalcPriceAtomBO;
    }

    private boolean checkActivityValid(ActivityChoiceAtomBO activityChoiceAtomBO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        boolean isCheckSuccess = true;
        ActActivityValidCheckAtomReqBO actActivityValidCheckAtomReqBO = new ActActivityValidCheckAtomReqBO();
        actActivityValidCheckAtomReqBO.setActiveId(activityChoiceAtomBO.getActiveId());
        actActivityValidCheckAtomReqBO.setShopId(skuDetailReqAtomBO.getShopId());
        actActivityValidCheckAtomReqBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        ActActivityValidCheckAtomRspBO actActivityValidCheckAtomRspBO = this.actActivityValidCheckAtomService.checkActivityValid(actActivityValidCheckAtomReqBO);
        if (!"0000".equals(actActivityValidCheckAtomRspBO.getRespCode())) {
            isCheckSuccess = false;
        }
        return isCheckSuccess;
    }

    private List<ActiveTemplatePO> checkTempateValid(ActivityChoiceAtomBO activityChoiceAtomBO) {
        int templateNum = 2;
        ActiveTemplatePO activeTemplateModel = new ActiveTemplatePO();
        activeTemplateModel.setActiveId(activityChoiceAtomBO.getActiveId());
        List<ActiveTemplatePO> activeTemplatePOS = this.activeTemplateMapper.getList(activeTemplateModel);
        if (activeTemplatePOS == null || activeTemplatePOS.isEmpty()) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u8fd8\u672a\u914d\u7f6e\u6a21\u677f\u4fe1\u606f");
            }
            return null;
        }
        if (activeTemplatePOS.size() > templateNum) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u6240\u914d\u7f6e\u7684\u6a21\u677f\u7c7b\u578b\u5927\u4e8e2\u6761");
            }
            return null;
        }
        if (activeTemplatePOS.size() == templateNum && activeTemplatePOS.get(0).getTemplateType().equals(activeTemplatePOS.get(1).getTemplateType())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u6240\u914d\u7f6e\u7684\u6a21\u677f\u7c7b\u578b\u91cd\u590d");
            }
            return null;
        }
        return activeTemplatePOS;
    }

    private ActCalcPriceAtomBO calculatePriceByTemp(List<ActiveTemplatePO> activeTemplatePOS, ActivityChoiceAtomBO activityChoiceAtomBO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        BigDecimal disCountAmont = BigDecimal.ZERO;
        BigDecimal disSkuPrice = skuDetailReqAtomBO.getSkuPrice();
        boolean isContinueActive = true;
        for (ActiveTemplatePO activeTemplatePO : activeTemplatePOS) {
            boolean isJudgeSuccess;
            if (SECK_KILL_SKU_NO.equals(activeTemplatePO.getTemplateType()) && !(isJudgeSuccess = this.judgeCondition(activityChoiceAtomBO, activeTemplatePO, skuDetailReqAtomBO))) {
                isContinueActive = false;
            }
            if (!isContinueActive || !SECK_KILL_SKU_YES.equals(activeTemplatePO.getTemplateType())) continue;
            ActSkuDiscountRspBO actSkuDiscountRspBO = this.calculationPreferential(activityChoiceAtomBO, activeTemplatePO, skuDetailReqAtomBO, disCountAmont, disSkuPrice);
            if (!"0000".equals(actSkuDiscountRspBO.getRespCode())) {
                actCalcPriceAtomBO.setRespCode("1005");
                actCalcPriceAtomBO.setRespDesc("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u8ba1\u7b97\u4ef7\u683c\u5931\u8d25:" + actSkuDiscountRspBO.getRespDesc());
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u8ba1\u7b97\u4ef7\u683c\u5931\u8d25:" + actSkuDiscountRspBO.getRespDesc());
                }
                return actCalcPriceAtomBO;
            }
            disCountAmont = actSkuDiscountRspBO.getSkuDetailActRspAtomBO().getSkuDisAmount();
            disSkuPrice = actSkuDiscountRspBO.getSkuDetailActRspAtomBO().getSkuDisPrice();
        }
        actCalcPriceAtomBO.setRespCode("0000");
        actCalcPriceAtomBO.setDisCountAmont(disCountAmont);
        actCalcPriceAtomBO.setDisSkuPrice(disSkuPrice);
        return actCalcPriceAtomBO;
    }

    private boolean judgeCondition(ActivityChoiceAtomBO activityChoiceAtomBO, ActiveTemplatePO activeTemplatePO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        boolean isJudgeSuccess = true;
        ActSkuJudgeAtomReqBO actSkuJudgeAtomReqBO = new ActSkuJudgeAtomReqBO();
        actSkuJudgeAtomReqBO.setActId(activityChoiceAtomBO.getActiveId());
        actSkuJudgeAtomReqBO.setTemplateId(activeTemplatePO.getTemplateId());
        SkuDetailActReqAtomBO skuDetailActReqAtomBO = new SkuDetailActReqAtomBO();
        skuDetailActReqAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailActReqAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailActReqAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailActReqAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        actSkuJudgeAtomReqBO.setSkuDetailActReqAtomBO(skuDetailActReqAtomBO);
        ActSkuJudgeAtomRspBO actSkuJudgeAtomRspBO = this.actSkuJudgeAtomService.judgeOrder(actSkuJudgeAtomReqBO);
        if (!"0000".equals(actSkuJudgeAtomRspBO.getRespCode())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u5bf9\u5e94\u7684" + actSkuJudgeAtomRspBO.getRespDesc());
            }
            isJudgeSuccess = false;
        }
        return isJudgeSuccess;
    }

    private ActSkuDiscountRspBO calculationPreferential(ActivityChoiceAtomBO activityChoiceAtomBO, ActiveTemplatePO activeTemplatePO, SkuDetailReqAtomBO skuDetailReqAtomBO, BigDecimal disCountAmont, BigDecimal disPrice) {
        ActSkuDiscountReqBO actSkuDiscountReqBO = new ActSkuDiscountReqBO();
        actSkuDiscountReqBO.setActId(activityChoiceAtomBO.getActiveId());
        actSkuDiscountReqBO.setTemplateId(activeTemplatePO.getTemplateId());
        actSkuDiscountReqBO.setDisCountAmont(disCountAmont);
        SkuDetailActReqAtomBO skuDetailDiscountAtomReqBO = new SkuDetailActReqAtomBO();
        skuDetailDiscountAtomReqBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailDiscountAtomReqBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailDiscountAtomReqBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailDiscountAtomReqBO.setSkuPrice(disPrice);
        actSkuDiscountReqBO.setSkuDetailActReqAtomBO(skuDetailDiscountAtomReqBO);
        return this.actSkuDiscountAtomService.skuDiscount(actSkuDiscountReqBO);
    }

    private void qryGifts(Long activeId, List<GiftAtomBo> allGiftAtomBos) {
        ActGiftQueryAtomReqBO actGiftQueryAtomReqBO = new ActGiftQueryAtomReqBO();
        actGiftQueryAtomReqBO.setActiveId(activeId);
        ActGiftQueryAtomRspBO actGiftQueryAtomRspBO = this.actGiftQueryAtomService.queryGift(actGiftQueryAtomReqBO);
        List<GiftAtomBo> giftAtomBos = actGiftQueryAtomRspBO.getGiftList();
        if (giftAtomBos != null && !giftAtomBos.isEmpty()) {
            for (GiftAtomBo giftAtomBo : giftAtomBos) {
                Collections.addAll(allGiftAtomBos, giftAtomBo);
            }
        }
    }
}

