/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActDeleteBusiService;
import com.tydic.newretail.busi.bo.ActActDeleteBusiReqBO;
import com.tydic.newretail.busi.bo.ActActDeleteBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActDeleteBusiService")
public class ActActDeleteBusiServiceImpl
implements ActActDeleteBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActDeleteBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;

    public ActActDeleteBusiRspBO deleteActivity(ActActDeleteBusiReqBO reqBO) {
        ActActDeleteBusiRspBO rspBO = new ActActDeleteBusiRspBO();
        ActivityPO actPO = new ActivityPO();
        actPO.setActiveId(reqBO.getActiveId());
        actPO.setActiveCode(reqBO.getActiveCode());
        ActivityPO activityPO = this.activityMapper.getModelBy(actPO);
        if (null == activityPO) {
            rspBO.setRespCode("2031");
            rspBO.setRespDesc("\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (ActCommConstant.ActivityIsDelete.DELETED.equals(activityPO.getIsDelete())) {
            rspBO.setRespCode("2032");
            rspBO.setRespDesc("\u6d3b\u52a8\u5df2\u88ab\u5220\u9664");
            return rspBO;
        }
        ActivityPO activePO = new ActivityPO();
        activePO.setActiveId(activityPO.getActiveId());
        activePO.setActiveStatus(ActCommConstant.ActivityState.DISABLED);
        activePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateActResult = this.activityMapper.updateById(activePO);
        if (updateActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        ShopActivePO shopActivePO = new ShopActivePO();
        shopActivePO.setActiveId(activityPO.getActiveId());
        shopActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        int checkShop = this.shopActiveMapper.getCheckBy(shopActivePO);
        int updateShopActResult = this.shopActiveMapper.updateByCondition(shopActivePO);
        if (checkShop > 0 && updateShopActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5e97\u94fa\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activityPO.getActiveId());
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        int checkSku = this.skuActiveMapper.getCheckBy(skuActivePO);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (checkSku > 0 && updateSkuActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5355\u54c1\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u5220\u9664\u6210\u529f");
        return rspBO;
    }
}

