/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.ActGiftQueryAtomService;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.newretail.atom.bo.GiftAtomBo;
import com.tydic.newretail.busi.ActGiftNumUpdateBusiService;
import com.tydic.newretail.busi.bo.ActGiftNumUpdateBusiReqBO;
import com.tydic.newretail.busi.bo.ActGiftNumUpdateBusiRspBO;
import com.tydic.newretail.dao.ActiveGiftMapper;
import com.tydic.newretail.dao.po.ActiveGiftPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actGiftNumUpdateBusiService")
public class ActGiftNumUpdateBusiServiceImpl
implements ActGiftNumUpdateBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActGiftNumUpdateBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private static final Integer NO_LIMIT_TO_GIVING = -1;
    private static final Integer ADD_OPER = 0;
    private static final Integer REDUCE_OPER = 1;
    @Autowired
    private ActGiftQueryAtomService actGiftQueryAtomService;
    @Autowired
    private ActiveGiftMapper activeGiftMapper;

    public ActGiftNumUpdateBusiRspBO updateGiftNum(ActGiftNumUpdateBusiReqBO actGiftNumUpdateReqBO) {
        ActGiftNumUpdateBusiRspBO rspBO = new ActGiftNumUpdateBusiRspBO();
        if (actGiftNumUpdateReqBO.getOperNum() == null) {
            actGiftNumUpdateReqBO.setOperNum(Integer.valueOf(1));
        }
        if (IS_DEBUGABLE) {
            LOG.debug("\u6d3b\u52a8\u4e2d\u5fc3\u8d60\u54c1\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + actGiftNumUpdateReqBO.toString());
        }
        ActGiftQueryAtomReqBO actGiftQueryAtomReqBO = new ActGiftQueryAtomReqBO();
        actGiftQueryAtomReqBO.setActiveId(actGiftNumUpdateReqBO.getActiveId());
        actGiftQueryAtomReqBO.setSkuId(actGiftNumUpdateReqBO.getSkuId());
        ActGiftQueryAtomRspBO actGiftQueryAtomRspBO = this.actGiftQueryAtomService.queryGift(actGiftQueryAtomReqBO);
        List<GiftAtomBo> giftAtomBos = actGiftQueryAtomRspBO.getGiftList();
        if (giftAtomBos == null || giftAtomBos.isEmpty()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8d60\u54c1\u4fe1\u606f");
            return rspBO;
        }
        if (giftAtomBos.size() > 1) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u7684\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u914d\u7f6e\u4fe1\u606f\u4e0d\u552f\u4e00");
            return rspBO;
        }
        GiftAtomBo giftAtomBo = giftAtomBos.get(0);
        Integer giftCount = giftAtomBo.getGiftCount();
        Integer sendCount = giftAtomBo.getSendCount();
        if (giftCount == null) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u7684\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u672a\u914d\u7f6e\u8d60\u9001\u6570\u91cf");
            return rspBO;
        }
        if (NO_LIMIT_TO_GIVING.equals(giftCount)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u7684\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u6570\u91cf\u914d\u7f6e\u4e3a\u65e0\u9650\u5236\uff0c\u65e0\u9700\u66f4\u65b0");
            return rspBO;
        }
        Integer operNum = actGiftNumUpdateReqBO.getOperNum();
        if (ADD_OPER.equals(actGiftNumUpdateReqBO.getOperType())) {
            if (giftCount < sendCount + operNum) {
                rspBO.setRespCode("2004");
                rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u5f53\u524d\u8d60\u9001\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u6570\u91cf\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u7684\u53ef\u8d60\u9001\u6570\u91cf");
                return rspBO;
            }
            giftAtomBo.setSendCount(sendCount + operNum);
        } else if (REDUCE_OPER.equals(actGiftNumUpdateReqBO.getOperType())) {
            if (sendCount - operNum < 0) {
                rspBO.setRespCode("2004");
                rspBO.setRespDesc("\u6d3b\u52a8[" + actGiftNumUpdateReqBO.getActiveId() + "]\u5f53\u524d\u8fd4\u8fd8\u8d60\u54c1[" + actGiftNumUpdateReqBO.getSkuId() + "]\u6570\u91cf\u5df2\u8d85\u8fc7\u5df2\u8d60\u9001\u51fa\u53bb\u7684\u6570\u91cf");
                return rspBO;
            }
            giftAtomBo.setSendCount(sendCount - operNum);
        }
        ActiveGiftPO activeGiftModel = new ActiveGiftPO();
        activeGiftModel.setActiveId(actGiftNumUpdateReqBO.getActiveId());
        activeGiftModel.setSkuId(actGiftNumUpdateReqBO.getSkuId());
        activeGiftModel.setSendCount(giftAtomBo.getSendCount());
        int updateResult = this.activeGiftMapper.updateById(activeGiftModel);
        if (updateResult < 1) {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("\u66f4\u65b0\u5df2\u8d60\u9001\u8d60\u54c1\u6570\u91cf\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u66f4\u65b0\u5df2\u8d60\u9001\u8d60\u54c1\u6570\u91cf\u6210\u529f");
        return rspBO;
    }
}

