/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActStartStopBusiService;
import com.tydic.newretail.busi.bo.ActActStartStopBusiReqBO;
import com.tydic.newretail.busi.bo.ActActStartStopBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActStartStopBusiService")
public class ActActStartStopBusiServiceImpl
implements ActActStartStopBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActStartStopBusiServiceImpl.class);
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActivityMapper activityMapper;

    public ActActStartStopBusiRspBO dealStartStop(ActActStartStopBusiReqBO busiReqBO) {
        ActivityPO activityPO;
        ActActStartStopBusiRspBO rsp = new ActActStartStopBusiRspBO();
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getActiveCode())) {
            activityPO = new ActivityPO();
            activityPO.setActiveCode(busiReqBO.getActiveCode());
            activityPO.setActiveId(busiReqBO.getActiveId());
            ActivityPO activity = this.activityMapper.getModelBy(activityPO);
            if (null == activity) {
                LOG.error("6002", (Object)"\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6839\u636eactiveCode + activeId\u67e5\u8be2\u6d3b\u52a8\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
                throw new BusinessException("6002", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6839\u636eactiveCode + activeId\u67e5\u8be2\u6d3b\u52a8\u8868\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            busiReqBO.setActiveId(activity.getActiveId());
        }
        if (!StringUtils.isBlank((CharSequence)busiReqBO.getSkuId()) && null != busiReqBO.getShopId()) {
            SkuActivePO skuActivePO = new SkuActivePO();
            BeanUtils.copyProperties((Object)busiReqBO, (Object)skuActivePO);
            skuActivePO.setStatus(this.startOrStop(busiReqBO.getOperType()));
            this.updateSkuActive(skuActivePO);
        } else if (StringUtils.isBlank((CharSequence)busiReqBO.getSkuId()) && null != busiReqBO.getShopId()) {
            ShopActivePO shopActivePO = new ShopActivePO();
            BeanUtils.copyProperties((Object)busiReqBO, (Object)shopActivePO);
            shopActivePO.setStatus(this.startOrStop(busiReqBO.getOperType()));
            this.updateShopActive(shopActivePO);
        } else if (StringUtils.isBlank((CharSequence)busiReqBO.getSkuId()) && null == busiReqBO.getShopId()) {
            activityPO = new ActivityPO();
            BeanUtils.copyProperties((Object)busiReqBO, (Object)activityPO);
            activityPO.setActiveStatus(this.startOrStop(busiReqBO.getOperType()));
            this.updateActive(activityPO);
        } else {
            LOG.error("6002", (Object)"\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u9700\u8981\u542f\u505c\u7684\u6d3b\u52a8\u672a\u77e5\uff01");
            throw new BusinessException("6002", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u9700\u8981\u542f\u505c\u7684\u6d3b\u52a8\u672a\u77e5\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }

    private Integer startOrStop(Integer operType) {
        Integer status;
        switch (operType) {
            case 0: {
                status = ActCommConstant.ActiveStartStop.START;
                break;
            }
            case 1: {
                status = ActCommConstant.ActiveStartStop.STOP;
                break;
            }
            default: {
                LOG.error("6002", (Object)"\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
                throw new BusinessException("6002", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b\uff01");
            }
        }
        return status;
    }

    private void updateActive(ActivityPO activityPO) {
        int isUpdate = this.activityMapper.updateById(activityPO);
        if (isUpdate < 1) {
            LOG.error("6002", (Object)"\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
            throw new BusinessException("6002", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateShopActive(ShopActivePO shopActivePO) {
        int isUpdate = this.shopActiveMapper.updateByCondition(shopActivePO);
        if (isUpdate < 1) {
            LOG.error("6002", (Object)"\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
            throw new BusinessException("6002", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
        }
    }

    private void updateSkuActive(SkuActivePO skuActivePO) {
        int isUpdate = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (isUpdate < 1) {
            LOG.error("6002", (Object)"\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
            throw new BusinessException("6002", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u5931\u8d25\uff01\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
        }
    }
}

