/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActActivityValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActivityValidCheckAtomService")
public class ActActivityValidCheckAtomServiceImpl
implements ActActivityValidCheckAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActivityValidCheckAtomServiceImpl.class);
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActivityMapper activityMapper;

    @Override
    public ActActivityValidCheckAtomRspBO checkActivityValid(ActActivityValidCheckAtomReqBO atomReqBO) {
        if (null == atomReqBO.getActiveId()) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ActiveId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == atomReqBO.getShopId()) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ShopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActActivityValidCheckAtomRspBO rsp = new ActActivityValidCheckAtomRspBO();
        ActivityPO activityPO = new ActivityPO();
        activityPO.setActiveId(atomReqBO.getActiveId());
        activityPO.setActiveStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        ActivityPO activity = this.activityMapper.getModelBy(activityPO);
        if (null == activity) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u6d3b\u52a8\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (!StringUtils.isBlank((CharSequence)atomReqBO.getSkuId())) {
            SkuActivePO skuActivePO = new SkuActivePO();
            BeanUtils.copyProperties((Object)atomReqBO, (Object)skuActivePO);
            skuActivePO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
            skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            List<SkuActivePO> skuActivePOList = this.skuActiveMapper.getListByCheck(skuActivePO);
            if (null == skuActivePOList || skuActivePOList.size() <= 0) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rsp;
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u8868\u67e5\u8be2\u7ed3\u679c\u6709\u6570\u636e\uff01");
            return rsp;
        }
        ShopActivePO shopActivePO = new ShopActivePO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)shopActivePO);
        shopActivePO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        List<ShopActivePO> shopActivePOList = this.shopActiveMapper.getListByCheck(shopActivePO);
        if (null == shopActivePOList || shopActivePOList.size() <= 0) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u8868\u67e5\u8be2\u7ed3\u679c\u6709\u6570\u636e\uff01");
        return rsp;
    }
}

