/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActCreateActivityAtomService;
import com.tydic.newretail.atom.bo.ActCreateActivityAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityAtomRspBO;
import com.tydic.newretail.atom.bo.ActiveAttributeAtomBO;
import com.tydic.newretail.atom.bo.ActiveGiftAtomBO;
import com.tydic.newretail.atom.bo.ActiveTemplateAtomBO;
import com.tydic.newretail.atom.bo.ShopActiveAtomBO;
import com.tydic.newretail.atom.bo.SkuActiveAtomBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.ActiveGiftMapper;
import com.tydic.newretail.dao.ActiveTemplateMapper;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import com.tydic.newretail.dao.po.ActiveGiftPO;
import com.tydic.newretail.dao.po.ActiveTemplatePO;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateActivityAtomService")
public class ActCreateActivityAtomServiceImpl
implements ActCreateActivityAtomService {
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private ActiveAttrMapper ActiveAttrMapper;
    @Autowired
    private ActiveGiftMapper activeGiftMapper;
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActiveTemplateMapper activeTemplateMapper;

    @Override
    public ActCreateActivityAtomRspBO createActivity(ActCreateActivityAtomReqBO reqBO) {
        ActCreateActivityAtomRspBO rsp = new ActCreateActivityAtomRspBO();
        ActivityPO activityPO = new ActivityPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityPO);
        Date now = new Date();
        activityPO.setCreateTime(now);
        activityPO.setUpdateTime(now);
        activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int activityInsertResult = this.activityMapper.insert(activityPO);
        if (activityInsertResult <= 0) {
            rsp.setRespCode("1013");
            rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
            return rsp;
        }
        if (CollectionUtils.isNotEmpty(reqBO.getActiveAttributeList())) {
            for (ActiveAttributeAtomBO activeAttributeAtomBO : reqBO.getActiveAttributeList()) {
                ActiveAttrPO activeAttrPO = new ActiveAttrPO();
                BeanUtils.copyProperties((Object)activeAttributeAtomBO, (Object)activeAttrPO);
                activeAttrPO.setActiveId(activityPO.getActiveId());
                int activityAttrInsertResult = this.ActiveAttrMapper.insert(activeAttrPO);
                if (activityAttrInsertResult > 0) continue;
                rsp.setRespCode("1013");
                rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u5c5e\u6027\u8868\u5931\u8d25\uff01");
                return rsp;
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getActiveGiftList())) {
            for (ActiveGiftAtomBO activeGiftAtomBO : reqBO.getActiveGiftList()) {
                ActiveGiftPO activeGiftPO = new ActiveGiftPO();
                BeanUtils.copyProperties((Object)activeGiftAtomBO, (Object)activeGiftPO);
                activeGiftPO.setActiveId(activityPO.getActiveId());
                int activityGiftInsertResult = this.activeGiftMapper.insert(activeGiftPO);
                if (activityGiftInsertResult > 0) continue;
                rsp.setRespCode("1013");
                rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u8d60\u54c1\u8868\u5931\u8d25\uff01");
                return rsp;
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getActiveSkuList())) {
            for (SkuActiveAtomBO skuActiveAtomBO : reqBO.getActiveSkuList()) {
                int activeSkuInsertResult;
                SkuActivePO skuActivePO = new SkuActivePO();
                BeanUtils.copyProperties((Object)skuActiveAtomBO, (Object)skuActivePO);
                skuActivePO.setActiveId(activityPO.getActiveId());
                if (null == skuActivePO.getSaleCount()) {
                    skuActivePO.setSaleCount(ActCommConstant.SALE_COUNT_DEFAULT_VALUE);
                }
                if (null == skuActivePO.getActCount()) {
                    skuActivePO.setActCount(ActCommConstant.ACT_COUNT_DEFAULT_VALUE);
                }
                if ((activeSkuInsertResult = this.skuActiveMapper.insert(skuActivePO)) > 0) continue;
                rsp.setRespCode("1013");
                rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u5355\u54c1\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
                return rsp;
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getShopActiveList())) {
            for (ShopActiveAtomBO shopActiveAtomBO : reqBO.getShopActiveList()) {
                int shopActiveInsertResult;
                ShopActivePO shopActivePO = new ShopActivePO();
                BeanUtils.copyProperties((Object)shopActiveAtomBO, (Object)shopActivePO);
                shopActivePO.setActiveId(activityPO.getActiveId());
                if (null == shopActivePO.getSaleCount()) {
                    shopActivePO.setSaleCount(ActCommConstant.SALE_COUNT_DEFAULT_VALUE);
                }
                if (null == shopActivePO.getActCount()) {
                    shopActivePO.setActCount(ActCommConstant.ACT_COUNT_DEFAULT_VALUE);
                }
                if ((shopActiveInsertResult = this.shopActiveMapper.insert(shopActivePO)) > 0) continue;
                rsp.setRespCode("1013");
                rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u5e97\u94fa\u6d3b\u52a8\u8868\u5931\u8d25\uff01");
                return rsp;
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getActiveTemplateList())) {
            for (ActiveTemplateAtomBO activeTemplateAtomBO : reqBO.getActiveTemplateList()) {
                ActiveTemplatePO activeTemplatePO = new ActiveTemplatePO();
                BeanUtils.copyProperties((Object)activeTemplateAtomBO, (Object)activeTemplatePO);
                activeTemplatePO.setActiveId(activityPO.getActiveId());
                int activeTemplateInsertResult = this.activeTemplateMapper.insert(activeTemplatePO);
                if (activeTemplateInsertResult > 0) continue;
                rsp.setRespCode("1013");
                rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u8bb0\u5f55\u6d3b\u52a8\u6a21\u677f\u8868\u5931\u8d25\uff01");
                return rsp;
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u521b\u5efa\u6210\u529f");
        return rsp;
    }
}

