/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActOrderJudgeAtomService;
import com.tydic.newretail.atom.bo.ActOrderJudgeAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderJudgeAtomRspBO;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actOrderJudgeAtomService")
public class ActOrderJudgeAtomServiceImpl
implements ActOrderJudgeAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(ActOrderJudgeAtomServiceImpl.class);
    private static final Long TOTAL_ARRIVE_TEMPLATE = 100001L;
    @Autowired
    private ActiveAttrMapper activeAttrMapper;

    @Override
    public ActOrderJudgeAtomRspBO judgeOrder(ActOrderJudgeAtomReqBO atomReqBO) {
        ActOrderJudgeAtomRspBO rsp = new ActOrderJudgeAtomRspBO();
        if (TOTAL_ARRIVE_TEMPLATE.equals(atomReqBO.getTemplateId())) {
            if (null == atomReqBO.getTotalAmount() || atomReqBO.getTotalAmount().compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal totalAmount = new BigDecimal(0);
                for (SkuDetailActReqAtomBO bo : atomReqBO.getSkuDetailAtomList()) {
                    totalAmount = totalAmount.add(bo.getSkuPrice().multiply(bo.getSkuNum()));
                }
                atomReqBO.setTotalAmount(totalAmount);
            }
            ActiveAttrPO activeAttrPO = new ActiveAttrPO();
            activeAttrPO.setActiveId(atomReqBO.getActiveId());
            activeAttrPO.setTemplateId(TOTAL_ARRIVE_TEMPLATE);
            activeAttrPO.setParaCode("total_fee_reach");
            ActiveAttrPO activeAttr = this.activeAttrMapper.getModelBy(activeAttrPO);
            if (null == activeAttr || StringUtils.isBlank((CharSequence)activeAttr.getParaValue())) {
                LOG.error("\u6d3b\u52a8\u5c5e\u6027\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u6d3b\u52a8\u5c5e\u6027\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rsp;
            }
            BigDecimal A1 = new BigDecimal(activeAttr.getParaValue());
            BigDecimal mulNum = atomReqBO.getTotalAmount().divide(A1, 0, 1);
            if (mulNum.compareTo(BigDecimal.ONE) >= 0) {
                Integer mulCount = mulNum.intValue();
                rsp.setMulCount(mulCount);
                rsp.setRespCode("0000");
                rsp.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u6761\u4ef6\u5224\u65ad\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
                return rsp;
            }
            LOG.error("\u8ba1\u7b97\u51fa\u7684\u500d\u6570 <= 1");
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u8ba1\u7b97\u51fa\u7684\u500d\u6570 <= 1");
            return rsp;
        }
        rsp.setRespCode("8888");
        LOG.error("\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248\uff01");
        rsp.setRespDesc("\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248\uff01");
        return rsp;
    }
}

