/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActOrderDiscountAtomService;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomRspBO;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actOrderDiscountAtomService")
public class ActOrderDiscountAtomServiceImpl
implements ActOrderDiscountAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(ActOrderDiscountAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    private ActiveAttrMapper activeAttrMapper;

    @Autowired
    public ActOrderDiscountAtomServiceImpl(ActiveAttrMapper activeAttrMapper) {
        this.activeAttrMapper = activeAttrMapper;
    }

    @Override
    public ActOrderDiscountAtomRspBO orderDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOG.debug("\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u8ba2\u5355\u4f18\u60e0\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + atomReqBO.toString());
        }
        String preNotice = "\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u7ed3\u679c\uff1a";
        ActOrderDiscountAtomRspBO rsp = new ActOrderDiscountAtomRspBO();
        if (null == atomReqBO.getTotalAmount() || atomReqBO.getTotalAmount().compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal totalAmount = new BigDecimal(0);
            for (SkuDetailActReqAtomBO bo : atomReqBO.getSkuDetailAtomList()) {
                totalAmount = totalAmount.add(bo.getSkuPrice().multiply(bo.getSkuNum()));
            }
            atomReqBO.setTotalAmount(totalAmount);
        }
        if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID.equals(atomReqBO.getTemplateId())) {
            rsp = this.buildAftCalculationRspBO(atomReqBO, "total_fee_discount");
        } else if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID.equals(atomReqBO.getTemplateId())) {
            rsp = this.buildAftCalculationRspBO(atomReqBO, "total_fee_discount_rate");
        } else {
            if (IS_DEBUG_ENABLED) {
                LOG.error(preNotice + "\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248[" + atomReqBO.getTemplateId() + "]\uff01");
            }
            rsp.setRespCode("1008");
            rsp.setRespDesc(preNotice + "\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248[" + atomReqBO.getTemplateId() + "]\uff01");
            return rsp;
        }
        return rsp;
    }

    private ActOrderDiscountAtomRspBO buildAftCalculationRspBO(ActOrderDiscountAtomReqBO atomReqBO, String paramCode) {
        ActOrderDiscountAtomRspBO rspBO = new ActOrderDiscountAtomRspBO();
        String queryActAttrErrorMsg = "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8[" + atomReqBO.getActiveId() + "]";
        rspBO.setRespCode("1009");
        ActiveAttrPO activeAttr = this.qryActiveAttrPO(atomReqBO.getActiveId(), atomReqBO.getTemplateId(), paramCode);
        if (null == activeAttr || StringUtils.isEmpty((CharSequence)activeAttr.getParaValue())) {
            rspBO.setRespDesc(queryActAttrErrorMsg + "\u5728\u6d3b\u52a8\u5c5e\u6027\u8868\u4e2d\u7684\u914d\u7f6e\u4fe1\u606f\u6216\u8005\u672a\u914d\u7f6e\u6d3b\u52a8\u5c5e\u6027\u7684value\u503c");
            return rspBO;
        }
        String paramValue = activeAttr.getParaValue();
        String spectialParmaValue = null;
        if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID.equals(atomReqBO.getTemplateId())) {
            ActiveAttrPO specialActiveAttr = this.qryActiveAttrPO(atomReqBO.getActiveId(), atomReqBO.getTemplateId(), "accumulate_flag");
            if (specialActiveAttr == null || StringUtils.isEmpty((CharSequence)specialActiveAttr.getParaValue())) {
                rspBO.setRespDesc(queryActAttrErrorMsg + "\u5728\u6d3b\u52a8\u5c5e\u6027\u8868\u4e2d\u662f\u5426\u7d2f\u52a0\u7684\u914d\u7f6e\u4fe1\u606f\u6216\u8005\u672a\u914d\u7f6e\u6d3b\u52a8\u5c5e\u6027\u7684value\u503c");
                return rspBO;
            }
            spectialParmaValue = specialActiveAttr.getParaValue();
        }
        Map<String, BigDecimal> disPriceMap = this.calculateReducedPrice(atomReqBO.getTemplateId(), paramValue, spectialParmaValue, atomReqBO.getMulCount(), atomReqBO.getTotalAmount(), atomReqBO.getDisTotalAmo());
        rspBO.setTotalAmount(disPriceMap.get("totalAmount"));
        rspBO.setDisTotalAmo(disPriceMap.get("disTotalAmo"));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private ActiveAttrPO qryActiveAttrPO(Long activeId, Long tempLateId, String paraCode) {
        ActiveAttrPO activeAttrPO = new ActiveAttrPO();
        activeAttrPO.setActiveId(activeId);
        activeAttrPO.setTemplateId(tempLateId);
        activeAttrPO.setParaCode(paraCode);
        return this.activeAttrMapper.getModelBy(activeAttrPO);
    }

    private Map<String, BigDecimal> calculateReducedPrice(Long templateId, String activityParaValue, String specialActiveParaValue, Integer mulCount, BigDecimal totalAmount, BigDecimal disTotalAmo) {
        Map<String, BigDecimal> disPriceMap = null;
        if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID.equals(templateId)) {
            disPriceMap = this.calculateCashDiscount(new BigDecimal(activityParaValue), specialActiveParaValue, mulCount, totalAmount, disTotalAmo);
        } else if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID.equals(templateId)) {
            disPriceMap = this.calculateDiscount(new BigDecimal(activityParaValue), totalAmount, disTotalAmo);
        }
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateCashDiscount(BigDecimal configDisTotalAmo, String cumulativeFlag, Integer mulCount, BigDecimal totalAmount, BigDecimal disTotalAmo) {
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(2);
        if (Integer.valueOf(cumulativeFlag) == 1) {
            BigDecimal newDisTotalAmo = configDisTotalAmo.multiply(BigDecimal.valueOf(mulCount.intValue()));
            BigDecimal newTotalAmount = totalAmount.subtract(newDisTotalAmo);
            calculatePrice.put("totalAmount", newTotalAmount);
            if (null != disTotalAmo) {
                newDisTotalAmo = newDisTotalAmo.add(disTotalAmo);
            }
            calculatePrice.put("disTotalAmo", newDisTotalAmo);
        } else {
            calculatePrice.put("totalAmount", totalAmount);
            calculatePrice.put("disTotalAmo", disTotalAmo);
        }
        return calculatePrice;
    }

    private Map<String, BigDecimal> calculateDiscount(BigDecimal configDiscount, BigDecimal totalAmount, BigDecimal disTotalAmo) {
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(2);
        BigDecimal newDisTotalAmo = totalAmount.subtract(totalAmount.multiply(configDiscount));
        calculatePrice.put("totalAmount", totalAmount.subtract(newDisTotalAmo));
        if (null != disTotalAmo) {
            newDisTotalAmo = newDisTotalAmo.add(disTotalAmo);
        }
        calculatePrice.put("disTotalAmo", newDisTotalAmo);
        return calculatePrice;
    }
}

