/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActCreateActivityAtomService;
import com.tydic.newretail.atom.bo.ActCreateActivityAtomReqBO;
import com.tydic.newretail.atom.bo.ActCreateActivityAtomRspBO;
import com.tydic.newretail.atom.bo.ActiveAttributeAtomBO;
import com.tydic.newretail.atom.bo.ActiveGiftAtomBO;
import com.tydic.newretail.atom.bo.ActiveGiftPkgAtomBO;
import com.tydic.newretail.atom.bo.ActiveTemplateAtomBO;
import com.tydic.newretail.atom.bo.ShopActiveAtomBO;
import com.tydic.newretail.atom.bo.SkuActiveAtomBO;
import com.tydic.newretail.busi.ActCreateActivityBusiService;
import com.tydic.newretail.busi.bo.ActCreateActivityBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateActivityBusiRspBO;
import com.tydic.newretail.busi.bo.ActiveGiftBusiBO;
import com.tydic.newretail.busi.bo.ActiveGiftPkgBusiBO;
import com.tydic.newretail.busi.bo.ShopActiveBusiBO;
import com.tydic.newretail.busi.bo.SkuActiveBusiBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ParamMapper;
import com.tydic.newretail.dao.TemplateMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ParamPO;
import com.tydic.newretail.dao.po.TemplatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateActivityBusiService")
public class ActCreateActivityBusiServiceImpl
implements ActCreateActivityBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateActivityBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Autowired
    ActCreateActivityAtomService actCreateActivityAtomService;
    @Autowired
    TemplateMapper templateMapper;
    @Autowired
    ParamMapper paramMapper;
    @Autowired
    ActivityMapper activityMapper;

    public ActCreateActivityBusiRspBO createActivity(ActCreateActivityBusiReqBO reqBO) {
        int checkId;
        ActCreateActivityBusiRspBO rspBO = new ActCreateActivityBusiRspBO();
        ActivityPO activityPO = new ActivityPO();
        activityPO.setActiveCode(reqBO.getActiveCode());
        activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int checkCode = this.activityMapper.getCheckBy(activityPO);
        if (checkCode > 0) {
            rspBO.setRespCode("2021");
            rspBO.setRespDesc("\u8be5\u6d3b\u52a8\u5df2\u5b58\u5728");
            return rspBO;
        }
        if (null != reqBO.getActiveId() && (checkId = this.activityMapper.getCheckById(reqBO.getActiveId())) > 0) {
            rspBO.setRespCode("2021");
            rspBO.setRespDesc("\u8be5\u6d3b\u52a8ID\u5df2\u5b58\u5728");
            return rspBO;
        }
        ActCreateActivityAtomReqBO atomReqBO = this.generateAtomReqBO(reqBO);
        if ("10".equals(reqBO.getActiveType())) {
            this.setFullSubAtomReqBO(atomReqBO, reqBO);
        } else if ("11".equals(reqBO.getActiveType())) {
            this.setFullGiftAtomReqBO(atomReqBO, reqBO);
        } else if ("12".equals(reqBO.getActiveType())) {
            this.setFullDiscountAtomReqBO(atomReqBO, reqBO);
        } else if ("13".equals(reqBO.getActiveType())) {
            this.setSingleSubAtomReqBO(atomReqBO, reqBO);
        } else if (!"14".equals(reqBO.getActiveType())) {
            if ("15".equals(reqBO.getActiveType())) {
                this.setSingleDiscount(atomReqBO, reqBO);
            } else if ("16".equals(reqBO.getActiveType())) {
                this.setSingleDiscountSub(atomReqBO, reqBO);
            } else if ("17".equals(reqBO.getActiveType())) {
                this.setSingleRedefinePrice(atomReqBO, reqBO);
            } else {
                rspBO.setRespCode("2022");
                rspBO.setRespDesc("\u672a\u77e5\u7684\u6d3b\u52a8\u7c7b\u578b");
                return rspBO;
            }
        }
        ActCreateActivityAtomRspBO atomRspBO = this.actCreateActivityAtomService.createActivity(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6d3b\u52a8\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff01" + atomRspBO.getRespDesc());
            }
            throw new BusinessException("6011", atomRspBO.getRespDesc());
        }
        rspBO.setRespCode(atomRspBO.getRespCode());
        rspBO.setRespDesc(atomRspBO.getRespDesc());
        return rspBO;
    }

    private ActCreateActivityAtomReqBO generateAtomReqBO(ActCreateActivityBusiReqBO reqBO) {
        Date now;
        ActCreateActivityAtomReqBO atomReqBO = new ActCreateActivityAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)atomReqBO);
        atomReqBO.setActiveAttributeList(new ArrayList<ActiveAttributeAtomBO>());
        atomReqBO.setActiveTemplateList(new ArrayList<ActiveTemplateAtomBO>());
        if (null == atomReqBO.getActiveStatus()) {
            atomReqBO.setActiveStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getActiveGiftList())) {
            ArrayList<ActiveGiftAtomBO> activeGiftAtomBOList = new ArrayList<ActiveGiftAtomBO>();
            for (ActiveGiftBusiBO activeGiftBusiBO : reqBO.getActiveGiftList()) {
                ActiveGiftAtomBO activeGiftAtomBO = new ActiveGiftAtomBO();
                BeanUtils.copyProperties((Object)activeGiftBusiBO, (Object)activeGiftAtomBO);
                activeGiftAtomBOList.add(activeGiftAtomBO);
            }
            atomReqBO.setActiveGiftList(activeGiftAtomBOList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getActiveGiftPkgList())) {
            ArrayList<ActiveGiftPkgAtomBO> activeGiftPkgAtomBOList = new ArrayList<ActiveGiftPkgAtomBO>();
            for (ActiveGiftPkgBusiBO activeGiftPkgBusiBO : reqBO.getActiveGiftPkgList()) {
                ActiveGiftPkgAtomBO activeGiftPkgAtomBO = new ActiveGiftPkgAtomBO();
                BeanUtils.copyProperties((Object)activeGiftPkgBusiBO, (Object)activeGiftPkgAtomBO);
                ArrayList<ActiveGiftAtomBO> activeGiftAtomBOList = new ArrayList<ActiveGiftAtomBO>();
                for (ActiveGiftBusiBO activeGiftBusiBO : activeGiftPkgBusiBO.getGiftList()) {
                    ActiveGiftAtomBO activeGiftAtomBO = new ActiveGiftAtomBO();
                    BeanUtils.copyProperties((Object)activeGiftBusiBO, (Object)activeGiftAtomBO);
                    activeGiftAtomBOList.add(activeGiftAtomBO);
                }
                activeGiftPkgAtomBO.setGiftList(activeGiftAtomBOList);
                activeGiftPkgAtomBOList.add(activeGiftPkgAtomBO);
            }
            atomReqBO.setActiveGiftPkgList(activeGiftPkgAtomBOList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getShopActiveList())) {
            ArrayList<ShopActiveAtomBO> shopActiveAtomBOList = new ArrayList<ShopActiveAtomBO>();
            for (ShopActiveBusiBO shopActiveBusiBO : reqBO.getShopActiveList()) {
                ShopActiveAtomBO shopActiveAtomBO = new ShopActiveAtomBO();
                BeanUtils.copyProperties((Object)shopActiveBusiBO, (Object)shopActiveAtomBO);
                shopActiveAtomBO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                if (null == shopActiveAtomBO.getStartTime() && null == shopActiveAtomBO.getStatus()) {
                    shopActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                }
                if (null != shopActiveAtomBO.getStartTime() && null == shopActiveAtomBO.getStatus()) {
                    now = new Date();
                    if (null != shopActiveAtomBO.getEndTime()) {
                        if (now.after(shopActiveAtomBO.getStartTime()) && now.before(shopActiveAtomBO.getEndTime())) {
                            shopActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                        } else {
                            shopActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                        }
                    } else if (now.after(shopActiveAtomBO.getStartTime())) {
                        shopActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                    } else {
                        shopActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                    }
                }
                shopActiveAtomBOList.add(shopActiveAtomBO);
            }
            atomReqBO.setShopActiveList(shopActiveAtomBOList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getActiveSkuList())) {
            ArrayList<SkuActiveAtomBO> skuActiveAtomBOList = new ArrayList<SkuActiveAtomBO>();
            for (SkuActiveBusiBO skuActiveBusiBO : reqBO.getActiveSkuList()) {
                SkuActiveAtomBO skuActiveAtomBO = new SkuActiveAtomBO();
                BeanUtils.copyProperties((Object)skuActiveBusiBO, (Object)skuActiveAtomBO);
                skuActiveAtomBO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
                if (null == skuActiveAtomBO.getStartTime() && null == skuActiveAtomBO.getStatus()) {
                    skuActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                }
                if (null != skuActiveAtomBO.getStartTime() && null == skuActiveAtomBO.getStatus()) {
                    now = new Date();
                    if (null != skuActiveAtomBO.getEndTime()) {
                        if (now.after(skuActiveAtomBO.getStartTime()) && now.before(skuActiveAtomBO.getEndTime())) {
                            skuActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                        } else {
                            skuActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                        }
                    } else if (now.after(skuActiveAtomBO.getStartTime())) {
                        skuActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
                    } else {
                        skuActiveAtomBO.setStatus(ActCommConstant.ActivityState.STATE_INVALID);
                    }
                }
                skuActiveAtomBOList.add(skuActiveAtomBO);
            }
            atomReqBO.setActiveSkuList(skuActiveAtomBOList);
        }
        return atomReqBO;
    }

    private void setFullSubAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(reqBO.getActiveId());
        activeAttributeAtomBO1.setParaName(templatePO1.getTemplateName());
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activeAttributeAtomBO1.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(atomReqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO2.setActiveId(reqBO.getActiveId());
        ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_discount");
        if (null != paramPO2) {
            activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
        }
        activeAttributeAtomBO2.setParaCode("total_fee_discount");
        activeAttributeAtomBO2.setParaValue(reqBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO3 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO3.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO3.setActiveId(reqBO.getActiveId());
        ParamPO paramPO3 = this.paramMapper.getModelById("accumulate_flag");
        if (null != paramPO3) {
            activeAttributeAtomBO3.setParaName(paramPO3.getParaName());
        }
        activeAttributeAtomBO3.setParaCode("accumulate_flag");
        activeAttributeAtomBO3.setParaValue(reqBO.getAccumulateFlag());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO3);
    }

    private void setFullGiftAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("total_fee_reach");
        activeAttributeAtomBO.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setFullDiscountAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO1 = new ActiveTemplateAtomBO();
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        activeTemplateAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeTemplateAtomBO1.setTemplateType(templatePO1.getTemplateType() + "");
        activeTemplateAtomBO1.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO1.getTemplateId());
        activeAttributeAtomBO1.setActiveId(reqBO.getActiveId());
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("total_fee_reach");
        activeAttributeAtomBO1.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveTemplateAtomBO activeTemplateAtomBO2 = new ActiveTemplateAtomBO();
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID);
        activeTemplateAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeTemplateAtomBO2.setTemplateType(templatePO2.getTemplateType() + "");
        activeTemplateAtomBO2.setActiveId(atomReqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO2);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO2.getTemplateId());
        activeAttributeAtomBO2.setActiveId(reqBO.getActiveId());
        ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_discount_rate");
        if (null != paramPO2) {
            activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
        }
        activeAttributeAtomBO2.setParaCode("total_fee_discount_rate");
        activeAttributeAtomBO2.setParaValue(reqBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
    }

    private void setSingleSubAtomReqBO(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("sku_price_discount");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("sku_price_discount");
        activeAttributeAtomBO.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setSingleDiscount(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("sku_price_discount_rate");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("sku_price_discount_rate");
        activeAttributeAtomBO.setParaValue(reqBO.getTotalFeeReach());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }

    private void setSingleDiscountSub(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_AFT_DCT_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO1 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO1.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO1.setActiveId(reqBO.getActiveId());
        ParamPO paramPO1 = this.paramMapper.getModelById("sku_price_discount");
        if (null != paramPO1) {
            activeAttributeAtomBO1.setParaName(paramPO1.getParaName());
        }
        activeAttributeAtomBO1.setParaCode("sku_price_discount");
        activeAttributeAtomBO1.setParaValue(reqBO.getFeeDiscount());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO1);
        ActiveAttributeAtomBO activeAttributeAtomBO2 = new ActiveAttributeAtomBO();
        activeAttributeAtomBO2.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO2.setActiveId(reqBO.getActiveId());
        ParamPO paramPO2 = this.paramMapper.getModelById("sku_price_discount_rate");
        if (null != paramPO2) {
            activeAttributeAtomBO2.setParaName(paramPO2.getParaName());
        }
        activeAttributeAtomBO2.setParaCode("sku_price_discount_rate");
        activeAttributeAtomBO2.setParaValue(reqBO.getDiscountRate());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO2);
    }

    private void setSingleRedefinePrice(ActCreateActivityAtomReqBO atomReqBO, ActCreateActivityBusiReqBO reqBO) {
        ActiveTemplateAtomBO activeTemplateAtomBO = new ActiveTemplateAtomBO();
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.SGL_PRD_DEFINE_PRICE_TEMP_ID);
        activeTemplateAtomBO.setTemplateId(templatePO.getTemplateId());
        activeTemplateAtomBO.setTemplateType(templatePO.getTemplateType() + "");
        activeTemplateAtomBO.setActiveId(reqBO.getActiveId());
        atomReqBO.getActiveTemplateList().add(activeTemplateAtomBO);
        ActiveAttributeAtomBO activeAttributeAtomBO = new ActiveAttributeAtomBO();
        activeAttributeAtomBO.setTemplateId(templatePO.getTemplateId());
        activeAttributeAtomBO.setActiveId(reqBO.getActiveId());
        ParamPO paramPO = this.paramMapper.getModelById("sku_price_redefine");
        if (null != paramPO) {
            activeAttributeAtomBO.setParaName(paramPO.getParaName());
        }
        activeAttributeAtomBO.setParaCode("sku_price_redefine");
        activeAttributeAtomBO.setParaValue(reqBO.getRedefinePrice());
        atomReqBO.getActiveAttributeList().add(activeAttributeAtomBO);
    }
}

