/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActOrderDiscountAtomService;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomRspBO;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actOrderDiscountAtomService")
public class ActOrderDiscountAtomServiceImpl
implements ActOrderDiscountAtomService {
    private ActiveAttrMapper activeAttrMapper;

    @Autowired
    public ActOrderDiscountAtomServiceImpl(ActiveAttrMapper activeAttrMapper) {
        this.activeAttrMapper = activeAttrMapper;
    }

    @Override
    public ActOrderDiscountAtomRspBO orderDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        Map<String, BigDecimal> disPriceMap;
        String feeDiscount;
        String preNotice = "\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u7ed3\u679c\uff1a";
        Long templateId = atomReqBO.getTemplateId();
        ActOrderDiscountAtomRspBO rsp = new ActOrderDiscountAtomRspBO();
        if (null == atomReqBO.getTotalAmount() || atomReqBO.getTotalAmount().compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (SkuDetailActReqAtomBO bo : atomReqBO.getSkuDetailAtomList()) {
                totalAmount = totalAmount.add(bo.getSkuPrice().multiply(bo.getSkuNum()));
            }
            atomReqBO.setTotalAmount(totalAmount);
        }
        if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID.equals(templateId)) {
            feeDiscount = this.qryActiveAttr(atomReqBO.getActiveId(), templateId, "total_fee_discount");
            String accFlag = this.qryActiveAttr(atomReqBO.getActiveId(), templateId, "accumulate_flag");
            disPriceMap = this.calculateCashDiscount(new BigDecimal(feeDiscount), accFlag, atomReqBO);
        } else if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID.equals(templateId)) {
            String discountRate = this.qryActiveAttr(atomReqBO.getActiveId(), templateId, "total_fee_discount_rate");
            disPriceMap = this.calculateDiscount(new BigDecimal(discountRate), atomReqBO);
        } else if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_DCT_TEMP_ID.equals(templateId)) {
            feeDiscount = this.qryActiveAttr(atomReqBO.getActiveId(), templateId, "total_fee_discount");
            disPriceMap = this.calculateFreightDiscount(new BigDecimal(feeDiscount), atomReqBO);
        } else if (ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_FREE_TEMP_ID.equals(templateId)) {
            disPriceMap = this.calculateFreightDiscount(atomReqBO.getFreightAmount(), atomReqBO);
        } else {
            rsp.setRespCode("1008");
            rsp.setRespDesc(preNotice + "\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u7248[" + templateId + "]\uff01");
            return rsp;
        }
        this.buildAftCalculationRspBO(disPriceMap, rsp);
        return rsp;
    }

    private void buildAftCalculationRspBO(Map<String, BigDecimal> disPriceMap, ActOrderDiscountAtomRspBO rspBO) {
        rspBO.setDisTotalAmo(disPriceMap.get("disTotalAmo"));
        rspBO.setDisFreightAmo(disPriceMap.get("disFreightAmo"));
        rspBO.setTotalAmount(disPriceMap.get("totalAmount"));
        rspBO.setFreightAmount(disPriceMap.get("freightAmount"));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
    }

    private String qryActiveAttr(Long activeId, Long tempLateId, String paraCode) {
        ActiveAttrPO activeAttrPO = new ActiveAttrPO();
        activeAttrPO.setActiveId(activeId);
        activeAttrPO.setTemplateId(tempLateId);
        activeAttrPO.setParaCode(paraCode);
        activeAttrPO = this.activeAttrMapper.getModelBy(activeAttrPO);
        if (activeAttrPO == null) {
            throw new BusinessException("1009", "\u672a\u67e5\u8be2\u5230\u6a21\u677fID[" + tempLateId + "]\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)activeAttrPO.getParaValue())) {
            throw new BusinessException("1009", "\u6a21\u677fID[" + tempLateId + "]\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u672a\u8bbe\u7f6e\u6d3b\u52a8\u5177\u4f53\u503c");
        }
        return activeAttrPO.getParaValue();
    }

    private Map<String, BigDecimal> calculateCashDiscount(BigDecimal feeDiscount, String accFlag, ActOrderDiscountAtomReqBO atomReqBO) {
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        BigDecimal newDisTotalAmo = Integer.valueOf(accFlag) == 1 ? feeDiscount.multiply(BigDecimal.valueOf(atomReqBO.getMulCount().intValue())) : feeDiscount;
        BigDecimal newTotalAmount = atomReqBO.getTotalAmount().subtract(newDisTotalAmo);
        if (null != atomReqBO.getDisTotalAmo()) {
            newDisTotalAmo = newDisTotalAmo.add(atomReqBO.getDisTotalAmo());
        }
        calculatePrice.put("totalAmount", newTotalAmount);
        calculatePrice.put("disTotalAmo", newDisTotalAmo);
        calculatePrice.put("disFreightAmo", BigDecimal.ZERO);
        calculatePrice.put("freightAmount", atomReqBO.getFreightAmount());
        return calculatePrice;
    }

    private Map<String, BigDecimal> calculateDiscount(BigDecimal discountRate, ActOrderDiscountAtomReqBO atomReqBO) {
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        BigDecimal totalAmount = atomReqBO.getTotalAmount();
        BigDecimal newDisTotalAmo = totalAmount.subtract(totalAmount.multiply(discountRate));
        calculatePrice.put("totalAmount", totalAmount.subtract(newDisTotalAmo));
        if (null != atomReqBO.getDisTotalAmo()) {
            newDisTotalAmo = newDisTotalAmo.add(atomReqBO.getDisTotalAmo());
        }
        calculatePrice.put("disTotalAmo", newDisTotalAmo);
        calculatePrice.put("disFreightAmo", BigDecimal.ZERO);
        calculatePrice.put("freightAmount", atomReqBO.getFreightAmount());
        return calculatePrice;
    }

    private Map<String, BigDecimal> calculateFreightDiscount(BigDecimal feeDiscount, ActOrderDiscountAtomReqBO atomReqBO) {
        BigDecimal disFreightAmo;
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        BigDecimal freightAmount = atomReqBO.getFreightAmount();
        if (feeDiscount.compareTo(freightAmount) < 0) {
            disFreightAmo = feeDiscount;
            freightAmount = freightAmount.subtract(disFreightAmo);
        } else {
            disFreightAmo = freightAmount;
            freightAmount = BigDecimal.ZERO;
        }
        calculatePrice.put("disFreightAmo", disFreightAmo);
        calculatePrice.put("freightAmount", freightAmount);
        calculatePrice.put("totalAmount", atomReqBO.getTotalAmount());
        calculatePrice.put("disTotalAmo", atomReqBO.getDisTotalAmo() != null ? atomReqBO.getDisTotalAmo() : BigDecimal.ZERO);
        return calculatePrice;
    }
}

