/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActSkuDiscountAtomService;
import com.tydic.newretail.atom.bo.ActSkuDiscountReqBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountRspBO;
import com.tydic.newretail.atom.bo.SkuDetailActRspAtomBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSkuDiscountAtomService")
public class ActSkuDiscountAtomServiceImpl
implements ActSkuDiscountAtomService {
    private static final Logger logger = LoggerFactory.getLogger(ActSkuDiscountAtomServiceImpl.class);
    private ActiveAttrMapper activeAttrMapper;

    @Autowired
    public ActSkuDiscountAtomServiceImpl(ActiveAttrMapper activeAttrMapper) {
        this.activeAttrMapper = activeAttrMapper;
    }

    @Override
    public ActSkuDiscountRspBO skuDiscount(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        Map<String, BigDecimal> disPriceMap;
        Long templateId = actSkuDiscountReqBO.getTemplateId();
        BigDecimal skuPrice = actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuPrice();
        BigDecimal disCountAmount = actSkuDiscountReqBO.getDisCountAmont();
        ActSkuDiscountRspBO rspBO = new ActSkuDiscountRspBO();
        if (ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID.equals(templateId)) {
            String priceDiscount = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount");
            disPriceMap = this.calculateCashDiscount(priceDiscount, disCountAmount, skuPrice);
        } else if (ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID.equals(templateId)) {
            String discountRate = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount_rate");
            disPriceMap = this.calculateDiscount(discountRate, disCountAmount, skuPrice);
        } else if (ActCommConstant.DifActivityTempIds.SGL_PRD_AFT_DCT_TEMP_ID.equals(templateId)) {
            String priceDiscount = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount");
            String discountRate = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount_rate");
            disPriceMap = this.calculateDiscountRate(discountRate, priceDiscount, disCountAmount, skuPrice);
        } else if (ActCommConstant.DifActivityTempIds.SGL_PRD_DEFINE_PRICE_TEMP_ID.equals(templateId)) {
            String priceRedefine = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_redefine");
            disPriceMap = this.calculateRedefine(priceRedefine, disCountAmount, skuPrice);
        } else {
            rspBO.setRespCode("1002");
            rspBO.setRespDesc("\u4f20\u5165\u6a21\u677fID\u4e0d\u652f\u6301\u5355\u54c1\u4f18\u60e0\u8ba1\u7b97");
            return rspBO;
        }
        this.buildRspBO(actSkuDiscountReqBO, disPriceMap, rspBO);
        return rspBO;
    }

    private String queryActiveAttr(ActSkuDiscountReqBO actSkuDiscountReqBO, String activityParamName) {
        ActiveAttrPO activeAttrModel = new ActiveAttrPO();
        activeAttrModel.setActiveId(actSkuDiscountReqBO.getActId());
        activeAttrModel.setTemplateId(actSkuDiscountReqBO.getTemplateId());
        activeAttrModel.setParaCode(activityParamName);
        ActiveAttrPO activeAttrPO = this.activeAttrMapper.getModelBy(activeAttrModel);
        if (activeAttrPO == null) {
            throw new BusinessException("1002", "\u672a\u67e5\u8be2\u5230\u6a21\u677fID[" + actSkuDiscountReqBO.getTemplateId() + "]\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)activeAttrPO.getParaValue())) {
            throw new BusinessException("1002", "\u6a21\u677fID[" + actSkuDiscountReqBO.getTemplateId() + "]\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u672a\u8bbe\u7f6e\u6d3b\u52a8\u5177\u4f53\u503c");
        }
        return activeAttrPO.getParaValue();
    }

    private void buildRspBO(ActSkuDiscountReqBO actSkuDiscountReqBO, Map<String, BigDecimal> disPriceMap, ActSkuDiscountRspBO rspBO) {
        BigDecimal skuDisPrice = disPriceMap.get("skuDisPrice");
        BigDecimal skuDisAmount = disPriceMap.get("skuDisAmount");
        SkuDetailActRspAtomBO skuDetailActRspAtomBO = new SkuDetailActRspAtomBO();
        skuDetailActRspAtomBO.setSkuId(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuId());
        skuDetailActRspAtomBO.setSkuNum(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuNum());
        skuDetailActRspAtomBO.setShopId(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getShopId());
        skuDetailActRspAtomBO.setSkuPrice(actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuPrice());
        skuDetailActRspAtomBO.setSkuDisPrice(skuDisPrice);
        skuDetailActRspAtomBO.setSkuDisAmount(skuDisAmount);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u4e2a\u5546\u54c1[" + actSkuDiscountReqBO.getSkuDetailActReqAtomBO().getSkuId() + "]\u91d1\u989d\u4f18\u60e0\u6210\u529f");
        rspBO.setSkuDetailActRspAtomBO(skuDetailActRspAtomBO);
    }

    private Map<String, BigDecimal> calculateCashDiscount(String activityParaValue, BigDecimal disCountAmount, BigDecimal skuPrice) {
        BigDecimal skuDisAmount = new BigDecimal(activityParaValue);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateDiscount(String activityParaValue, BigDecimal disCountAmount, BigDecimal skuPrice) {
        BigDecimal discountNum = new BigDecimal(activityParaValue);
        BigDecimal skuDisAmount = skuPrice.multiply(BigDecimal.ONE.subtract(discountNum));
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateDiscountRate(String rateAttr, String discountAttr, BigDecimal disCountAmount, BigDecimal skuPrice) {
        BigDecimal discountRate = new BigDecimal(rateAttr);
        BigDecimal skuDisAmount = skuPrice.multiply(BigDecimal.ONE.subtract(discountRate));
        BigDecimal discount = new BigDecimal(discountAttr);
        skuDisAmount = skuDisAmount.add(discount);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateRedefine(String redefineAttr, BigDecimal disCountAmount, BigDecimal skuPrice) {
        BigDecimal priceRedefine = new BigDecimal(redefineAttr);
        BigDecimal skuDisAmount = skuPrice.subtract(priceRedefine);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }
}

