/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActDeleteBusiService;
import com.tydic.newretail.busi.bo.ActActDeleteBusiReqBO;
import com.tydic.newretail.busi.bo.ActActDeleteBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActDeleteBusiService")
public class ActActDeleteBusiServiceImpl
implements ActActDeleteBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActDeleteBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;

    public ActActDeleteBusiRspBO deleteActivity(ActActDeleteBusiReqBO reqBO) {
        ActActDeleteBusiRspBO rspBO = new ActActDeleteBusiRspBO();
        ActivityPO actPO = new ActivityPO();
        actPO.setActiveId(reqBO.getActiveId());
        actPO.setActiveCode(reqBO.getActiveCode());
        actPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        ActivityPO activityPO = this.activityMapper.getModelBy(actPO);
        if (null == activityPO) {
            rspBO.setRespCode("2031");
            rspBO.setRespDesc("\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return rspBO;
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getSkuId()) && null != reqBO.getShopId()) {
            this.deleteSkuAct(reqBO, activityPO.getActiveId());
        } else if (StringUtils.isBlank((CharSequence)reqBO.getSkuId()) && null != reqBO.getShopId()) {
            this.deleteShopAct(reqBO, activityPO.getActiveId());
        } else if (StringUtils.isBlank((CharSequence)reqBO.getSkuId()) && null == reqBO.getShopId()) {
            this.deleteAllAct(activityPO.getActiveId());
        } else {
            rspBO.setRespCode("2033");
            rspBO.setRespDesc("\u65e0\u6cd5\u5339\u914d\u5230\u9700\u8981\u5220\u9664\u7684\u6d3b\u52a8");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u5220\u9664\u6210\u529f");
        return rspBO;
    }

    private void deleteSkuAct(ActActDeleteBusiReqBO reqBO, Long activeId) {
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        skuActivePO.setSkuId(reqBO.getSkuId());
        skuActivePO.setShopId(reqBO.getShopId());
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (updateSkuActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5355\u54c1\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteShopAct(ActActDeleteBusiReqBO reqBO, Long activeId) {
        ShopActivePO shopActivePO = new ShopActivePO();
        shopActivePO.setActiveId(activeId);
        shopActivePO.setShopId(reqBO.getShopId());
        shopActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateShopActResult = this.shopActiveMapper.updateByCondition(shopActivePO);
        if (updateShopActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5e97\u94fa\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteAllAct(Long activeId) {
        ActivityPO activePO = new ActivityPO();
        activePO.setActiveId(activeId);
        activePO.setActiveStatus(ActCommConstant.ActivityState.DISABLED);
        activePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateActResult = this.activityMapper.updateById(activePO);
        if (updateActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        ShopActivePO shopActivePO = new ShopActivePO();
        shopActivePO.setActiveId(activeId);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int checkShop = this.shopActiveMapper.getCheckBy(shopActivePO);
        shopActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateShopActResult = this.shopActiveMapper.updateByCondition(shopActivePO);
        if (checkShop > 0 && updateShopActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5e97\u94fa\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int checkSku = this.skuActiveMapper.getCheckBy(skuActivePO);
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (checkSku > 0 && updateSkuActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5355\u54c1\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6021", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }
}

