/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.commodity.busi.sku.QuerySkuDetailBusiService;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPictureBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.tydic.newretail.busi.ActQrySkuDetailByActivityBusiService;
import com.tydic.newretail.busi.bo.ActQrySkuDetailByActivityBusiReqBO;
import com.tydic.newretail.busi.bo.ActQrySkuDetailByActivityBusiRspBO;
import com.tydic.newretail.common.bo.SkuDetailInfoBO;
import com.tydic.newretail.common.bo.SkuPriceBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQrySkuDetailByActivityBusiService")
public class ActQrySkuDetailByActivityBusiServiceImpl
implements ActQrySkuDetailByActivityBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActQrySkuDetailByActivityBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private ActivityMapper activityMapper;
    private SkuActiveMapper skuActiveMapper;
    private ShopActiveMapper shopActiveMapper;
    private QuerySkuDetailBusiService qrySkuDetailService;

    @Autowired
    public ActQrySkuDetailByActivityBusiServiceImpl(ActivityMapper activityMapper, SkuActiveMapper skuActiveMapper, ShopActiveMapper shopActiveMapper, QuerySkuDetailBusiService qrySkuDetailService) {
        this.activityMapper = activityMapper;
        this.skuActiveMapper = skuActiveMapper;
        this.shopActiveMapper = shopActiveMapper;
        this.qrySkuDetailService = qrySkuDetailService;
    }

    public ActQrySkuDetailByActivityBusiRspBO qrySkuDetailByAct(ActQrySkuDetailByActivityBusiReqBO reqBO) {
        ActivityPO activityPO;
        ActQrySkuDetailByActivityBusiRspBO rspBO = new ActQrySkuDetailByActivityBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u6210\u529f");
        rspBO.setSkuDetailInfoList(new ArrayList());
        ActivityPO activePO = new ActivityPO();
        activePO.setActiveId(reqBO.getActiveId());
        activePO.setActiveCode(reqBO.getActiveCode());
        if (!StringUtils.isBlank((CharSequence)activePO.getActiveCode())) {
            activePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        }
        if (null == (activityPO = this.activityMapper.getModelBy(activePO))) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6d3b\u52a8\u4fe1\u606f");
            return rspBO;
        }
        this.qryShopActAndSkuDetail(activityPO.getActiveId(), rspBO);
        this.qrySkuActAndSkuDetail(activityPO.getActiveId(), rspBO);
        return rspBO;
    }

    private void qryShopActAndSkuDetail(Long activeId, ActQrySkuDetailByActivityBusiRspBO rspBO) {
        ShopActivePO shopActivePO = new ShopActivePO();
        shopActivePO.setActiveId(activeId);
        List<ShopActivePO> shopActiveList = this.shopActiveMapper.getList(shopActivePO);
        if (!CollectionUtils.isEmpty(shopActiveList)) {
            for (ShopActivePO shopActPO : shopActiveList) {
                QuerySkuDetailReqBO qrySkuDetailReqBO = new QuerySkuDetailReqBO();
                qrySkuDetailReqBO.setSupplierId(shopActPO.getShopId());
                QuerySkuDetailRspBO qrySkuDetailRspBO = this.qrySkuDetailService.querySkuDetail(qrySkuDetailReqBO);
                if (!"0000".equals(qrySkuDetailRspBO.getRespCode())) {
                    if (IS_DEBUGABLE) {
                        LOG.debug("\u5e97\u94faID[" + shopActPO.getShopId() + "]\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                    }
                    rspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u90e8\u5206\u5931\u8d25\uff0c\u53ef\u80fd\u51fa\u73b0\u90e8\u5206\u5546\u54c1\u4fe1\u606f\u7f3a\u5931");
                    continue;
                }
                SkuDetailInfoBO skuDetailInfoBO = new SkuDetailInfoBO();
                BeanUtils.copyProperties((Object)qrySkuDetailRspBO, (Object)skuDetailInfoBO);
                SkuPriceBO skuPriceBO = new SkuPriceBO();
                BeanUtils.copyProperties((Object)qrySkuDetailRspBO.getPrice(), (Object)skuPriceBO);
                skuDetailInfoBO.setPrice(skuPriceBO);
                ArrayList<com.tydic.newretail.common.bo.SkuSpecBO> skuSpecBOList = new ArrayList<com.tydic.newretail.common.bo.SkuSpecBO>();
                if (!CollectionUtils.isEmpty((Collection)qrySkuDetailRspBO.getSpecs())) {
                    for (SkuSpecBO skuSpecRspBO : qrySkuDetailRspBO.getSpecs()) {
                        com.tydic.newretail.common.bo.SkuSpecBO skuSpecBO = new com.tydic.newretail.common.bo.SkuSpecBO();
                        BeanUtils.copyProperties((Object)skuSpecRspBO, (Object)skuSpecBO);
                        skuSpecBOList.add(skuSpecBO);
                    }
                }
                skuDetailInfoBO.setSpecs(skuSpecBOList);
                ArrayList<com.tydic.newretail.common.bo.SkuPictureBO> skuPictureBOList = new ArrayList<com.tydic.newretail.common.bo.SkuPictureBO>();
                if (!CollectionUtils.isEmpty((Collection)qrySkuDetailRspBO.getPictures())) {
                    for (SkuPictureBO skuPictureRspBO : qrySkuDetailRspBO.getPictures()) {
                        com.tydic.newretail.common.bo.SkuPictureBO skuPictureBO = new com.tydic.newretail.common.bo.SkuPictureBO();
                        BeanUtils.copyProperties((Object)skuPictureRspBO, (Object)skuPictureBO);
                        skuPictureBOList.add(skuPictureBO);
                    }
                }
                skuDetailInfoBO.setPictures(skuPictureBOList);
                rspBO.getSkuDetailInfoList().add(skuDetailInfoBO);
            }
        }
    }

    private void qrySkuActAndSkuDetail(Long activeId, ActQrySkuDetailByActivityBusiRspBO rspBO) {
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        List<SkuActivePO> skuActivePOList = this.skuActiveMapper.getList(skuActivePO);
        if (!CollectionUtils.isEmpty(skuActivePOList)) {
            for (SkuActivePO skuActPO : skuActivePOList) {
                boolean existFlag = false;
                for (SkuDetailInfoBO skuDetailInfo : rspBO.getSkuDetailInfoList()) {
                    if (!skuActPO.getShopId().equals(skuDetailInfo.getSupplierId()) || !skuActPO.getSkuId().equals(skuDetailInfo.getSkuId() + "")) continue;
                    existFlag = true;
                    break;
                }
                if (existFlag) continue;
                QuerySkuDetailReqBO qrySkuDetailReqBO = new QuerySkuDetailReqBO();
                qrySkuDetailReqBO.setSupplierId(skuActPO.getShopId());
                qrySkuDetailReqBO.setSkuId(Long.valueOf(skuActPO.getSkuId()));
                QuerySkuDetailRspBO qrySkuDetailRspBO = this.qrySkuDetailService.querySkuDetail(qrySkuDetailReqBO);
                if (!"0000".equals(qrySkuDetailRspBO.getRespCode())) {
                    if (IS_DEBUGABLE) {
                        LOG.debug("\u5e97\u94faID[" + skuActPO.getShopId() + "],\u5355\u54c1ID[" + skuActPO.getSkuId() + "]\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                    }
                    rspBO.setRespDesc("\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u90e8\u5206\u5931\u8d25\uff0c\u53ef\u80fd\u7f3a\u5931\u90e8\u5206\u5546\u54c1\u4fe1\u606f");
                    continue;
                }
                SkuDetailInfoBO skuDetailInfoBO = new SkuDetailInfoBO();
                BeanUtils.copyProperties((Object)qrySkuDetailRspBO, (Object)skuDetailInfoBO);
                SkuPriceBO skuPriceBO = new SkuPriceBO();
                BeanUtils.copyProperties((Object)qrySkuDetailRspBO.getPrice(), (Object)skuPriceBO);
                skuDetailInfoBO.setPrice(skuPriceBO);
                ArrayList<com.tydic.newretail.common.bo.SkuSpecBO> skuSpecBOList = new ArrayList<com.tydic.newretail.common.bo.SkuSpecBO>();
                if (!CollectionUtils.isEmpty((Collection)qrySkuDetailRspBO.getSpecs())) {
                    for (SkuSpecBO skuSpecRspBO : qrySkuDetailRspBO.getSpecs()) {
                        com.tydic.newretail.common.bo.SkuSpecBO skuSpecBO = new com.tydic.newretail.common.bo.SkuSpecBO();
                        BeanUtils.copyProperties((Object)skuSpecRspBO, (Object)skuSpecBO);
                        skuSpecBOList.add(skuSpecBO);
                    }
                }
                skuDetailInfoBO.setSpecs(skuSpecBOList);
                ArrayList<com.tydic.newretail.common.bo.SkuPictureBO> skuPictureBOList = new ArrayList<com.tydic.newretail.common.bo.SkuPictureBO>();
                if (!CollectionUtils.isEmpty((Collection)qrySkuDetailRspBO.getPictures())) {
                    for (SkuPictureBO skuPictureRspBO : qrySkuDetailRspBO.getPictures()) {
                        com.tydic.newretail.common.bo.SkuPictureBO skuPictureBO = new com.tydic.newretail.common.bo.SkuPictureBO();
                        BeanUtils.copyProperties((Object)skuPictureRspBO, (Object)skuPictureBO);
                        skuPictureBOList.add(skuPictureBO);
                    }
                }
                skuDetailInfoBO.setPictures(skuPictureBOList);
                rspBO.getSkuDetailInfoList().add(skuDetailInfoBO);
            }
        }
    }
}

