/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.comb.ActCreateCouponCombService;
import com.tydic.newretail.comb.bo.ActCreateCouponCombReqBO;
import com.tydic.newretail.comb.bo.ActCreateCouponCombRspBO;
import com.tydic.newretail.common.bo.CouponBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponInstMapper;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponCombService")
public class ActCreateCouponCombServiceImpl
implements ActCreateCouponCombService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateCouponCombServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private CouponInstMapper couponInstMapper;
    private ActCreateCouponBusiService actCreateCouponBusiService;

    @Autowired
    private ActCreateCouponCombServiceImpl(CouponInstMapper couponInstMapper, ActCreateCouponBusiService actCreateCouponBusiService) {
        this.couponInstMapper = couponInstMapper;
        this.actCreateCouponBusiService = actCreateCouponBusiService;
    }

    public ActCreateCouponCombRspBO createCoupon(ActCreateCouponCombReqBO reqBO) {
        ActCreateCouponCombRspBO rspBO = new ActCreateCouponCombRspBO();
        int failedCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u4f18\u60e0\u5238\u7f16\u7801");
        for (CouponBO couponBO : reqBO.getCouponList()) {
            int check = this.couponInstMapper.getCheckById(couponBO.getCouponNo());
            if (check > 0) {
                if (IS_DEBUGABLE) {
                    LOG.debug("[" + couponBO.getCouponNo() + "]\u8be5\u4f18\u60e0\u5238\u5b9e\u4f8b\u5df2\u5b58\u5728");
                }
                ++failedCount;
                stringBuffer.append("[" + couponBO.getCouponNo() + "]\u5df2\u5b58\u5728\uff0c");
                continue;
            }
            if (StringUtils.isBlank((CharSequence)couponBO.getCreateTime())) {
                couponBO.setCreateTime(DateUtils.dateToStrLong((Date)new Date()));
            }
            if (null == couponBO.getState()) {
                Date eff;
                if (!StringUtils.isBlank((CharSequence)couponBO.getUsedSn())) {
                    couponBO.setState(ActCommConstant.CouponState.USED);
                } else if (StringUtils.isBlank((CharSequence)couponBO.getEffTime()) && StringUtils.isBlank((CharSequence)couponBO.getExpTime())) {
                    couponBO.setState(ActCommConstant.CouponState.EXPIRED);
                } else if (!StringUtils.isBlank((CharSequence)couponBO.getEffTime()) && !StringUtils.isBlank((CharSequence)couponBO.getExpTime())) {
                    eff = DateUtils.strToDateLong((String)couponBO.getEffTime());
                    Date exp = DateUtils.strToDateLong((String)couponBO.getExpTime());
                    Date now = new Date();
                    if (now.after(eff) && now.before(exp)) {
                        if (null != couponBO.getMemId()) {
                            couponBO.setState(ActCommConstant.CouponState.TO_BE_USED);
                        } else {
                            couponBO.setState(ActCommConstant.CouponState.TO_BE_RECEIVED);
                        }
                    }
                } else if (!StringUtils.isBlank((CharSequence)couponBO.getExpTime())) {
                    Date exp = DateUtils.strToDateLong((String)couponBO.getExpTime());
                    if (exp.before(new Date())) {
                        couponBO.setState(ActCommConstant.CouponState.EXPIRED);
                    }
                } else if (!StringUtils.isBlank((CharSequence)couponBO.getEffTime()) && (eff = DateUtils.strToDateLong((String)couponBO.getEffTime())).after(new Date())) {
                    couponBO.setState(ActCommConstant.CouponState.CREATED);
                }
            }
            ActCreateCouponBusiReqBO busiReqBO = new ActCreateCouponBusiReqBO();
            busiReqBO.setCouponInfo(couponBO);
            ActCreateCouponBusiRspBO busiRspBO = this.actCreateCouponBusiService.createCoupon(busiReqBO);
            if ("0000".equals(busiRspBO.getRespCode())) continue;
            if (IS_DEBUGABLE) {
                LOG.debug("\u4f18\u60e0\u5238\u521b\u5efa\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0\uff1a" + busiRspBO.getRespDesc());
            }
            ++failedCount;
            stringBuffer.append("[" + couponBO.getCouponNo() + "]\u521b\u5efa\u5931\u8d25\uff0c");
        }
        rspBO.setRespCode("0000");
        String desc = "\u4f18\u60e0\u5238\u521b\u5efa\u5b8c\u6210\uff0c\u5171" + reqBO.getCouponList().size() + "\u6761";
        if (failedCount > 0) {
            desc = desc + "\uff0c\u5176\u4e2d\u5931\u8d25" + failedCount + "\u6761\uff0c\u5305\u62ec\uff1a" + stringBuffer.substring(0, stringBuffer.length() - 1);
        }
        rspBO.setRespDesc(desc);
        return rspBO;
    }
}

