/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCreateCouponAbillityService;
import com.tydic.newretail.ability.bo.ActCreateCouponAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCreateCouponAbilityRspBO;
import com.tydic.newretail.comb.ActCreateCouponCombService;
import com.tydic.newretail.comb.bo.ActCreateCouponCombReqBO;
import com.tydic.newretail.comb.bo.ActCreateCouponCombRspBO;
import com.tydic.newretail.common.bo.CouponBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponAbillityService")
public class ActCreateCouponAbillityServiceImpl
implements ActCreateCouponAbillityService {
    private static final String PARAM_MSG = "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    private ActCreateCouponCombService actCreateCouponCombService;

    @Autowired
    private ActCreateCouponAbillityServiceImpl(ActCreateCouponCombService actCreateCouponCombService) {
        this.actCreateCouponCombService = actCreateCouponCombService;
    }

    public ActCreateCouponAbilityRspBO createCoupon(ActCreateCouponAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActCreateCouponAbilityRspBO rspBO = new ActCreateCouponAbilityRspBO();
        ActCreateCouponCombReqBO busiReqBO = new ActCreateCouponCombReqBO();
        busiReqBO.setCouponList(reqBO.getCouponList());
        ActCreateCouponCombRspBO busiRspBO = this.actCreateCouponCombService.createCoupon(busiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private void validateArg(ActCreateCouponAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCouponList())) {
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5217\u8868[couponList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CouponBO couponBO : reqBO.getCouponList()) {
            if (null == couponBO.getCouponType()) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5217\u8868[couponList]\u4e2d\u7684\u4f18\u60e0\u5238\u7c7b\u578b[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)couponBO.getCouponNo())) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5217\u8868[couponList]\u4e2d\u7684\u4f18\u60e0\u5238\u7f16\u7801[couponNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != couponBO.getFmId()) continue;
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5217\u8868[couponList]\u4e2d\u7684\u89c4\u683cID[fmId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

