/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.tydic.newretail.atom.ActActivityValidCheckAtomService;
import com.tydic.newretail.atom.ActGiftQueryAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuDiscountAtomService;
import com.tydic.newretail.atom.ActSkuJudgeAtomService;
import com.tydic.newretail.atom.ActSkuSeckPriceQueryAtomService;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomRspBO;
import com.tydic.newretail.atom.bo.ActCalcPriceAtomBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActGiftQueryAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountReqBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountRspBO;
import com.tydic.newretail.atom.bo.ActSkuJudgeAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuJudgeAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomRspBO;
import com.tydic.newretail.atom.bo.ActivityChoiceAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailRspAtomBO;
import com.tydic.newretail.common.bo.ActiveGiftBO;
import com.tydic.newretail.common.bo.ActiveGiftPkgBO;
import com.tydic.newretail.dao.ActiveTemplateMapper;
import com.tydic.newretail.dao.po.ActiveTemplatePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSkuActivityCountAtomService")
public class ActSkuActivityCountAtomServiceImpl
implements ActSkuActivityCountAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSkuActivityCountAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String SECK_KILL_SKU_YES = "1";
    private static final String SECK_KILL_SKU_NO = "0";
    private ActActivityValidCheckAtomService actActivityValidCheckAtomService;
    private ActSkuJudgeAtomService actSkuJudgeAtomService;
    private ActSkuDiscountAtomService actSkuDiscountAtomService;
    private ActGiftQueryAtomService actGiftQueryAtomService;
    private ActiveTemplateMapper activeTemplateMapper;
    private ActSkuSeckPriceQueryAtomService actSkuSeckPriceQueryAtomService;

    @Autowired
    public ActSkuActivityCountAtomServiceImpl(ActActivityValidCheckAtomService actActivityValidCheckAtomService, ActSkuJudgeAtomService actSkuJudgeAtomService, ActSkuDiscountAtomService actSkuDiscountAtomService, ActGiftQueryAtomService actGiftQueryAtomService, ActiveTemplateMapper activeTemplateMapper, ActSkuSeckPriceQueryAtomService actSkuSeckPriceQueryAtomService) {
        this.actActivityValidCheckAtomService = actActivityValidCheckAtomService;
        this.actSkuJudgeAtomService = actSkuJudgeAtomService;
        this.actSkuDiscountAtomService = actSkuDiscountAtomService;
        this.actGiftQueryAtomService = actGiftQueryAtomService;
        this.activeTemplateMapper = activeTemplateMapper;
        this.actSkuSeckPriceQueryAtomService = actSkuSeckPriceQueryAtomService;
    }

    @Override
    public ActSkuActivityCountRspBO skuActivityCount(ActSkuActivityCountReqBO actSkuActivityCountReqBO) {
        SkuDetailReqAtomBO skuDetailReqAtomBO = actSkuActivityCountReqBO.getActSkuActivityDetailReqBO();
        List<ActivityChoiceAtomBO> activityChoiceAtomBOS = skuDetailReqAtomBO.getActivityChoiceAtomBOS();
        ActSkuActivityCountRspBO originalRspBO = this.returnOriginalInfo(activityChoiceAtomBOS, skuDetailReqAtomBO);
        if (originalRspBO != null) {
            return originalRspBO;
        }
        if (SECK_KILL_SKU_YES.equals(skuDetailReqAtomBO.getSeckillFlag())) {
            originalRspBO = this.judgeSeckillActive(skuDetailReqAtomBO);
            return originalRspBO;
        }
        Collections.sort(activityChoiceAtomBOS);
        ActSkuActivityCountRspBO rspBO = new ActSkuActivityCountRspBO();
        ActCalcPriceAtomBO actCalcPriceAtomBO = this.obtainDisPriceAndGifts(activityChoiceAtomBOS, skuDetailReqAtomBO);
        if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
            rspBO.setRespCode(actCalcPriceAtomBO.getRespCode());
            rspBO.setRespDesc(actCalcPriceAtomBO.getRespDesc());
            rspBO.setSkuDetailRspAtomBO(null);
            return rspBO;
        }
        BigDecimal disCountAmont = actCalcPriceAtomBO.getDisCountAmont();
        BigDecimal disPrice = actCalcPriceAtomBO.getDisSkuPrice();
        SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
        skuDetailRspAtomBO.setSeckillFlag(SECK_KILL_SKU_NO);
        skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailRspAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        skuDetailRspAtomBO.setSkuDisAmount(disCountAmont);
        if (disPrice.compareTo(BigDecimal.ZERO) < 0) {
            skuDetailRspAtomBO.setSkuDisPrice(BigDecimal.ZERO);
        } else {
            skuDetailRspAtomBO.setSkuDisPrice(disPrice);
        }
        skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailRspAtomBO.setGiftList(actCalcPriceAtomBO.getGiftList());
        skuDetailRspAtomBO.setGiftPkgList(actCalcPriceAtomBO.getGiftPkgList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u54c1\u4ef7\u683c\u8ba1\u7b97\u6210\u529f");
        rspBO.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
        return rspBO;
    }

    private ActSkuActivityCountRspBO returnOriginalInfo(List<ActivityChoiceAtomBO> activityChoiceAtomBOS, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        if ((activityChoiceAtomBOS == null || activityChoiceAtomBOS.isEmpty()) && SECK_KILL_SKU_NO.equals(skuDetailReqAtomBO.getSeckillFlag())) {
            ActSkuActivityCountRspBO rspBO = new ActSkuActivityCountRspBO();
            SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
            skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
            skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
            skuDetailRspAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
            skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
            skuDetailRspAtomBO.setSkuDisAmount(BigDecimal.ZERO);
            skuDetailRspAtomBO.setSkuDisPrice(skuDetailReqAtomBO.getSkuPrice());
            skuDetailRspAtomBO.setSeckillFlag(SECK_KILL_SKU_NO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5b8c\u6210");
            rspBO.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
            return rspBO;
        }
        return null;
    }

    private ActSkuActivityCountRspBO judgeSeckillActive(SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActSkuActivityCountRspBO seckillSkuRspBO = null;
        ActSkuSeckPriceQueryAtomRspBO actSkuSeckPriceQueryAtomRspBO = this.qrySkuSeckPrice(skuDetailReqAtomBO.getSkuId(), skuDetailReqAtomBO.getShopId());
        if ("0000".equals(actSkuSeckPriceQueryAtomRspBO.getRespCode()) && SECK_KILL_SKU_NO.equals(actSkuSeckPriceQueryAtomRspBO.getSeckillFlag())) {
            seckillSkuRspBO = new ActSkuActivityCountRspBO();
            seckillSkuRspBO.setRespCode("1007");
            seckillSkuRspBO.setRespDesc(actSkuSeckPriceQueryAtomRspBO.getRespDesc());
            return seckillSkuRspBO;
        }
        if (skuDetailReqAtomBO.getSkuPrice().compareTo(BigDecimal.valueOf(actSkuSeckPriceQueryAtomRspBO.getKillPrice())) != 0) {
            seckillSkuRspBO = new ActSkuActivityCountRspBO();
            seckillSkuRspBO.setRespCode("1007");
            seckillSkuRspBO.setRespDesc("\u5f53\u524d\u4f20\u9012\u5355\u54c1\u79d2\u6740\u4ef7\u683c\u6821\u9a8c\u4e0d\u901a\u8fc7!");
            return seckillSkuRspBO;
        }
        if (SECK_KILL_SKU_YES.equals(actSkuSeckPriceQueryAtomRspBO.getSeckillFlag()) && "0000".equals(actSkuSeckPriceQueryAtomRspBO.getRespCode())) {
            seckillSkuRspBO = this.returnSeckillSkuInfo(skuDetailReqAtomBO, SECK_KILL_SKU_YES, skuDetailReqAtomBO.getSkuPrice(), BigDecimal.valueOf(actSkuSeckPriceQueryAtomRspBO.getKillPrice()));
        }
        if (SECK_KILL_SKU_NO.equals(actSkuSeckPriceQueryAtomRspBO.getSeckillFlag()) && "1006".equals(actSkuSeckPriceQueryAtomRspBO.getRespCode())) {
            seckillSkuRspBO = this.returnSeckillSkuInfo(skuDetailReqAtomBO, SECK_KILL_SKU_NO, BigDecimal.valueOf(actSkuSeckPriceQueryAtomRspBO.getSkuPrice()), BigDecimal.valueOf(actSkuSeckPriceQueryAtomRspBO.getSkuPrice()));
        }
        return seckillSkuRspBO;
    }

    private ActSkuSeckPriceQueryAtomRspBO qrySkuSeckPrice(String skuId, Long shopId) {
        ActSkuSeckPriceQueryAtomReqBO reqBO = new ActSkuSeckPriceQueryAtomReqBO();
        reqBO.setSkuId(skuId);
        reqBO.setShopId(shopId);
        return this.actSkuSeckPriceQueryAtomService.querySkuSeckPrice(reqBO);
    }

    private ActSkuActivityCountRspBO returnSeckillSkuInfo(SkuDetailReqAtomBO skuDetailReqAtomBO, String seckillFlag, BigDecimal skuPrice, BigDecimal killPrice) {
        ActSkuActivityCountRspBO seckillSku = new ActSkuActivityCountRspBO();
        SkuDetailRspAtomBO skuDetailRspAtomBO = new SkuDetailRspAtomBO();
        skuDetailRspAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailRspAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailRspAtomBO.setSkuPrice(skuPrice);
        skuDetailRspAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailRspAtomBO.setSkuDisAmount(BigDecimal.ZERO);
        skuDetailRspAtomBO.setSkuDisPrice(killPrice);
        skuDetailRspAtomBO.setSeckillFlag(seckillFlag);
        seckillSku.setSkuDetailRspAtomBO(skuDetailRspAtomBO);
        seckillSku.setRespCode("0000");
        seckillSku.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u4ef7\u683c\u8ba1\u7b97\u5b8c\u6210");
        return seckillSku;
    }

    private ActCalcPriceAtomBO obtainDisPriceAndGifts(List<ActivityChoiceAtomBO> activityChoiceAtomBOS, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        BigDecimal disCountAmont = BigDecimal.ZERO;
        BigDecimal disSkuPrice = skuDetailReqAtomBO.getSkuPrice();
        ArrayList<ActiveGiftBO> giftList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> giftPkgList = new ArrayList<ActiveGiftPkgBO>();
        for (ActivityChoiceAtomBO activityChoiceAtomBO : activityChoiceAtomBOS) {
            boolean isCheckSuccess = this.checkActivityValid(activityChoiceAtomBO, skuDetailReqAtomBO);
            if (!isCheckSuccess) {
                actCalcPriceAtomBO.setRespCode("1003");
                actCalcPriceAtomBO.setRespDesc("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u65e0\u6548\u6216\u672a\u914d\u7f6e");
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u4e2d\u6240\u5305\u542b\u7684\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u65e0\u6548\u6216\u672a\u914d\u7f6e");
                }
                return actCalcPriceAtomBO;
            }
            List<ActiveTemplatePO> activeTemplatePOS = this.checkTempateValid(activityChoiceAtomBO);
            if (activeTemplatePOS == null) {
                actCalcPriceAtomBO.setRespCode("1004");
                actCalcPriceAtomBO.setRespDesc("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5546\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u672a\u6210\u529f\u914d\u7f6e\u6d3b\u52a8\u6a21\u677f\u4fe1\u606f");
                }
                return actCalcPriceAtomBO;
            }
            actCalcPriceAtomBO = this.calculatePriceByTemp(activeTemplatePOS, activityChoiceAtomBO, skuDetailReqAtomBO, disCountAmont, disSkuPrice);
            if (!"0000".equals(actCalcPriceAtomBO.getRespCode())) {
                return actCalcPriceAtomBO;
            }
            disCountAmont = actCalcPriceAtomBO.getDisCountAmont();
            disSkuPrice = actCalcPriceAtomBO.getDisSkuPrice();
            giftList.addAll(actCalcPriceAtomBO.getGiftList());
            giftPkgList.addAll(actCalcPriceAtomBO.getGiftPkgList());
        }
        actCalcPriceAtomBO.setDisCountAmont(disCountAmont);
        actCalcPriceAtomBO.setDisSkuPrice(disSkuPrice);
        actCalcPriceAtomBO.setGiftList(giftList);
        actCalcPriceAtomBO.setGiftPkgList(giftPkgList);
        actCalcPriceAtomBO.setRespCode("0000");
        actCalcPriceAtomBO.setRespDesc("\u5355\u54c1\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return actCalcPriceAtomBO;
    }

    private boolean checkActivityValid(ActivityChoiceAtomBO activityChoiceAtomBO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        boolean isCheckSuccess = true;
        ActActivityValidCheckAtomReqBO actActivityValidCheckAtomReqBO = new ActActivityValidCheckAtomReqBO();
        actActivityValidCheckAtomReqBO.setActiveId(activityChoiceAtomBO.getActiveId());
        actActivityValidCheckAtomReqBO.setShopId(skuDetailReqAtomBO.getShopId());
        actActivityValidCheckAtomReqBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        ActActivityValidCheckAtomRspBO actActivityValidCheckAtomRspBO = this.actActivityValidCheckAtomService.checkActivityValid(actActivityValidCheckAtomReqBO);
        if (!"0000".equals(actActivityValidCheckAtomRspBO.getRespCode())) {
            isCheckSuccess = false;
        }
        return isCheckSuccess;
    }

    private List<ActiveTemplatePO> checkTempateValid(ActivityChoiceAtomBO activityChoiceAtomBO) {
        int templateNum = 2;
        ActiveTemplatePO activeTemplateModel = new ActiveTemplatePO();
        activeTemplateModel.setActiveId(activityChoiceAtomBO.getActiveId());
        List<ActiveTemplatePO> activeTemplatePOS = this.activeTemplateMapper.getList(activeTemplateModel);
        if (activeTemplatePOS == null || activeTemplatePOS.isEmpty()) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u8fd8\u672a\u914d\u7f6e\u6a21\u677f\u4fe1\u606f");
            }
            return null;
        }
        if (activeTemplatePOS.size() > templateNum) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u6240\u914d\u7f6e\u7684\u6a21\u677f\u7c7b\u578b\u5927\u4e8e2\u6761");
            }
            return null;
        }
        if (activeTemplatePOS.size() == templateNum && activeTemplatePOS.get(0).getTemplateType().equals(activeTemplatePOS.get(1).getTemplateType())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8[" + activityChoiceAtomBO.getActiveId() + "]\u6240\u914d\u7f6e\u7684\u6a21\u677f\u7c7b\u578b\u91cd\u590d");
            }
            return null;
        }
        return activeTemplatePOS;
    }

    private ActCalcPriceAtomBO calculatePriceByTemp(List<ActiveTemplatePO> activeTemplatePOS, ActivityChoiceAtomBO activityChoiceAtomBO, SkuDetailReqAtomBO skuDetailReqAtomBO, BigDecimal disCountAmont, BigDecimal disSkuPrice) {
        ActCalcPriceAtomBO actCalcPriceAtomBO = new ActCalcPriceAtomBO();
        ArrayList<ActiveGiftBO> singleActiveGiftList = new ArrayList<ActiveGiftBO>();
        ArrayList<ActiveGiftPkgBO> singleActiveGiftPkgList = new ArrayList<ActiveGiftPkgBO>();
        boolean isMeetCondition = true;
        for (ActiveTemplatePO activeTemplatePO : activeTemplatePOS) {
            if (SECK_KILL_SKU_NO.equals(activeTemplatePO.getTemplateType())) {
                ActSkuJudgeAtomRspBO actSkuJudgeAtomRspBO = this.judgeCondition(activityChoiceAtomBO, activeTemplatePO, skuDetailReqAtomBO);
                if (!"0000".equals(actSkuJudgeAtomRspBO.getRespCode()) && !"1014".equals(actSkuJudgeAtomRspBO.getRespCode())) {
                    actCalcPriceAtomBO.setRespCode(actSkuJudgeAtomRspBO.getRespCode());
                    actCalcPriceAtomBO.setRespDesc(actSkuJudgeAtomRspBO.getRespDesc());
                    return actCalcPriceAtomBO;
                }
                if ("1014".equals(actSkuJudgeAtomRspBO.getRespCode())) {
                    isMeetCondition = false;
                }
            }
            if (!isMeetCondition) break;
            if (!SECK_KILL_SKU_YES.equals(activeTemplatePO.getTemplateType())) continue;
            ActSkuDiscountRspBO actSkuDiscountRspBO = this.calculationPreferential(activityChoiceAtomBO, activeTemplatePO, skuDetailReqAtomBO, disCountAmont, disSkuPrice);
            if (!"0000".equals(actSkuDiscountRspBO.getRespCode())) {
                actCalcPriceAtomBO.setRespCode(actSkuDiscountRspBO.getRespCode());
                actCalcPriceAtomBO.setRespDesc("\u5355\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u8ba1\u7b97\u4ef7\u683c\u5931\u8d25:" + actSkuDiscountRspBO.getRespDesc());
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("\u5355\u54c1[" + skuDetailReqAtomBO.getSkuId() + "]\u8ba1\u7b97\u4ef7\u683c\u5931\u8d25:" + actSkuDiscountRspBO.getRespDesc());
                }
                return actCalcPriceAtomBO;
            }
            disCountAmont = actSkuDiscountRspBO.getSkuDetailActRspAtomBO().getSkuDisAmount();
            disSkuPrice = actSkuDiscountRspBO.getSkuDetailActRspAtomBO().getSkuDisPrice();
        }
        if (isMeetCondition) {
            ActGiftQueryAtomRspBO giftQueryRspBO = this.qryGifts(activityChoiceAtomBO.getActiveId());
            singleActiveGiftList.addAll(giftQueryRspBO.getGiftList());
            singleActiveGiftPkgList.addAll(giftQueryRspBO.getGiftPkgList());
        }
        actCalcPriceAtomBO.setRespCode("0000");
        actCalcPriceAtomBO.setDisCountAmont(disCountAmont);
        actCalcPriceAtomBO.setDisSkuPrice(disSkuPrice);
        actCalcPriceAtomBO.setGiftList(singleActiveGiftList);
        actCalcPriceAtomBO.setGiftPkgList(singleActiveGiftPkgList);
        return actCalcPriceAtomBO;
    }

    private ActSkuJudgeAtomRspBO judgeCondition(ActivityChoiceAtomBO activityChoiceAtomBO, ActiveTemplatePO activeTemplatePO, SkuDetailReqAtomBO skuDetailReqAtomBO) {
        ActSkuJudgeAtomReqBO actSkuJudgeAtomReqBO = new ActSkuJudgeAtomReqBO();
        actSkuJudgeAtomReqBO.setActId(activityChoiceAtomBO.getActiveId());
        actSkuJudgeAtomReqBO.setTemplateId(activeTemplatePO.getTemplateId());
        SkuDetailActReqAtomBO skuDetailActReqAtomBO = new SkuDetailActReqAtomBO();
        skuDetailActReqAtomBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailActReqAtomBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailActReqAtomBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailActReqAtomBO.setSkuPrice(skuDetailReqAtomBO.getSkuPrice());
        actSkuJudgeAtomReqBO.setSkuDetailActReqAtomBO(skuDetailActReqAtomBO);
        return this.actSkuJudgeAtomService.judgeOrder(actSkuJudgeAtomReqBO);
    }

    private ActSkuDiscountRspBO calculationPreferential(ActivityChoiceAtomBO activityChoiceAtomBO, ActiveTemplatePO activeTemplatePO, SkuDetailReqAtomBO skuDetailReqAtomBO, BigDecimal disCountAmont, BigDecimal disPrice) {
        ActSkuDiscountReqBO actSkuDiscountReqBO = new ActSkuDiscountReqBO();
        actSkuDiscountReqBO.setActId(activityChoiceAtomBO.getActiveId());
        actSkuDiscountReqBO.setTemplateId(activeTemplatePO.getTemplateId());
        actSkuDiscountReqBO.setDisCountAmont(disCountAmont);
        SkuDetailActReqAtomBO skuDetailDiscountAtomReqBO = new SkuDetailActReqAtomBO();
        skuDetailDiscountAtomReqBO.setSkuId(skuDetailReqAtomBO.getSkuId());
        skuDetailDiscountAtomReqBO.setSkuNum(skuDetailReqAtomBO.getSkuNum());
        skuDetailDiscountAtomReqBO.setShopId(skuDetailReqAtomBO.getShopId());
        skuDetailDiscountAtomReqBO.setSkuPrice(disPrice);
        actSkuDiscountReqBO.setSkuDetailActReqAtomBO(skuDetailDiscountAtomReqBO);
        return this.actSkuDiscountAtomService.skuDiscount(actSkuDiscountReqBO);
    }

    private ActGiftQueryAtomRspBO qryGifts(Long activeId) {
        ActGiftQueryAtomReqBO actGiftQueryAtomReqBO = new ActGiftQueryAtomReqBO();
        actGiftQueryAtomReqBO.setActiveId(activeId);
        return this.actGiftQueryAtomService.queryGift(actGiftQueryAtomReqBO);
    }
}

