/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActCreateCouponAppBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponAppBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponAppBusiRspBO;
import com.tydic.newretail.common.bo.CouponTaskBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponTaskMapper;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponTaskPO;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponAppBusiService")
public class ActCreateCouponAppBusiServiceImpl
implements ActCreateCouponAppBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateCouponAppBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private CouponTaskMapper couponTaskMapper;
    private CouponFormMapper couponFormMapper;

    @Autowired
    private ActCreateCouponAppBusiServiceImpl(CouponTaskMapper couponTaskMapper, CouponFormMapper couponFormMapper) {
        this.couponTaskMapper = couponTaskMapper;
        this.couponFormMapper = couponFormMapper;
    }

    public ActCreateCouponAppBusiRspBO createCouponApp(ActCreateCouponAppBusiReqBO reqBO) {
        ActCreateCouponAppBusiRspBO rspBO = new ActCreateCouponAppBusiRspBO();
        for (CouponTaskBO couponTaskBO : reqBO.getCouponTaskList()) {
            int check = this.couponFormMapper.getCheckById(couponTaskBO.getFmId());
            if (check >= 1) continue;
            if (IS_DEBUGABLE) {
                LOG.debug("\u89c4\u683cID[" + couponTaskBO.getFmId() + "]\uff0c\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            throw new BusinessException("6041", "\u89c4\u683cID[" + couponTaskBO.getFmId() + "]\uff0c\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        for (CouponTaskBO couponTaskBO : reqBO.getCouponTaskList()) {
            Date eff = DateUtils.strToDate((String)couponTaskBO.getEffTime(), (String)"yyyyMMdd");
            Date exp = this.getExpTime(eff, couponTaskBO);
            CouponTaskPO couponTaskPO = new CouponTaskPO();
            couponTaskPO.setAreaNo(couponTaskBO.getAreaNo());
            couponTaskPO.setCityNo(couponTaskBO.getCityNo());
            couponTaskPO.setCouponType(couponTaskBO.getCouponType());
            couponTaskPO.setCreateLoginId(couponTaskBO.getCreateLoginId());
            if (!StringUtils.isBlank((CharSequence)couponTaskBO.getCreateTime())) {
                couponTaskPO.setCreateTime(DateUtils.strToDateLong((String)couponTaskBO.getCreateTime()));
            } else {
                couponTaskPO.setCreateTime(new Date());
            }
            couponTaskPO.setEffTime(eff);
            couponTaskPO.setExpTime(exp);
            couponTaskPO.setFmId(couponTaskBO.getFmId());
            couponTaskPO.setPatchNum(couponTaskBO.getPatchNum());
            couponTaskPO.setProvinceNo(couponTaskBO.getProvinceNo());
            couponTaskPO.setShopId(couponTaskBO.getShopId());
            couponTaskPO.setTaskDesc(couponTaskBO.getTaskDesc());
            couponTaskPO.setTaskState(ActCommConstant.CouponTaskState.PENDING_AUDIT);
            couponTaskPO.setValidityLen(couponTaskBO.getValidityLen());
            couponTaskPO.setOnceNum(0);
            couponTaskPO.setTotalNum(0);
            int result = this.couponTaskMapper.insert(couponTaskPO);
            if (result >= 1) continue;
            if (IS_DEBUGABLE) {
                LOG.debug("\u4f18\u60e0\u5238\u521b\u5efa\u4efb\u52a1\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
            }
            throw new BusinessException("6040", "\u4f18\u60e0\u5238\u521b\u5efa\u4efb\u52a1\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u4efb\u52a1\u7533\u8bf7\u6210\u529f");
        return rspBO;
    }

    private Date getExpTime(Date eff, CouponTaskBO couponTaskBO) {
        Date exp = null;
        Calendar calendar = Calendar.getInstance();
        if (!StringUtils.isBlank((CharSequence)couponTaskBO.getExpTime())) {
            exp = DateUtils.strToDate((String)couponTaskBO.getExpTime(), (String)"yyyyMMdd");
            calendar.setTime(exp);
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            exp = calendar.getTime();
        } else {
            calendar.setTime(eff);
            calendar.add(13, -1);
            if (null != couponTaskBO.getValidityLen()) {
                calendar.add(6, couponTaskBO.getValidityLen());
            } else {
                CouponFormPO couponFormPO = this.couponFormMapper.getModelById(couponTaskBO.getFmId());
                if (couponFormPO != null) {
                    couponTaskBO.setValidityLen(couponFormPO.getValidityLen());
                    calendar.add(6, couponFormPO.getValidityLen());
                } else {
                    if (IS_DEBUGABLE) {
                        LOG.debug("\u67e5\u8be2\u89c4\u683c\u4fe1\u606f\u5f02\u5e38");
                    }
                    throw new BusinessException("6042", "\u67e5\u8be2\u89c4\u683c\u4fe1\u606f\u5f02\u5e38");
                }
            }
            exp = calendar.getTime();
        }
        return exp;
    }
}

