/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.ActOrderActivityCountAtomService;
import com.tydic.newretail.atom.ActSkuActivityCountAtomService;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomRspBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountReqBO;
import com.tydic.newretail.atom.bo.ActSkuActivityCountRspBO;
import com.tydic.newretail.atom.bo.ActivityChoiceAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailActReqAtomBO;
import com.tydic.newretail.atom.bo.SkuDetailReqAtomBO;
import com.tydic.newretail.busi.ActActivityCountBusiService;
import com.tydic.newretail.busi.bo.ActActivityCountBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityCountBusiRspBO;
import com.tydic.newretail.busi.bo.ActivityChoiceBusiBO;
import com.tydic.newretail.busi.bo.SkuDetailReqBusiBO;
import com.tydic.newretail.common.bo.SkuCountDetailRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityCountBusiService")
public class ActActivityCountBusiServiceImpl
implements ActActivityCountBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActivityCountBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private static final String IS_SECKILL_YES = "1";
    private static final String IS_SECKILL_NO = "0";
    @Autowired
    private ActOrderActivityCountAtomService actOrderActivityCountAtomService;
    @Autowired
    private ActSkuActivityCountAtomService actSkuActivityCountAtomService;

    public ActActivityCountBusiRspBO countActivity(ActActivityCountBusiReqBO reqBO) {
        ActActivityCountBusiRspBO rspBO = new ActActivityCountBusiRspBO();
        rspBO.setSeckillFlag(IS_SECKILL_NO);
        ArrayList<SkuCountDetailRspBO> skuCountDetailRspBOList = new ArrayList<SkuCountDetailRspBO>();
        for (SkuDetailReqBusiBO skuDetailReqBusiBO : reqBO.getSkuDetailList()) {
            ActSkuActivityCountRspBO skuAtomRspBO = this.callSkuActivityCount(skuDetailReqBusiBO);
            if (!"0000".equals(skuAtomRspBO.getRespCode())) {
                if (IS_DEBUGABLE) {
                    LOG.debug("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u5355\u54c1\u6d3b\u52a8\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25" + skuAtomRspBO.getRespDesc());
                }
                rspBO.setRespCode("2011");
                rspBO.setRespDesc(skuAtomRspBO.getRespDesc());
                return rspBO;
            }
            if (null == skuAtomRspBO.getSkuDetailRspAtomBO()) continue;
            SkuCountDetailRspBO skuCountDetailRspBO = new SkuCountDetailRspBO();
            BeanUtils.copyProperties((Object)skuAtomRspBO.getSkuDetailRspAtomBO(), (Object)skuCountDetailRspBO);
            if (IS_SECKILL_YES.equals(skuCountDetailRspBO.getSeckillFlag())) {
                reqBO.setOrderActivityList(null);
                rspBO.setSeckillFlag(IS_SECKILL_YES);
            }
            skuCountDetailRspBO.setGiftList(skuAtomRspBO.getSkuDetailRspAtomBO().getGiftList());
            skuCountDetailRspBO.setGiftPkgList(skuAtomRspBO.getSkuDetailRspAtomBO().getGiftPkgList());
            skuCountDetailRspBOList.add(skuCountDetailRspBO);
        }
        ActOrderActivityCountAtomRspBO orderAtomRspBO = this.callOrderActiveCount(reqBO, skuCountDetailRspBOList);
        if (!"0000".equals(orderAtomRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u8ba1\u7b97\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5931\u8d25" + orderAtomRspBO.getRespDesc());
            }
            rspBO.setRespCode("2011");
            rspBO.setRespDesc(orderAtomRspBO.getRespDesc());
            return rspBO;
        }
        this.formatRspInfo(skuCountDetailRspBOList, orderAtomRspBO, rspBO);
        rspBO.setRespTime(new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private ActSkuActivityCountRspBO callSkuActivityCount(SkuDetailReqBusiBO skuDetailReqBusiBO) {
        ActSkuActivityCountReqBO skuAtomReqBO = new ActSkuActivityCountReqBO();
        SkuDetailReqAtomBO skuDetailActivityReqBO = new SkuDetailReqAtomBO();
        BeanUtils.copyProperties((Object)skuDetailReqBusiBO, (Object)skuDetailActivityReqBO);
        if (!CollectionUtils.isEmpty((Collection)skuDetailReqBusiBO.getSkuActivityList())) {
            ArrayList<ActivityChoiceAtomBO> activityChoiceAtomBOS = new ArrayList<ActivityChoiceAtomBO>();
            for (ActivityChoiceBusiBO activityChoiceBusiBO : skuDetailReqBusiBO.getSkuActivityList()) {
                ActivityChoiceAtomBO activityChoiceAtomBO = new ActivityChoiceAtomBO();
                BeanUtils.copyProperties((Object)activityChoiceBusiBO, (Object)activityChoiceAtomBO);
                activityChoiceAtomBOS.add(activityChoiceAtomBO);
            }
            skuDetailActivityReqBO.setActivityChoiceAtomBOS(activityChoiceAtomBOS);
        }
        skuAtomReqBO.setActSkuActivityDetailReqBO(skuDetailActivityReqBO);
        return this.actSkuActivityCountAtomService.skuActivityCount(skuAtomReqBO);
    }

    private ActOrderActivityCountAtomRspBO callOrderActiveCount(ActActivityCountBusiReqBO reqBO, List<SkuCountDetailRspBO> orderAtomReqList) {
        ActOrderActivityCountAtomReqBO orderAtomReqBO = new ActOrderActivityCountAtomReqBO();
        ArrayList<SkuDetailActReqAtomBO> skuDetailActReqAtomBOList = new ArrayList<SkuDetailActReqAtomBO>();
        for (SkuCountDetailRspBO atomSkuDetailReqBusiBO : orderAtomReqList) {
            SkuDetailActReqAtomBO skuDetailActReqAtomBO = new SkuDetailActReqAtomBO();
            BeanUtils.copyProperties((Object)atomSkuDetailReqBusiBO, (Object)skuDetailActReqAtomBO);
            skuDetailActReqAtomBO.setSkuPrice(atomSkuDetailReqBusiBO.getSkuDisPrice());
            skuDetailActReqAtomBOList.add(skuDetailActReqAtomBO);
        }
        orderAtomReqBO.setSkuDetailAtomList(skuDetailActReqAtomBOList);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderActivityList())) {
            ArrayList<ActivityChoiceAtomBO> activityChoiceAtomBOList = new ArrayList<ActivityChoiceAtomBO>();
            for (ActivityChoiceBusiBO activityChoiceBusiBO : reqBO.getOrderActivityList()) {
                ActivityChoiceAtomBO activityChoiceAtomBO = new ActivityChoiceAtomBO();
                BeanUtils.copyProperties((Object)activityChoiceBusiBO, (Object)activityChoiceAtomBO);
                activityChoiceAtomBOList.add(activityChoiceAtomBO);
            }
            orderAtomReqBO.setActivityAtomList(activityChoiceAtomBOList);
        }
        if (reqBO.getFreightAmount() == null) {
            orderAtomReqBO.setFreightAmount(BigDecimal.ZERO);
        } else {
            orderAtomReqBO.setFreightAmount(reqBO.getFreightAmount());
        }
        return this.actOrderActivityCountAtomService.orderActivityCount(orderAtomReqBO);
    }

    private void formatRspInfo(List<SkuCountDetailRspBO> skuCountDetailRspBOList, ActOrderActivityCountAtomRspBO orderAtomRspBO, ActActivityCountBusiRspBO rspBO) {
        BigDecimal orderDiscount;
        BigDecimal totalSkuDisCount = skuCountDetailRspBOList.stream().map(skuDetail -> skuDetail.getSkuDisAmount().multiply(skuDetail.getSkuNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal bigDecimal = orderDiscount = orderAtomRspBO.getDisTotalAmo() != null ? orderAtomRspBO.getDisTotalAmo() : BigDecimal.ZERO;
        if (orderDiscount.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal totalAmount = totalSkuDisCount.add(orderDiscount).add(orderAtomRspBO.getTotalAmount());
            BigDecimal shareDiscount = BigDecimal.ZERO;
            int skuLength = skuCountDetailRspBOList.size();
            for (int index = 0; index < skuLength; ++index) {
                BigDecimal shareOrderDiscount;
                SkuCountDetailRspBO skuDetailRsp = skuCountDetailRspBOList.get(index);
                BigDecimal skuNum = skuDetailRsp.getSkuNum();
                BigDecimal skuRate = skuDetailRsp.getSkuPrice().multiply(skuNum).divide(totalAmount, 2, 5);
                if (index == skuLength - 1) {
                    shareOrderDiscount = orderDiscount.subtract(shareDiscount);
                } else {
                    shareOrderDiscount = orderDiscount.multiply(skuRate).setScale(0, 5);
                    shareDiscount = shareDiscount.add(shareOrderDiscount);
                }
                skuDetailRsp.setSkuTotalAmount(skuDetailRsp.getSkuDisAmount().multiply(skuNum).add(shareOrderDiscount).setScale(2, 5));
                BigDecimal skuDisPrice = skuDetailRsp.getSkuDisPrice().multiply(skuNum).subtract(shareOrderDiscount);
                if (skuDisPrice.compareTo(BigDecimal.ZERO) < 0) {
                    skuDetailRsp.setSkuTotalPrice(BigDecimal.ZERO);
                    continue;
                }
                skuDetailRsp.setSkuTotalPrice(skuDisPrice.setScale(2, 5));
            }
        } else {
            for (SkuCountDetailRspBO skuDetailRsp : skuCountDetailRspBOList) {
                skuDetailRsp.setSkuTotalAmount(skuDetailRsp.getSkuDisAmount().multiply(skuDetailRsp.getSkuNum()).setScale(2, 5));
                skuDetailRsp.setSkuTotalPrice(skuDetailRsp.getSkuDisPrice().multiply(skuDetailRsp.getSkuNum()).setScale(2, 5));
            }
        }
        BigDecimal finalTotalAmount = BigDecimal.ZERO;
        rspBO.setDisTotalAmo(orderDiscount.add(totalSkuDisCount).setScale(2, 5));
        if (null != orderAtomRspBO.getTotalAmount()) {
            finalTotalAmount = finalTotalAmount.add(orderAtomRspBO.getTotalAmount());
            rspBO.setTotalAmount(orderAtomRspBO.getTotalAmount().setScale(2, 5));
        }
        if (null != orderAtomRspBO.getDisFreightAmo()) {
            rspBO.setDisFreightAmo(orderAtomRspBO.getDisFreightAmo().setScale(2, 5));
        }
        if (null != orderAtomRspBO.getFreightAmount()) {
            finalTotalAmount = finalTotalAmount.add(orderAtomRspBO.getFreightAmount());
            rspBO.setFreightAmount(orderAtomRspBO.getFreightAmount().setScale(2, 5));
        }
        rspBO.setFinalTotalAmount(finalTotalAmount.setScale(2, 5));
        rspBO.setOrderGiftList(orderAtomRspBO.getOrderGiftList());
        rspBO.setOrderGiftPkgList(orderAtomRspBO.getOrderGiftPkgList());
        rspBO.setSkuDetailList(skuCountDetailRspBOList);
    }
}

