/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.atom.ActCouponValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.newretail.busi.ActCouponDeductionBusiService;
import com.tydic.newretail.busi.bo.ActCouponDeductionBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponDeductionBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponInstPO;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCouponDeductionBusiService")
public class ActCouponDeductionBusiServiceImpl
implements ActCouponDeductionBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCouponDeductionBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private ActCouponValidCheckAtomService actCouponValidCheckAtomService;
    private CouponInstMapper couponInstMapper;

    @Autowired
    public ActCouponDeductionBusiServiceImpl(ActCouponValidCheckAtomService actCouponValidCheckAtomService, CouponInstMapper couponInstMapper) {
        this.actCouponValidCheckAtomService = actCouponValidCheckAtomService;
        this.couponInstMapper = couponInstMapper;
    }

    public ActCouponDeductionBusiRspBO couponDeduction(ActCouponDeductionBusiReqBO reqBO) {
        ActCouponDeductionBusiRspBO rspBO = new ActCouponDeductionBusiRspBO();
        ActCouponValidCheckAtomReqBO checkAtomReqBO = new ActCouponValidCheckAtomReqBO();
        checkAtomReqBO.setCouponNo(reqBO.getCouponNo());
        ActCouponValidCheckAtomRspBO checkAtomRspBO = this.actCouponValidCheckAtomService.checkCouponValid(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            rspBO.setRespCode("2021");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        if (!ActCommConstant.CouponValidMark.VALID.equals(checkAtomRspBO.getCouponValidMark())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u65e0\u6548");
            return rspBO;
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getDeductionMoney())) {
            BigDecimal multiple = new BigDecimal("10000");
            multiple.multiply(new BigDecimal(reqBO.getDeductionMoney())).intValue();
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getUsedTime())) {
            DateUtils.strToDateLong((String)reqBO.getUsedTime());
        }
        CouponInstPO couponInstPO = new CouponInstPO();
        couponInstPO.setCouponNo(reqBO.getCouponNo());
        couponInstPO.setUsedSn(reqBO.getUsedSn());
        couponInstPO.setState(ActCommConstant.CouponState.USED);
        int updateResult = this.couponInstMapper.updateById(couponInstPO);
        if (updateResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
            }
            throw new BusinessException("6071", "\u4f18\u60e0\u5238\u62b5\u6263\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u62b5\u6263\u6210\u529f");
        return rspBO;
    }
}

