/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActUpdateCouponCreAppBusiService;
import com.tydic.newretail.busi.bo.ActUpdateCouponCreAppBusiReqBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponCreAppBusiRspBO;
import com.tydic.newretail.dao.CouponTaskMapper;
import com.tydic.newretail.dao.po.CouponTaskPO;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actUpdateCouponCreAppBusiService")
public class ActUpdateCouponCreAppBusiServiceImpl
implements ActUpdateCouponCreAppBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActUpdateCouponCreAppBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private CouponTaskMapper couponTaskMapper;

    @Autowired
    private ActUpdateCouponCreAppBusiServiceImpl(CouponTaskMapper couponTaskMapper) {
        this.couponTaskMapper = couponTaskMapper;
    }

    public ActUpdateCouponCreAppBusiRspBO updateCouponCreApp(ActUpdateCouponCreAppBusiReqBO reqBO) {
        ActUpdateCouponCreAppBusiRspBO rspBO = new ActUpdateCouponCreAppBusiRspBO();
        CouponTaskPO couponTaskPO = new CouponTaskPO();
        BeanUtils.copyProperties((Object)reqBO.getCouponTask(), (Object)couponTaskPO);
        couponTaskPO.setCreateTime(null);
        couponTaskPO.setCreateLoginId(null);
        this.dealTime(couponTaskPO, reqBO);
        int result = this.couponTaskMapper.updateById(couponTaskPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6051", "\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u66f4\u65b0\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u66f4\u65b0\u6210\u529f");
        return rspBO;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dealTime(CouponTaskPO couponTaskPO, ActUpdateCouponCreAppBusiReqBO reqBO) {
        if (!StringUtils.isBlank((CharSequence)reqBO.getCouponTask().getEffTime())) {
            couponTaskPO.setEffTime(DateUtils.strToDate((String)reqBO.getCouponTask().getEffTime(), (String)"yyyyMMdd"));
            if (StringUtils.isBlank((CharSequence)reqBO.getCouponTask().getExpTime())) {
                Calendar calendar;
                block10: {
                    calendar = Calendar.getInstance();
                    calendar.setTime(couponTaskPO.getEffTime());
                    calendar.add(13, -1);
                    if (null == reqBO.getCouponTask().getValidityLen()) {
                        CouponTaskPO taskPO = this.couponTaskMapper.getModelById(reqBO.getCouponTask().getTaskId());
                        if (null != taskPO) {
                            calendar.add(6, taskPO.getValidityLen());
                            break block10;
                        } else {
                            if (IS_DEBUGABLE) {
                                LOG.debug("\u67e5\u8be2\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u4fe1\u606f\u5931\u8d25");
                            }
                            throw new BusinessException("6052", "\u67e5\u8be2\u4f18\u60e0\u5238\u521b\u5efa\u7533\u8bf7\u4fe1\u606f\u5931\u8d25");
                        }
                    }
                    calendar.add(6, reqBO.getCouponTask().getValidityLen());
                }
                couponTaskPO.setExpTime(calendar.getTime());
            }
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getCouponTask().getExpTime())) {
            couponTaskPO.setExpTime(DateUtils.strToDate((String)reqBO.getCouponTask().getExpTime(), (String)"yyyyMMdd"));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getCouponTask().getAuditTime())) {
            couponTaskPO.setAuditTime(DateUtils.strToDateLong((String)reqBO.getCouponTask().getAuditTime()));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getCouponTask().getBeginTime())) {
            couponTaskPO.setBeginTime(DateUtils.strToDateLong((String)reqBO.getCouponTask().getBeginTime()));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getCouponTask().getEndTime())) {
            couponTaskPO.setEndTime(DateUtils.strToDateLong((String)reqBO.getCouponTask().getEndTime()));
        }
    }
}

