/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.ActUpdateCouponCreAppBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponCreAppBusiReqBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponCreAppBusiRspBO;
import com.tydic.newretail.comb.ActCreateCouponCombService;
import com.tydic.newretail.comb.bo.ActCreateCouponCombReqBO;
import com.tydic.newretail.comb.bo.ActCreateCouponCombRspBO;
import com.tydic.newretail.common.bo.CouponInstBO;
import com.tydic.newretail.common.bo.CouponTaskBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponTaskMapper;
import com.tydic.newretail.dao.po.CouponTaskPO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponCombService")
public class ActCreateCouponCombServiceImpl
implements ActCreateCouponCombService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateCouponCombServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private CouponTaskMapper couponTaskMapper;
    private ActCreateCouponBusiService actCreateCouponBusiService;
    private ActUpdateCouponCreAppBusiService actUpdateCouponCreAppBusiService;

    @Autowired
    public ActCreateCouponCombServiceImpl(CouponTaskMapper couponTaskMapper, ActCreateCouponBusiService actCreateCouponBusiService, ActUpdateCouponCreAppBusiService actUpdateCouponCreAppBusiService) {
        this.couponTaskMapper = couponTaskMapper;
        this.actCreateCouponBusiService = actCreateCouponBusiService;
        this.actUpdateCouponCreAppBusiService = actUpdateCouponCreAppBusiService;
    }

    public ActCreateCouponCombRspBO createCoupon(ActCreateCouponCombReqBO reqBO) {
        ActCreateCouponCombRspBO rspBO = new ActCreateCouponCombRspBO();
        for (Long taskId : reqBO.getTaskIdList()) {
            CouponTaskPO taskPO = this.couponTaskMapper.getModelById(taskId);
            CouponInstBO couponInstBO = new CouponInstBO();
            BeanUtils.copyProperties((Object)taskPO, (Object)couponInstBO);
            Date eff = couponInstBO.getEffTime();
            Date exp = couponInstBO.getExpTime();
            Date now = new Date();
            couponInstBO.setCreateTime(now);
            if (now.after(eff) && now.before(exp)) {
                couponInstBO.setState(ActCommConstant.CouponState.TO_BE_RECEIVED);
            }
            if (exp.before(new Date())) {
                couponInstBO.setState(ActCommConstant.CouponState.EXPIRED);
            }
            if (eff.after(new Date())) {
                couponInstBO.setState(ActCommConstant.CouponState.CREATED);
            }
            int failedCount = 0;
            int totalCount = taskPO.getPatchNum() - taskPO.getTotalNum();
            for (int i = 0; i < totalCount; ++i) {
                ActCreateCouponBusiReqBO busiReqBO = new ActCreateCouponBusiReqBO();
                busiReqBO.setCouponInfo(couponInstBO);
                ActCreateCouponBusiRspBO busiRspBO = this.actCreateCouponBusiService.createCoupon(busiReqBO);
                if ("0000".equals(busiRspBO.getRespCode())) continue;
                if (IS_DEBUGABLE) {
                    LOG.debug("\u4f18\u60e0\u5238\u521b\u5efa\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0\uff1a" + busiRspBO.getRespDesc());
                }
                ++failedCount;
            }
            int onceNum = totalCount - failedCount;
            int totalNum = taskPO.getTotalNum() + totalCount - failedCount;
            this.updateTaskInfo(taskPO, onceNum, totalNum, now);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u5b8c\u6210");
        return rspBO;
    }

    private void updateTaskInfo(CouponTaskPO taskPO, int onceNum, int totalNum, Date beginTime) {
        ActUpdateCouponCreAppBusiReqBO updateCouponCreAppBusiReqBO = new ActUpdateCouponCreAppBusiReqBO();
        CouponTaskBO couponTaskBO = new CouponTaskBO();
        couponTaskBO.setTaskId(taskPO.getTaskId());
        couponTaskBO.setBeginTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beginTime));
        couponTaskBO.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        couponTaskBO.setOnceNum(Integer.valueOf(onceNum));
        couponTaskBO.setTotalNum(Integer.valueOf(totalNum));
        if (taskPO.getPatchNum() == totalNum) {
            couponTaskBO.setTaskState(ActCommConstant.CouponTaskState.EXECUTIVE_COMPLETION);
        } else if (0 == totalNum) {
            couponTaskBO.setTaskState(ActCommConstant.CouponTaskState.EXECUTION_FAILURE);
        } else {
            couponTaskBO.setTaskState(ActCommConstant.CouponTaskState.PARTIAL_EXECUTION_COMPLETED);
        }
        updateCouponCreAppBusiReqBO.setCouponTask(couponTaskBO);
        ActUpdateCouponCreAppBusiRspBO updateCouponCreAppBusiRspBO = this.actUpdateCouponCreAppBusiService.updateCouponCreApp(updateCouponCreAppBusiReqBO);
        if (!"0000".equals(updateCouponCreAppBusiRspBO.getRespCode()) && IS_DEBUGABLE) {
            LOG.debug("[" + taskPO.getTaskId() + "]\u4efb\u52a1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
    }
}

