/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCreateCouponFormAbilityService;
import com.tydic.newretail.ability.bo.ActCreateCouponFormAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCreateCouponFormAbilityRspBO;
import com.tydic.newretail.busi.ActCreateCouponFormBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponFormBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponFormBusiRspBO;
import com.tydic.newretail.common.bo.CouponAmoInfoBO;
import com.tydic.newretail.common.bo.CouponRangeInfoBO;
import com.tydic.newretail.common.bo.CreateCouponFormInfoBO;
import com.tydic.newretail.constant.ActCommConstant;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponFormAbilityService")
public class ActCreateCouponFormAbilityServiceImpl
implements ActCreateCouponFormAbilityService {
    private static final String PARAM_MSG = "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    private ActCreateCouponFormBusiService actCreateCouponFormBusiService;

    @Autowired
    public ActCreateCouponFormAbilityServiceImpl(ActCreateCouponFormBusiService actCreateCouponFormBusiService) {
        this.actCreateCouponFormBusiService = actCreateCouponFormBusiService;
    }

    public ActCreateCouponFormAbilityRspBO createCouponForm(ActCreateCouponFormAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActCreateCouponFormAbilityRspBO rspBO = new ActCreateCouponFormAbilityRspBO();
        ActCreateCouponFormBusiReqBO busiReqBO = new ActCreateCouponFormBusiReqBO();
        busiReqBO.setCouponFormInfoList(reqBO.getCouponFormInfoList());
        ActCreateCouponFormBusiRspBO busiRspBO = this.actCreateCouponFormBusiService.createCouponForm(busiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private void validateArg(ActCreateCouponFormAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCouponFormInfoList())) {
            throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CreateCouponFormInfoBO couponFormInfoBO : reqBO.getCouponFormInfoList()) {
            if (null == couponFormInfoBO.getActiveId()) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6d3b\u52a8ID[activeId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponFormInfoBO.getValidityLen()) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u5238\u9ed8\u8ba4\u6709\u6548\u671f[validityLen]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponFormInfoBO.getCouponType()) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u5238\u7c7b\u578b[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getTotalFeeReach())) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u8fbe\u6807\u91d1\u989d[totalFeeReach]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ActCommConstant.CouponTypeCode.FULL_SUBTRACTION.equals(couponFormInfoBO.getCouponType())) {
                if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getFeeDiscount())) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u91d1\u989d[feeDiscount]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (ActCommConstant.CouponTypeCode.FULL_DISCOUNT.equals(couponFormInfoBO.getCouponType())) {
                if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getDiscountRate())) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6298\u6263\u7387[discountRate]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (ActCommConstant.CouponTypeCode.FREIGHT.equals(couponFormInfoBO.getCouponType())) {
                if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getDisFreightAmo())) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u4f18\u60e0\u8fd0\u8d39\u91d1\u989d[disFreightAmo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            } else if (ActCommConstant.CouponTypeCode.DEDUCTION.equals(couponFormInfoBO.getCouponType()) && StringUtils.isBlank((CharSequence)couponFormInfoBO.getDeductionAmount())) {
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u62b5\u6263\u91d1\u989d[deductionAmount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)couponFormInfoBO.getCouponRangeList())) {
                for (CouponRangeInfoBO couponRangeInfoBO : couponFormInfoBO.getCouponRangeList()) {
                    if (!StringUtils.isBlank((CharSequence)couponRangeInfoBO.getCategory4Id()) && StringUtils.isBlank((CharSequence)couponRangeInfoBO.getCategory3Id())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u8303\u56f4\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponRangeList]\u4e2d\u7684\u4e09\u7ea7\u7c7b\u76ee[category3Id]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isBlank((CharSequence)couponRangeInfoBO.getCategory3Id()) && StringUtils.isBlank((CharSequence)couponRangeInfoBO.getCategory2Id())) {
                        throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u8303\u56f4\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponRangeList]\u4e2d\u7684\u4e8c\u7ea7\u7c7b\u76ee[category2Id]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)couponRangeInfoBO.getCategory2Id()) || !StringUtils.isBlank((CharSequence)couponRangeInfoBO.getCategory1Id())) continue;
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u8303\u56f4\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponRangeList]\u4e2d\u7684\u4e00\u7ea7\u7c7b\u76ee[category1Id]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (CollectionUtils.isEmpty((Collection)couponFormInfoBO.getCouponAmountList())) continue;
            for (CouponAmoInfoBO couponAmoInfoBO : couponFormInfoBO.getCouponAmountList()) {
                if (null == couponAmoInfoBO.getTotalCount()) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponAmountList]\u4e2d\u7684\u603b\u6570\u91cf[totalCount]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == couponAmoInfoBO.getDistrCount()) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponAmountList]\u4e2d\u7684\u5df2\u6d3e\u53d1\u6570\u91cf[distrCount]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isBlank((CharSequence)couponAmoInfoBO.getAreaNo()) && StringUtils.isBlank((CharSequence)couponAmoInfoBO.getCityNo())) {
                    throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponAmountList]\u4e2d\u7684\u5730\u5e02[cityNo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)couponAmoInfoBO.getCityNo()) || !StringUtils.isBlank((CharSequence)couponAmoInfoBO.getProvinceNo())) continue;
                throw new BusinessException("8000", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u80fd\u529b\u670d\u52a1\u5165\u53c2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5217\u8868[couponFormInfoList]\u4e2d\u7684\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u5217\u8868[couponAmountList]\u4e2d\u7684\u7701\u4efd[provinceNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

