/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.busi.ActActDeleteBusiService;
import com.tydic.newretail.busi.bo.ActActDeleteBusiReqBO;
import com.tydic.newretail.busi.bo.ActActDeleteBusiRspBO;
import com.tydic.newretail.common.bo.DeleteActivityInfoBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.ShopActivePO;
import com.tydic.newretail.dao.po.SkuActivePO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActDeleteBusiService")
public class ActActDeleteBusiServiceImpl
implements ActActDeleteBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActActDeleteBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Autowired
    private ActivityMapper activityMapper;
    @Autowired
    private SkuActiveMapper skuActiveMapper;
    @Autowired
    private ShopActiveMapper shopActiveMapper;

    public ActActDeleteBusiRspBO deleteActivity(ActActDeleteBusiReqBO reqBO) {
        ActActDeleteBusiRspBO rspBO = new ActActDeleteBusiRspBO();
        for (DeleteActivityInfoBO deleteActivityInfoBO : reqBO.getDeleteActivityInfoList()) {
            ActivityPO actPO = new ActivityPO();
            actPO.setActiveId(deleteActivityInfoBO.getActiveId());
            actPO.setActiveCode(deleteActivityInfoBO.getActiveCode());
            actPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            ActivityPO activityPO = this.activityMapper.getModelBy(actPO);
            if (null == activityPO) {
                if (IS_DEBUGABLE) {
                    LOG.debug("Id[" + deleteActivityInfoBO.getActiveId() + "],Code[" + deleteActivityInfoBO.getActiveCode() + "]\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                throw new BusinessException("6021", "Id[" + deleteActivityInfoBO.getActiveId() + "],Code[" + deleteActivityInfoBO.getActiveCode() + "]\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            if (!StringUtils.isBlank((CharSequence)deleteActivityInfoBO.getSkuId()) && null != deleteActivityInfoBO.getShopId()) {
                this.deleteSkuAct(deleteActivityInfoBO, activityPO.getActiveId());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)deleteActivityInfoBO.getSkuId()) && null != deleteActivityInfoBO.getShopId()) {
                this.deleteShopAct(deleteActivityInfoBO, activityPO.getActiveId());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)deleteActivityInfoBO.getSkuId()) && null == deleteActivityInfoBO.getShopId()) {
                this.deleteAllAct(activityPO.getActiveId());
                continue;
            }
            if (IS_DEBUGABLE) {
                LOG.debug(JSON.toJSONString((Object)deleteActivityInfoBO) + "\u65e0\u6cd5\u5339\u914d\u5230\u9700\u8981\u5220\u9664\u7684\u6d3b\u52a8");
            }
            throw new BusinessException("6022", JSON.toJSONString((Object)deleteActivityInfoBO) + "\u65e0\u6cd5\u5339\u914d\u5230\u9700\u8981\u5220\u9664\u7684\u6d3b\u52a8");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u5220\u9664\u6210\u529f");
        return rspBO;
    }

    private void deleteSkuAct(DeleteActivityInfoBO deleteActivityInfoBO, Long activeId) {
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        skuActivePO.setSkuId(deleteActivityInfoBO.getSkuId());
        skuActivePO.setShopId(deleteActivityInfoBO.getShopId());
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (updateSkuActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5355\u54c1\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteShopAct(DeleteActivityInfoBO deleteActivityInfoBO, Long activeId) {
        ShopActivePO shopActivePO = new ShopActivePO();
        shopActivePO.setActiveId(activeId);
        shopActivePO.setShopId(deleteActivityInfoBO.getShopId());
        shopActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateShopActResult = this.shopActiveMapper.updateByCondition(shopActivePO);
        if (updateShopActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5e97\u94fa\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteAllAct(Long activeId) {
        ActivityPO activePO = new ActivityPO();
        activePO.setActiveId(activeId);
        activePO.setActiveStatus(ActCommConstant.ActivityState.DISABLED);
        activePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateActResult = this.activityMapper.updateById(activePO);
        if (updateActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        ShopActivePO shopActivePO = new ShopActivePO();
        shopActivePO.setActiveId(activeId);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int checkShop = this.shopActiveMapper.getCheckBy(shopActivePO);
        shopActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        shopActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateShopActResult = this.shopActiveMapper.updateByCondition(shopActivePO);
        if (checkShop > 0 && updateShopActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5e97\u94fa\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int checkSku = this.skuActiveMapper.getCheckBy(skuActivePO);
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (checkSku > 0 && updateSkuActResult < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u5355\u54c1\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }
}

