/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.po.CouponInstPO;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponBusiService")
public class ActCreateCouponBusiServiceImpl
implements ActCreateCouponBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateCouponBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    @Resource(name="couponNoSequencePager")
    private OrderSequence couponNoSequencePager;
    private CouponInstMapper couponInstMapper;

    @Autowired
    private ActCreateCouponBusiServiceImpl(CouponInstMapper couponInstMapper) {
        this.couponInstMapper = couponInstMapper;
    }

    public ActCreateCouponBusiRspBO createCoupon(ActCreateCouponBusiReqBO reqBO) {
        ActCreateCouponBusiRspBO rspBO = new ActCreateCouponBusiRspBO();
        CouponInstPO couponInstPO = new CouponInstPO();
        BeanUtils.copyProperties((Object)reqBO.getCouponInfo(), (Object)couponInstPO);
        try {
            couponInstPO.setCouponNo(reqBO.getCouponInfo().getCouponType() + new SimpleDateFormat("yyyyMMdd").format(reqBO.getCouponInfo().getEffTime()) + new DecimalFormat("000000000000").format(this.couponNoSequencePager.nextId()));
        }
        catch (SQLException e) {
            LOG.error("\u83b7\u53d6\u4f18\u60e0\u5238\u7f16\u7801\u5e8f\u5217\u53f7\u5f02\u5e38");
            throw new BusinessException("6031", "\u751f\u6210\u4f18\u60e0\u5238\u7f16\u7801\u5931\u8d25");
        }
        int result = this.couponInstMapper.insert(couponInstPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("[" + couponInstPO.getCouponNo() + "]\u8be5\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25");
            }
            throw new BusinessException("6031", "[" + couponInstPO.getCouponNo() + "]\u8be5\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u5b9e\u4f8b\u521b\u5efa\u6210\u529f");
        return rspBO;
    }
}

