/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActCreateCouponFormBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponFormBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponFormBusiRspBO;
import com.tydic.newretail.common.bo.CouponAmoInfoBO;
import com.tydic.newretail.common.bo.CouponRangeInfoBO;
import com.tydic.newretail.common.bo.CreateCouponFormInfoBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.ActiveTemplateMapper;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.CouponAmountMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponModMapper;
import com.tydic.newretail.dao.CouponRangeMapper;
import com.tydic.newretail.dao.ParamMapper;
import com.tydic.newretail.dao.TemplateMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.CouponAmountPO;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponRangePO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponFormBusiService")
public class ActCreateCouponFormBusiServiceImpl
implements ActCreateCouponFormBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActCreateCouponFormBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private CouponFormMapper couponFormMapper;
    private CouponAmountMapper couponAmountMapper;
    private CouponRangeMapper couponRangeMapper;
    private CouponModMapper couponModMapper;
    private ActiveAttrMapper activeAttrMapper;
    private ActiveTemplateMapper activeTemplateMapper;
    private ParamMapper paramMapper;
    private TemplateMapper templateMapper;
    private ActivityMapper activityMapper;

    @Autowired
    public ActCreateCouponFormBusiServiceImpl(CouponFormMapper couponFormMapper, CouponAmountMapper couponAmountMapper, CouponRangeMapper couponRangeMapper, CouponModMapper couponModMapper, ActiveAttrMapper activeAttrMapper, ActiveTemplateMapper activeTemplateMapper, ParamMapper paramMapper, TemplateMapper templateMapper, ActivityMapper activityMapper) {
        this.couponFormMapper = couponFormMapper;
        this.couponAmountMapper = couponAmountMapper;
        this.couponRangeMapper = couponRangeMapper;
        this.couponModMapper = couponModMapper;
        this.activeAttrMapper = activeAttrMapper;
        this.activeTemplateMapper = activeTemplateMapper;
        this.paramMapper = paramMapper;
        this.templateMapper = templateMapper;
        this.activityMapper = activityMapper;
    }

    public ActCreateCouponFormBusiRspBO createCouponForm(ActCreateCouponFormBusiReqBO reqBO) {
        ActCreateCouponFormBusiRspBO rspBO = new ActCreateCouponFormBusiRspBO();
        for (CreateCouponFormInfoBO couponFormInfoBO : reqBO.getCouponFormInfoList()) {
            ActivityPO activityPO = new ActivityPO();
            activityPO.setActiveId(couponFormInfoBO.getActiveId());
            activityPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            int check = this.activityMapper.getCheckById(couponFormInfoBO.getActiveId());
            if (check < 1) {
                if (IS_DEBUGABLE) {
                    LOG.debug("[" + couponFormInfoBO.getActiveId() + "]\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                throw new BusinessException("6062", "[" + couponFormInfoBO.getActiveId() + "]\u8be5\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            CouponFormPO couponFormPO = new CouponFormPO();
            BeanUtils.copyProperties((Object)couponFormInfoBO, (Object)couponFormPO);
            if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getCreateTime())) {
                couponFormPO.setCreateTime(new Date());
            } else {
                couponFormPO.setCreateTime(DateUtils.strToDateLong((String)couponFormInfoBO.getCreateTime()));
            }
            int formInsertResult = this.couponFormMapper.insert(couponFormPO);
            if (formInsertResult < 1) {
                if (IS_DEBUGABLE) {
                    LOG.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u89c4\u683c\u8868\u5931\u8d25");
                }
                throw new BusinessException("6061", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u89c4\u683c\u8868\u5931\u8d25");
            }
            long fmId = couponFormPO.getFmId();
            this.createCouponRange(couponFormInfoBO.getCouponRangeList(), fmId);
            this.createCouponAmount(couponFormInfoBO.getCouponAmountList(), fmId);
            this.createTemplate(couponFormInfoBO, fmId);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u5b8c\u6210");
        return rspBO;
    }

    private void createCouponRange(List<CouponRangeInfoBO> couponRangeList, long fmId) {
        if (!CollectionUtils.isEmpty(couponRangeList)) {
            for (CouponRangeInfoBO couponRangeInfoBO : couponRangeList) {
                CouponRangePO couponRangePO = new CouponRangePO();
                BeanUtils.copyProperties((Object)couponRangeInfoBO, (Object)couponRangePO);
                couponRangePO.setFmId(fmId);
                int rangeInsertResult = this.couponRangeMapper.insert(couponRangePO);
                if (rangeInsertResult >= 1) continue;
                if (IS_DEBUGABLE) {
                    LOG.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u8303\u56f4\u63a7\u5236\u8868\u5931\u8d25");
                }
                throw new BusinessException("6061", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u8303\u56f4\u63a7\u5236\u8868\u5931\u8d25");
            }
        }
    }

    private void createCouponAmount(List<CouponAmoInfoBO> couponAmountList, long fmId) {
        if (!CollectionUtils.isEmpty(couponAmountList)) {
            for (CouponAmoInfoBO couponAmoInfoBO : couponAmountList) {
                CouponAmountPO couponAmountPO = new CouponAmountPO();
                BeanUtils.copyProperties((Object)couponAmoInfoBO, (Object)couponAmountPO);
                couponAmountPO.setFmId(fmId);
                int AmountInsertResult = this.couponAmountMapper.insert(couponAmountPO);
                if (AmountInsertResult >= 1) continue;
                if (IS_DEBUGABLE) {
                    LOG.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u6570\u91cf\u63a7\u5236\u8868\u5931\u8d25");
                }
                throw new BusinessException("6061", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u6570\u91cf\u63a7\u5236\u8868\u5931\u8d25");
            }
        }
    }

    private void createTemplate(CreateCouponFormInfoBO couponFormInfoBO, long fmId) {
        if (ActCommConstant.CouponTypeCode.FULL_SUBTRACTION.equals(couponFormInfoBO.getCouponType()) || ActCommConstant.CouponTypeCode.FULL_DISCOUNT.equals(couponFormInfoBO.getCouponType()) || ActCommConstant.CouponTypeCode.FREIGHT.equals(couponFormInfoBO.getCouponType()) || ActCommConstant.CouponTypeCode.DEDUCTION.equals(couponFormInfoBO.getCouponType())) {
            // empty if block
        }
    }
}

