/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActCouponValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActCouponValidCheckAtomRspBO;
import com.tydic.newretail.busi.ActReceiveCouponBusiService;
import com.tydic.newretail.busi.bo.ActReceiveCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActReceiveCouponBusiRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponInstMapper;
import com.tydic.newretail.dao.CouponModMapper;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponInstPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actReceiveCouponBusiService")
public class ActReceiveCouponBusiServiceImpl
implements ActReceiveCouponBusiService {
    private static final Logger LOG = LoggerFactory.getLogger(ActReceiveCouponBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOG.isDebugEnabled();
    private ActCouponValidCheckAtomService actCouponValidCheckAtomService;
    private CouponInstMapper couponInstMapper;
    private CouponFormMapper couponFormMapper;
    private CouponModMapper couponModMapper;
    private ActiveAttrMapper activeAttrMapper;

    @Autowired
    public ActReceiveCouponBusiServiceImpl(ActCouponValidCheckAtomService actCouponValidCheckAtomService, CouponInstMapper couponInstMapper, CouponFormMapper couponFormMapper, CouponModMapper couponModMapper, ActiveAttrMapper activeAttrMapper) {
        this.actCouponValidCheckAtomService = actCouponValidCheckAtomService;
        this.couponInstMapper = couponInstMapper;
        this.couponFormMapper = couponFormMapper;
        this.couponModMapper = couponModMapper;
        this.activeAttrMapper = activeAttrMapper;
    }

    public ActReceiveCouponBusiRspBO receiveCoupon(ActReceiveCouponBusiReqBO reqBO) {
        ActReceiveCouponBusiRspBO rspBO = new ActReceiveCouponBusiRspBO();
        ActCouponValidCheckAtomReqBO checkAtomReqBO = new ActCouponValidCheckAtomReqBO();
        checkAtomReqBO.setCouponNo(reqBO.getCouponNo());
        ActCouponValidCheckAtomRspBO checkAtomRspBO = this.actCouponValidCheckAtomService.checkCouponValid(checkAtomReqBO);
        if (!"0000".equals(checkAtomRspBO.getRespCode())) {
            rspBO.setRespCode("2051");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u6709\u6548\u6821\u9a8c\u5931\u8d25");
            return rspBO;
        }
        if (!ActCommConstant.CouponValidMark.VALID.equals(checkAtomRspBO.getCouponValidMark())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8be5\u4f18\u60e0\u5238\u65e0\u6548");
            return rspBO;
        }
        CouponInstPO couponInstPO = this.couponInstMapper.getModelById(reqBO.getCouponNo());
        if (null == couponInstPO) {
            rspBO.setRespCode("2053");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        CouponFormPO couponFormPO = this.couponFormMapper.getModelById(couponInstPO.getFmId());
        if (null == couponFormPO) {
            rspBO.setRespCode("2053");
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u67e5\u8be2\u4f18\u60e0\u5238\u89c4\u683c\u4fe1\u606f\u5931\u8d25");
            return rspBO;
        }
        this.callMemCouponReceiveService(couponInstPO, couponFormPO);
        this.updateCouponInst(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u9886\u53d6\u6210\u529f");
        return rspBO;
    }

    private void callMemCouponReceiveService(CouponInstPO couponInstPO, CouponFormPO couponFormPO) {
    }

    private void updateCouponInst(ActReceiveCouponBusiReqBO reqBO) {
        CouponInstPO couponInstPO = new CouponInstPO();
        couponInstPO.setCouponNo(reqBO.getCouponNo());
        couponInstPO.setMemId(reqBO.getMemId());
        int result = this.couponInstMapper.updateById(couponInstPO);
        if (result < 1) {
            if (IS_DEBUGABLE) {
                LOG.debug("\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
            }
            throw new BusinessException("6101", "\u4f18\u60e0\u5238\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u66f4\u65b0\u4f18\u60e0\u5238\u5b9e\u4f8b\u4fe1\u606f\u5931\u8d25");
        }
    }
}

