/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.busi.ActQueryShopActiveBusiService;
import com.tydic.newretail.busi.bo.ActQueryShopActiveBusiReqBO;
import com.tydic.newretail.busi.bo.ActQueryShopActiveBusiRspBO;
import com.tydic.newretail.busi.bo.ShopActiveInfoBusiBO;
import com.tydic.newretail.comb.ActQryGroupActivityCombService;
import com.tydic.newretail.comb.bo.ActQryGroupActivityCombReqBO;
import com.tydic.newretail.comb.bo.ActQryGroupActivityCombRspBO;
import com.tydic.newretail.common.bo.ActQryGroupActivityBO;
import com.tydic.newretail.common.bo.ShopActiveInfoBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ShopActiveMapper;
import com.tydic.newretail.dao.po.ShopActivePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQryGroupActivityCombService")
public class ActQryGroupActivityCombServiceImpl
implements ActQryGroupActivityCombService {
    private static final Logger logger = LoggerFactory.getLogger(ActQryGroupActivityCombServiceImpl.class);
    @Autowired
    private ShopActiveMapper shopActiveMapper;
    @Autowired
    private ActQueryShopActiveBusiService actQueryShopActiveBusiService;

    public ActQryGroupActivityCombRspBO qryGroupActivity(ActQryGroupActivityCombReqBO reqBO) {
        ActQryGroupActivityCombRspBO rspBO = new ActQryGroupActivityCombRspBO();
        ArrayList<ActQryGroupActivityBO> shopActiveInfoList = new ArrayList<ActQryGroupActivityBO>();
        rspBO.setActiveInfoList(shopActiveInfoList);
        rspBO.setRespCode("0000");
        HashMap shopActiveMap = new HashMap(reqBO.getPageSize());
        HashMap<Long, String> shopNameMap = new HashMap<Long, String>(reqBO.getPageSize());
        ShopActivePO shopParamPO = new ShopActivePO();
        shopParamPO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        shopParamPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setLimit(reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List<ShopActivePO> shopActivityList = this.shopActiveMapper.qryValidShopGroupByPage(shopParamPO, (Page<Map<String, Object>>)page);
        rspBO.setTotalRecords(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotalPages(Integer.valueOf(page.getTotalPages()));
        if (CollectionUtils.isEmpty(shopActivityList)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6709\u6548\u5e97\u94fa\u6d3b\u52a8\u4fe1\u606f");
            return rspBO;
        }
        for (ShopActivePO shopActivePO : shopActivityList) {
            ActQueryShopActiveBusiReqBO queryShopActiveReqBO = new ActQueryShopActiveBusiReqBO();
            queryShopActiveReqBO.setShopId(shopActivePO.getShopId());
            queryShopActiveReqBO.setActiveId(reqBO.getActiveId());
            ActQueryShopActiveBusiRspBO queryShopActiveRspBO = this.actQueryShopActiveBusiService.queryShopActive(queryShopActiveReqBO);
            if (!CollectionUtils.isEmpty((Collection)queryShopActiveRspBO.getShopActiveInfoList())) {
                for (ShopActiveInfoBusiBO shopActiveInfoBusiBO : queryShopActiveRspBO.getShopActiveInfoList()) {
                    ShopActiveInfoBO shopActiveInfoBO = new ShopActiveInfoBO();
                    BeanUtils.copyProperties((Object)shopActiveInfoBusiBO, (Object)shopActiveInfoBO);
                    if (shopActiveMap.containsKey(shopActivePO.getShopId())) {
                        ((List)shopActiveMap.get(shopActivePO.getShopId())).add(shopActiveInfoBO);
                    } else {
                        ArrayList<ShopActiveInfoBO> activeInfoList = new ArrayList<ShopActiveInfoBO>();
                        activeInfoList.add(shopActiveInfoBO);
                        shopActiveMap.put(shopActivePO.getShopId(), activeInfoList);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)shopActivePO.getShopName())) continue;
                    shopNameMap.put(shopActivePO.getShopId(), shopActivePO.getShopName());
                }
                continue;
            }
            logger.error("\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u6d3b\u52a8\u4fe1\u606f[shopId=" + shopActivePO.getShopId() + "]");
        }
        if (shopActiveMap.isEmpty()) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u6d3b\u52a8\u4fe1\u606f");
            return rspBO;
        }
        for (Map.Entry entry : shopActiveMap.entrySet()) {
            ActQryGroupActivityBO activityCombBO = new ActQryGroupActivityBO();
            activityCombBO.setShopId((Long)entry.getKey());
            activityCombBO.setShopName((String)shopNameMap.get(entry.getKey()));
            shopActiveInfoList.add(activityCombBO);
            activityCombBO.setActiveInfoList((List)entry.getValue());
        }
        rspBO.setRespDesc("\u5e97\u94fa\u6d3b\u52a8\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

