/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.tydic.newretail.atom.ActCouponDiscountAtomService;
import com.tydic.newretail.atom.bo.ActCouponDiscountAtomReqBO;
import com.tydic.newretail.atom.bo.ActCouponDiscountAtomRspBO;
import com.tydic.newretail.busi.ActCouponRecommendBusiService;
import com.tydic.newretail.busi.bo.ActCouponRecommendBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponRecommendBusiRspBO;
import com.tydic.newretail.common.bo.RecommendCouponBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.umc.ability.UmcQryCouponListAbilityService;
import com.tydic.umc.ability.bo.UmcMemCouponAbilityBO;
import com.tydic.umc.ability.bo.UmcQryCouponListAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQryCouponListAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCouponRecommendBusiService")
public class ActCouponRecommendBusiServiceImpl
implements ActCouponRecommendBusiService {
    private static final Integer COMMON_COUPON_FLAG = 0;
    private static final Integer BEST_COUPON_FLAG = 1;
    @Autowired
    private ActCouponDiscountAtomService actCouponDiscountAtomService;
    @Autowired
    private UmcQryCouponListAbilityService umcQryCouponListAbilityService;

    public ActCouponRecommendBusiRspBO recommendCoupon(ActCouponRecommendBusiReqBO reqBO) {
        ActCouponRecommendBusiRspBO rspBO = new ActCouponRecommendBusiRspBO();
        ArrayList<RecommendCouponBO> recommendCouponList = new ArrayList<RecommendCouponBO>();
        rspBO.setRecommendCouponList(recommendCouponList);
        UmcQryCouponListAbilityReqBO qryCouponListReqBO = new UmcQryCouponListAbilityReqBO();
        qryCouponListReqBO.setMemId(reqBO.getMemId());
        qryCouponListReqBO.setUsedStates(Arrays.asList(ActCommConstant.MemberCouponState.UNUSED, ActCommConstant.MemberCouponState.PARTIAL_USE));
        qryCouponListReqBO.setPageSize(Integer.valueOf(99));
        UmcQryCouponListAbilityRspBO qryCouponListRspBO = this.umcQryCouponListAbilityService.qryCouponList(qryCouponListReqBO);
        if (!"0000".equals(qryCouponListRspBO.getRespCode()) || qryCouponListRspBO.getRecordsTotal() == 0) {
            rspBO.setRespCode(qryCouponListRspBO.getRespCode());
            rspBO.setRespDesc("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u670d\u52a1\u672a\u67e5\u8be2\u5230\u8be5\u4f1a\u5458\u53ef\u7528\u4f18\u60e0\u5238[memId=" + reqBO.getMemId() + "]");
            return rspBO;
        }
        List couponAbilityBOList = qryCouponListRspBO.getRows();
        BigDecimal oldDisOrderAmount = BigDecimal.ZERO;
        BigDecimal oldDisFreightAmount = BigDecimal.ZERO;
        int couponSize = 0;
        int bestCommonCouponIndex = 0;
        int bestFreightCouponIndex = 0;
        for (UmcMemCouponAbilityBO memCouponAbilityBO : couponAbilityBOList) {
            ActCouponDiscountAtomReqBO discountReqBO = new ActCouponDiscountAtomReqBO();
            discountReqBO.setCouponCodes(Collections.singletonList(memCouponAbilityBO.getCouponNo()));
            discountReqBO.setFreightAmount(reqBO.getFreightAmount());
            discountReqBO.setSkuDetailList(reqBO.getSkuList());
            ActCouponDiscountAtomRspBO discountRspBO = this.actCouponDiscountAtomService.couponDiscount(discountReqBO);
            if (!"0000".equals(discountRspBO.getRespCode()) || discountRspBO.getDisTotalAmo().compareTo(BigDecimal.ZERO) <= 0 && discountRspBO.getDisFreightAmo().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (discountRspBO.getDisTotalAmo().compareTo(oldDisOrderAmount) > 0) {
                oldDisOrderAmount = discountRspBO.getDisTotalAmo();
                bestCommonCouponIndex = couponSize;
            }
            if (discountRspBO.getDisFreightAmo().compareTo(oldDisFreightAmount) > 0) {
                oldDisFreightAmount = discountRspBO.getDisFreightAmo();
                bestFreightCouponIndex = couponSize;
            }
            RecommendCouponBO recommendCouponBO = new RecommendCouponBO();
            recommendCouponBO.setCouponType(memCouponAbilityBO.getCouponType());
            recommendCouponBO.setCouponNo(memCouponAbilityBO.getCouponNo());
            recommendCouponBO.setIsBest(COMMON_COUPON_FLAG);
            recommendCouponList.add(recommendCouponBO);
            ++couponSize;
        }
        if (couponSize > 0) {
            ((RecommendCouponBO)recommendCouponList.get(bestCommonCouponIndex)).setIsBest(BEST_COUPON_FLAG);
            ((RecommendCouponBO)recommendCouponList.get(bestFreightCouponIndex)).setIsBest(BEST_COUPON_FLAG);
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u63a8\u8350\u6210\u529f");
        } else {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u53ef\u62b5\u6263\u4f18\u60e0\u5238");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

