/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.newretail.atom.ActSkuSeckPriceQueryAtomService;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomReqBO;
import com.tydic.newretail.atom.bo.ActSkuSeckPriceQueryAtomRspBO;
import com.tydic.newretail.common.bo.SeckPriceQryRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CommodityKillCycleMapper;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillCyclePO;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSkuSeckPriceQueryAtomService")
public class ActSkuSeckPriceQueryAtomServiceImpl
implements ActSkuSeckPriceQueryAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSkuSeckPriceQueryAtomServiceImpl.class);
    private CommodityKillSkuMapper commodityKillSkuMapper;
    private CommodityKillCycleMapper commodityKillCycleMapper;

    @Autowired
    private ActSkuSeckPriceQueryAtomServiceImpl(CommodityKillSkuMapper commodityKillSkuMapper, CommodityKillCycleMapper commodityKillCycleMapper) {
        this.commodityKillSkuMapper = commodityKillSkuMapper;
        this.commodityKillCycleMapper = commodityKillCycleMapper;
    }

    @Override
    public ActSkuSeckPriceQueryAtomRspBO querySkuSeckPrice(ActSkuSeckPriceQueryAtomReqBO reqBO) {
        ActSkuSeckPriceQueryAtomRspBO rsp = new ActSkuSeckPriceQueryAtomRspBO();
        List<CommodityKillSkuPO> killSkuPOList = this.commodityKillSkuMapper.getListBatch(reqBO.getSeckPriceQryInfoList(), ActCommConstant.ActivityIsDelete.NORMAL);
        if (CollectionUtils.isEmpty(killSkuPOList)) {
            rsp.setSeckPriceQryResultList(new ArrayList<SeckPriceQryRspBO>());
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u79d2\u6740\u5355\u54c1\u8868\u67e5\u8be2\u4e3a\u7a7a\uff01");
            return rsp;
        }
        ArrayList<SeckPriceQryRspBO> seckPriceQryRspBOList = new ArrayList<SeckPriceQryRspBO>();
        for (CommodityKillSkuPO killSkuPO : killSkuPOList) {
            SeckPriceQryRspBO seckPriceQryRspBO = new SeckPriceQryRspBO();
            seckPriceQryRspBO.setKillCycleId(killSkuPO.getKillCycleId());
            seckPriceQryRspBO.setShopId(killSkuPO.getShopId());
            seckPriceQryRspBO.setSkuId(killSkuPO.getSkuId());
            int count = killSkuPO.getActualNum() - killSkuPO.getLockNum() - killSkuPO.getSalesNum();
            try {
                if (count <= 0) {
                    seckPriceQryRspBO.setSeckillFlag("0");
                    seckPriceQryRspBO.setSoldOutFlag(ActCommConstant.SoldOutFlag.YES);
                } else {
                    seckPriceQryRspBO.setSoldOutFlag(ActCommConstant.SoldOutFlag.NO);
                    if (this.validateCycle(killSkuPO.getKillCycleId())) {
                        seckPriceQryRspBO.setSeckillFlag("1");
                    } else {
                        seckPriceQryRspBO.setSeckillFlag("0");
                    }
                }
                seckPriceQryRspBO.setKillPrice(MoneyUtils.Long2BigDecimal((Long)killSkuPO.getKillPrice()));
                seckPriceQryRspBO.setSkuPrice(MoneyUtils.Long2BigDecimal((Long)killSkuPO.getSkuPrice()));
                seckPriceQryRspBOList.add(seckPriceQryRspBO);
            }
            catch (Exception e) {
                LOGGER.error("\u5546\u54c1\u79d2\u6740\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                rsp.setRespCode("6011");
                rsp.setRespDesc("\u5546\u54c1\u79d2\u6740\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                return rsp;
            }
        }
        rsp.setSeckPriceQryResultList(seckPriceQryRspBOList);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5546\u54c1\u79d2\u6740\u4ef7\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private boolean validateCycle(Long killCycleId) {
        CommodityKillCyclePO killCyclePO = this.commodityKillCycleMapper.getModelById(killCycleId);
        Date now = new Date();
        return ActCommConstant.ActivityIsDelete.NORMAL.equals(killCyclePO.getIsDelete()) && ActCommConstant.ActivityState.STATE_EFFECTIVE.equals(killCyclePO.getStatus()) && now.after(killCyclePO.getStartTime()) && now.before(killCyclePO.getEndTime());
    }
}

