/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActSeckCycSkuQueryBusiService;
import com.tydic.newretail.busi.bo.ActSeckCycSkuQueryBusiReqBO;
import com.tydic.newretail.busi.bo.ActSeckCycSkuQueryBusiRspBO;
import com.tydic.newretail.busi.bo.SeckillSkuBusiBO;
import com.tydic.newretail.dao.CommodityKillCycleMapper;
import com.tydic.newretail.dao.CommodityKillSkuMapper;
import com.tydic.newretail.dao.po.CommodityKillCyclePO;
import com.tydic.newretail.dao.po.CommodityKillSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSeckCycSkuQueryBusiService")
public class ActSeckCycSkuQueryBusiServiceImpl
implements ActSeckCycSkuQueryBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSeckCycSkuQueryBusiServiceImpl.class);
    private static final String SUCCESS_MSG = "\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u6210\u529f";
    private static final String ERROR_MSG = "\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u5931\u8d25";
    private CommodityKillCycleMapper commodityKillCycleMapper;
    private CommodityKillSkuMapper commodityKillSkuMapper;

    @Autowired
    private ActSeckCycSkuQueryBusiServiceImpl(CommodityKillCycleMapper commodityKillCycleMapper, CommodityKillSkuMapper commodityKillSkuMapper) {
        this.commodityKillCycleMapper = commodityKillCycleMapper;
        this.commodityKillSkuMapper = commodityKillSkuMapper;
    }

    public ActSeckCycSkuQueryBusiRspBO querySeckCycSku(ActSeckCycSkuQueryBusiReqBO reqBO) {
        ActSeckCycSkuQueryBusiRspBO rspBO = new ActSeckCycSkuQueryBusiRspBO();
        ArrayList seckillSkuList = new ArrayList();
        CommodityKillCyclePO killCyclePO = new CommodityKillCyclePO();
        if (!StringUtils.isBlank((CharSequence)reqBO.getPlateId())) {
            killCyclePO.setPlateId(Long.valueOf(reqBO.getPlateId()));
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getCycId())) {
            killCyclePO.setKillCycleId(Long.valueOf(reqBO.getCycId()));
        }
        killCyclePO.setStatus(1);
        Date start = DateUtils.strToDate((String)reqBO.getQueryDay(), (String)"yyyyMMdd");
        killCyclePO.setQueryDayStart(start);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(5, 1);
        killCyclePO.setQueryDayEnd(calendar.getTime());
        List<CommodityKillCyclePO> killCyclePOList = this.commodityKillCycleMapper.getList(killCyclePO);
        if (!CollectionUtils.isEmpty(killCyclePOList)) {
            for (CommodityKillCyclePO cyclePO : killCyclePOList) {
                CommodityKillSkuPO commodityKillSkuPO = new CommodityKillSkuPO();
                commodityKillSkuPO.setSkuId(reqBO.getSkuId());
                commodityKillSkuPO.setKillCycleId(cyclePO.getKillCycleId());
                List<CommodityKillSkuPO> killSkuPOList = this.commodityKillSkuMapper.getList(commodityKillSkuPO);
                if (CollectionUtils.isEmpty(killCyclePOList)) continue;
                ArrayList<SeckillSkuBusiBO> seckillSkuBusiBOList = new ArrayList<SeckillSkuBusiBO>();
                for (CommodityKillSkuPO killSkuPO : killSkuPOList) {
                    SeckillSkuBusiBO seckillSkuBusiBO = new SeckillSkuBusiBO();
                    BeanUtils.copyProperties((Object)killSkuPO, (Object)seckillSkuBusiBO);
                    if (seckillSkuBusiBO.getActualNum() == null) {
                        seckillSkuBusiBO.setActualNum(Integer.valueOf(0));
                    }
                    if (seckillSkuBusiBO.getLockNum() == null) {
                        seckillSkuBusiBO.setLockNum(Integer.valueOf(0));
                    }
                    if (seckillSkuBusiBO.getSalesNum() == null) {
                        seckillSkuBusiBO.setSalesNum(Integer.valueOf(0));
                    }
                    try {
                        seckillSkuBusiBO.setKillPrice(BigDecimal.valueOf(killSkuPO.getKillPrice()));
                        seckillSkuBusiBO.setSkuPrice(BigDecimal.valueOf(killSkuPO.getSkuPrice()));
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6d3b\u52a8\u4e2d\u5fc3\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1,\u91d1\u989d\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38" + e);
                        throw new BusinessException("6011", "\u79d2\u6740\u5468\u671f\u5546\u54c1\u67e5\u8be2\u5931\u8d25\u91d1\u989d\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                    }
                    seckillSkuBusiBOList.add(seckillSkuBusiBO);
                }
                seckillSkuList.addAll(seckillSkuBusiBOList);
            }
        }
        rspBO.setSeckillSkuList(seckillSkuList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(SUCCESS_MSG);
        return rspBO;
    }
}

