/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActOrderDiscountAtomService;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderDiscountAtomRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.CouponAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import com.tydic.newretail.dao.po.CouponAttrPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actOrderDiscountAtomService")
public class ActOrderDiscountAtomServiceImpl
implements ActOrderDiscountAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActOrderDiscountAtomServiceImpl.class);
    private ActiveAttrMapper activeAttrMapper;
    private CouponAttrMapper couponAttrMapper;
    private static Map<Long, Function<ActOrderDiscountAtomReqBO, Map<String, BigDecimal>>> templateActionMap = new HashMap<Long, Function<ActOrderDiscountAtomReqBO, Map<String, BigDecimal>>>(8);

    @Autowired
    public ActOrderDiscountAtomServiceImpl(ActiveAttrMapper activeAttrMapper, CouponAttrMapper couponAttrMapper) {
        this.activeAttrMapper = activeAttrMapper;
        this.couponAttrMapper = couponAttrMapper;
        templateActionMap.put(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID, this::calculateCashDiscount);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID, this::calculateDiscount);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_DCT_TEMP_ID, this::calculateFreightDiscount);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_FREE_TEMP_ID, this::freightFree);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_LADDER_DCT_TEMP_ID, this::calculateLadderDiscount);
    }

    @Override
    public ActOrderDiscountAtomRspBO orderDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        Long templateId = atomReqBO.getTemplateId();
        if (null == atomReqBO.getTotalAmount() || atomReqBO.getTotalAmount().compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (SkuDetailBO bo : atomReqBO.getSkuDetailList()) {
                totalAmount = totalAmount.add(bo.getSkuPrice().multiply(bo.getSkuNum()));
            }
            atomReqBO.setTotalAmount(totalAmount);
        }
        ActOrderDiscountAtomRspBO rsp = new ActOrderDiscountAtomRspBO();
        if (templateActionMap.get(templateId) == null) {
            rsp.setRespCode("1008");
            rsp.setRespDesc("\u4f20\u5165\u6a21\u677fID[" + templateId + "]\u4e0d\u652f\u6301\u6d3b\u52a8\u4f18\u60e0\u8ba1\u7b97");
            return rsp;
        }
        Map<String, BigDecimal> disPriceMap = templateActionMap.get(templateId).apply(atomReqBO);
        this.buildAftCalculationRspBO(disPriceMap, rsp);
        return rsp;
    }

    private void buildAftCalculationRspBO(Map<String, BigDecimal> disPriceMap, ActOrderDiscountAtomRspBO rspBO) {
        rspBO.setDisTotalAmo(disPriceMap.get("disTotalAmo"));
        rspBO.setDisFreightAmo(disPriceMap.get("disFreightAmo"));
        rspBO.setTotalAmount(disPriceMap.get("totalAmount"));
        rspBO.setFreightAmount(disPriceMap.get("freightAmount"));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
    }

    private String qryActiveAttr(ActOrderDiscountAtomReqBO reqBo, String paraCode) {
        String attrValue;
        if ("coupon".equals(reqBo.getAttrType())) {
            CouponAttrPO couponAttrPO = new CouponAttrPO();
            couponAttrPO.setFmId(reqBo.getActiveId());
            couponAttrPO.setTemplateId(reqBo.getTemplateId());
            couponAttrPO.setParaCode(paraCode);
            couponAttrPO = this.couponAttrMapper.getModelBy(couponAttrPO);
            if (couponAttrPO == null) {
                throw new BusinessException("1009", "\u672a\u67e5\u8be2\u5230\u6a21\u677fID[" + reqBo.getTemplateId() + "]\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
            }
            if (StringUtils.isBlank((CharSequence)couponAttrPO.getParaValue())) {
                throw new BusinessException("1009", "\u6a21\u677fID[" + reqBo.getTemplateId() + "]\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u672a\u8bbe\u7f6e\u6d3b\u52a8\u5177\u4f53\u503c");
            }
            attrValue = couponAttrPO.getParaValue();
        } else {
            ActiveAttrPO activeAttrPO = new ActiveAttrPO();
            activeAttrPO.setActiveId(reqBo.getActiveId());
            activeAttrPO.setTemplateId(reqBo.getTemplateId());
            activeAttrPO.setParaCode(paraCode);
            activeAttrPO = this.activeAttrMapper.getModelBy(activeAttrPO);
            if (activeAttrPO == null) {
                throw new BusinessException("1009", "\u672a\u67e5\u8be2\u5230\u6a21\u677fID[" + reqBo.getTemplateId() + "]\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
            }
            if (StringUtils.isBlank((CharSequence)activeAttrPO.getParaValue())) {
                throw new BusinessException("1009", "\u6a21\u677fID[" + reqBo.getTemplateId() + "]\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u672a\u8bbe\u7f6e\u6d3b\u52a8\u5177\u4f53\u503c");
            }
            attrValue = activeAttrPO.getParaValue();
        }
        return attrValue;
    }

    private Map<String, BigDecimal> calculateCashDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        BigDecimal feeDiscount = new BigDecimal(this.qryActiveAttr(atomReqBO, "total_fee_discount"));
        String accAttr = this.qryActiveAttr(atomReqBO, "accumulate_flag");
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        String accFlag = "1";
        BigDecimal newDisTotalAmo = accFlag.equals(accAttr) ? feeDiscount.multiply(BigDecimal.valueOf(atomReqBO.getMulCount().intValue())) : feeDiscount;
        BigDecimal newTotalAmount = atomReqBO.getTotalAmount().subtract(newDisTotalAmo);
        if (null != atomReqBO.getDisTotalAmo()) {
            newDisTotalAmo = newDisTotalAmo.add(atomReqBO.getDisTotalAmo());
        }
        calculatePrice.put("totalAmount", newTotalAmount);
        calculatePrice.put("disTotalAmo", newDisTotalAmo);
        calculatePrice.put("disFreightAmo", BigDecimal.ZERO);
        calculatePrice.put("freightAmount", atomReqBO.getFreightAmount());
        return calculatePrice;
    }

    private Map<String, BigDecimal> calculateDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        BigDecimal discountRate = new BigDecimal(this.qryActiveAttr(atomReqBO, "total_fee_discount_rate"));
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        BigDecimal totalAmount = atomReqBO.getTotalAmount();
        BigDecimal newDisTotalAmo = totalAmount.subtract(totalAmount.multiply(discountRate));
        calculatePrice.put("totalAmount", totalAmount.subtract(newDisTotalAmo));
        if (null != atomReqBO.getDisTotalAmo()) {
            newDisTotalAmo = newDisTotalAmo.add(atomReqBO.getDisTotalAmo());
        }
        calculatePrice.put("disTotalAmo", newDisTotalAmo);
        calculatePrice.put("disFreightAmo", BigDecimal.ZERO);
        calculatePrice.put("freightAmount", atomReqBO.getFreightAmount());
        return calculatePrice;
    }

    private Map<String, BigDecimal> calculateFreightDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        BigDecimal disFreightAmo;
        BigDecimal feeDiscount = new BigDecimal(this.qryActiveAttr(atomReqBO, "total_fee_discount"));
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        BigDecimal freightAmount = atomReqBO.getFreightAmount();
        if (feeDiscount.compareTo(freightAmount) < 0) {
            disFreightAmo = feeDiscount;
            freightAmount = freightAmount.subtract(disFreightAmo);
        } else {
            disFreightAmo = freightAmount;
            freightAmount = BigDecimal.ZERO;
        }
        calculatePrice.put("disFreightAmo", disFreightAmo);
        calculatePrice.put("freightAmount", freightAmount);
        calculatePrice.put("totalAmount", atomReqBO.getTotalAmount());
        calculatePrice.put("disTotalAmo", atomReqBO.getDisTotalAmo() != null ? atomReqBO.getDisTotalAmo() : BigDecimal.ZERO);
        return calculatePrice;
    }

    private Map<String, BigDecimal> freightFree(ActOrderDiscountAtomReqBO atomReqBO) {
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        calculatePrice.put("disFreightAmo", atomReqBO.getFreightAmount());
        calculatePrice.put("freightAmount", BigDecimal.ZERO);
        calculatePrice.put("totalAmount", atomReqBO.getTotalAmount());
        calculatePrice.put("disTotalAmo", atomReqBO.getDisTotalAmo() != null ? atomReqBO.getDisTotalAmo() : BigDecimal.ZERO);
        return calculatePrice;
    }

    private Map<String, BigDecimal> calculateLadderDiscount(ActOrderDiscountAtomReqBO atomReqBO) {
        String splitFlag = "-";
        HashMap<String, BigDecimal> calculatePrice = new HashMap<String, BigDecimal>(8);
        ActiveAttrPO paramAttrPO = new ActiveAttrPO();
        paramAttrPO.setActiveId(atomReqBO.getActiveId());
        paramAttrPO.setTemplateId(atomReqBO.getTemplateId());
        paramAttrPO.setParaCode("total_fee_reach_discount");
        List<ActiveAttrPO> attrList = this.activeAttrMapper.getList(paramAttrPO);
        if (CollectionUtils.isEmpty(attrList)) {
            throw new BusinessException("1009", "\u672a\u67e5\u8be2\u5230\u6a21\u677fID[" + atomReqBO.getTemplateId() + "]\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
        }
        BigDecimal reachAmount = BigDecimal.ZERO;
        BigDecimal disAmount = BigDecimal.ZERO;
        for (ActiveAttrPO activeAttrPO : attrList) {
            if (StringUtils.isBlank((CharSequence)activeAttrPO.getParaValue()) || !activeAttrPO.getParaValue().contains(splitFlag) || activeAttrPO.getParaValue().trim().split(splitFlag).length != 2) {
                LOGGER.error("\u603b\u91d1\u989d\u68af\u5ea6\u4f18\u60e0\u6a21\u677f[templateId=200005]\u5bf9\u5e94\u7684\u6d3b\u52a8\u5c5e\u6027\u914d\u7f6e\u4e0d\u6b63\u786e[activeId=" + atomReqBO.getActiveId() + "]");
                continue;
            }
            String[] attrArray = activeAttrPO.getParaValue().trim().split(splitFlag);
            BigDecimal newReachAmount = new BigDecimal(attrArray[0]);
            if (atomReqBO.getTotalAmount().compareTo(newReachAmount) < 0 || newReachAmount.compareTo(reachAmount) < 0) continue;
            reachAmount = newReachAmount;
            disAmount = new BigDecimal(attrArray[1]);
        }
        calculatePrice.put("totalAmount", atomReqBO.getTotalAmount().subtract(disAmount));
        if (null != atomReqBO.getDisTotalAmo()) {
            disAmount = disAmount.add(atomReqBO.getDisTotalAmo());
        }
        calculatePrice.put("disTotalAmo", disAmount);
        calculatePrice.put("disFreightAmo", BigDecimal.ZERO);
        calculatePrice.put("freightAmount", atomReqBO.getFreightAmount());
        return calculatePrice;
    }
}

