/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActSkuDiscountAtomService;
import com.tydic.newretail.atom.bo.ActSkuDiscountReqBO;
import com.tydic.newretail.atom.bo.ActSkuDiscountRspBO;
import com.tydic.newretail.atom.bo.SkuDetailActRspAtomBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveAttrMapper;
import com.tydic.newretail.dao.po.ActiveAttrPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actSkuDiscountAtomService")
public class ActSkuDiscountAtomServiceImpl
implements ActSkuDiscountAtomService {
    private ActiveAttrMapper activeAttrMapper;
    private static Map<Long, Function<ActSkuDiscountReqBO, Map<String, BigDecimal>>> templateActionMap = new HashMap<Long, Function<ActSkuDiscountReqBO, Map<String, BigDecimal>>>(8);

    @Autowired
    private ActSkuDiscountAtomServiceImpl(ActiveAttrMapper activeAttrMapper) {
        this.activeAttrMapper = activeAttrMapper;
        templateActionMap.put(ActCommConstant.DifActivityTempIds.SGL_PRD_CASH_DCT_TEMP_ID, this::calculateCashDiscount);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.SGL_PRD_DCT_TEMP_ID, this::calculateDiscount);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.SGL_PRD_AFT_DCT_TEMP_ID, this::calculateDiscountRate);
        templateActionMap.put(ActCommConstant.DifActivityTempIds.SGL_PRD_DEFINE_PRICE_TEMP_ID, this::calculateRedefine);
    }

    @Override
    public ActSkuDiscountRspBO skuDiscount(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        Long templateId = actSkuDiscountReqBO.getTemplateId();
        ActSkuDiscountRspBO rspBO = new ActSkuDiscountRspBO();
        if (templateActionMap.get(templateId) == null) {
            rspBO.setRespCode("1002");
            rspBO.setRespDesc("\u4f20\u5165\u6a21\u677fID[" + templateId + "]\u4e0d\u652f\u6301\u5355\u54c1\u4f18\u60e0\u8ba1\u7b97");
            return rspBO;
        }
        Map<String, BigDecimal> disPriceMap = templateActionMap.get(templateId).apply(actSkuDiscountReqBO);
        this.buildRspBO(actSkuDiscountReqBO, disPriceMap, rspBO);
        return rspBO;
    }

    private String queryActiveAttr(ActSkuDiscountReqBO actSkuDiscountReqBO, String activityParamName) {
        ActiveAttrPO activeAttrModel = new ActiveAttrPO();
        activeAttrModel.setActiveId(actSkuDiscountReqBO.getActId());
        activeAttrModel.setTemplateId(actSkuDiscountReqBO.getTemplateId());
        activeAttrModel.setParaCode(activityParamName);
        ActiveAttrPO activeAttrPO = this.activeAttrMapper.getModelBy(activeAttrModel);
        if (activeAttrPO == null) {
            throw new BusinessException("1002", "\u672a\u67e5\u8be2\u5230\u6a21\u677fID[" + actSkuDiscountReqBO.getTemplateId() + "]\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)activeAttrPO.getParaValue())) {
            throw new BusinessException("1002", "\u6a21\u677fID[" + actSkuDiscountReqBO.getTemplateId() + "]\u5bf9\u5e94\u7684\u6d3b\u52a8\u914d\u7f6e\u4e2d\u672a\u8bbe\u7f6e\u6d3b\u52a8\u5177\u4f53\u503c");
        }
        return activeAttrPO.getParaValue();
    }

    private void buildRspBO(ActSkuDiscountReqBO actSkuDiscountReqBO, Map<String, BigDecimal> disPriceMap, ActSkuDiscountRspBO rspBO) {
        BigDecimal skuDisPrice = disPriceMap.get("skuDisPrice");
        BigDecimal skuDisAmount = disPriceMap.get("skuDisAmount");
        SkuDetailActRspAtomBO skuDetailActRspAtomBO = new SkuDetailActRspAtomBO();
        skuDetailActRspAtomBO.setSkuId(actSkuDiscountReqBO.getSkuDetailBO().getSkuId());
        skuDetailActRspAtomBO.setSkuNum(actSkuDiscountReqBO.getSkuDetailBO().getSkuNum());
        skuDetailActRspAtomBO.setShopId(actSkuDiscountReqBO.getSkuDetailBO().getShopId());
        skuDetailActRspAtomBO.setSkuPrice(actSkuDiscountReqBO.getSkuDetailBO().getSkuPrice());
        skuDetailActRspAtomBO.setSkuDisPrice(skuDisPrice);
        skuDetailActRspAtomBO.setSkuDisAmount(skuDisAmount);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5355\u4e2a\u5546\u54c1[" + actSkuDiscountReqBO.getSkuDetailBO().getSkuId() + "]\u91d1\u989d\u4f18\u60e0\u6210\u529f");
        rspBO.setSkuDetailActRspAtomBO(skuDetailActRspAtomBO);
    }

    private Map<String, BigDecimal> calculateCashDiscount(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        String priceDiscount = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount");
        BigDecimal skuPrice = actSkuDiscountReqBO.getSkuDetailBO().getSkuPrice();
        BigDecimal disCountAmount = actSkuDiscountReqBO.getDisCountAmont();
        BigDecimal skuDisAmount = new BigDecimal(priceDiscount);
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateDiscount(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        String discountRate = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount_rate");
        BigDecimal skuPrice = actSkuDiscountReqBO.getSkuDetailBO().getSkuPrice();
        BigDecimal disCountAmount = actSkuDiscountReqBO.getDisCountAmont();
        BigDecimal discountNum = new BigDecimal(discountRate);
        BigDecimal skuDisAmount = skuPrice.multiply(BigDecimal.ONE.subtract(discountNum));
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateDiscountRate(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        String discountAttr = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount");
        String rateAttr = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_discount_rate");
        BigDecimal skuPrice = actSkuDiscountReqBO.getSkuDetailBO().getSkuPrice();
        BigDecimal disCountAmount = actSkuDiscountReqBO.getDisCountAmont();
        BigDecimal discountRate = new BigDecimal(rateAttr);
        BigDecimal skuDisAmount = skuPrice.multiply(BigDecimal.ONE.subtract(discountRate));
        BigDecimal discount = new BigDecimal(discountAttr);
        skuDisAmount = skuDisAmount.add(discount);
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }

    private Map<String, BigDecimal> calculateRedefine(ActSkuDiscountReqBO actSkuDiscountReqBO) {
        String redefineAttr = this.queryActiveAttr(actSkuDiscountReqBO, "sku_price_redefine");
        BigDecimal skuPrice = actSkuDiscountReqBO.getSkuDetailBO().getSkuPrice();
        BigDecimal disCountAmount = actSkuDiscountReqBO.getDisCountAmont();
        BigDecimal priceRedefine = new BigDecimal(redefineAttr);
        BigDecimal skuDisAmount = skuPrice.subtract(priceRedefine);
        BigDecimal skuDisPrice = skuPrice.subtract(skuDisAmount);
        if (disCountAmount != null) {
            skuDisAmount = skuDisAmount.add(disCountAmount);
        }
        HashMap<String, BigDecimal> disPriceMap = new HashMap<String, BigDecimal>(4);
        disPriceMap.put("skuDisPrice", skuDisPrice);
        disPriceMap.put("skuDisAmount", skuDisAmount);
        return disPriceMap;
    }
}

