/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCouponDiscountAbilityService;
import com.tydic.newretail.ability.bo.ActCouponDiscountAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCouponDiscountAbilityRspBO;
import com.tydic.newretail.busi.ActCouponDiscountBusiService;
import com.tydic.newretail.busi.bo.ActCouponDiscountBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponDiscountBusiRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCouponDiscountAbilityService")
public class ActCouponDiscountAbilityServiceImpl
implements ActCouponDiscountAbilityService {
    private ActCouponDiscountBusiService actCouponDiscountBusiService;

    @Autowired
    private ActCouponDiscountAbilityServiceImpl(ActCouponDiscountBusiService actCouponDiscountBusiService) {
        this.actCouponDiscountBusiService = actCouponDiscountBusiService;
    }

    public ActCouponDiscountAbilityRspBO couponDiscount(ActCouponDiscountAbilityReqBO reqBO) {
        this.validParam(reqBO);
        ActCouponDiscountAbilityRspBO rspBO = new ActCouponDiscountAbilityRspBO();
        ActCouponDiscountBusiReqBO busiReqBO = new ActCouponDiscountBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        ActCouponDiscountBusiRspBO busiRspBO = this.actCouponDiscountBusiService.couponDiscount(busiReqBO);
        BeanUtils.copyProperties((Object)busiRspBO, (Object)rspBO);
        return rspBO;
    }

    private void validParam(ActCouponDiscountAbilityReqBO reqBO) {
        String paramMsg = "\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u670d\u52a1\u5165\u53c2";
        if (null == reqBO) {
            throw new BusinessException("8000", paramMsg + "\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuDetailList())) {
            throw new BusinessException("8000", paramMsg + "\u5355\u54c1\u5217\u8868[skuDetailList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SkuDetailBO skuDetailBO : reqBO.getSkuDetailList()) {
            if (StringUtils.isBlank((CharSequence)skuDetailBO.getSkuId())) {
                throw new BusinessException("8000", paramMsg + "\u660e\u7ec6\u5217\u8868[skuDetailList]\u4e2d\u7684\u5546\u54c1ID[skuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailBO.getShopId()) {
                throw new BusinessException("8000", paramMsg + "\u660e\u7ec6\u5217\u8868[skuDetailList]\u4e2d\u7684\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == skuDetailBO.getSkuNum()) {
                throw new BusinessException("8000", paramMsg + "\u660e\u7ec6\u5217\u8868[skuDetailList]\u4e2d\u7684\u5546\u54c1\u6570\u91cf[skuNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != skuDetailBO.getSkuPrice()) continue;
            throw new BusinessException("8000", paramMsg + "\u660e\u7ec6\u5217\u8868[skuDetailList]\u4e2d\u7684\u5546\u54c1\u5355\u4ef7[skuPrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

