/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.ability.ActQueryShopActiveAbilityService;
import com.tydic.newretail.ability.bo.ActQueryShopActiveAbilityReqBO;
import com.tydic.newretail.ability.bo.ActQueryShopActiveAbilityRspBO;
import com.tydic.newretail.busi.ActQueryShopActiveBusiService;
import com.tydic.newretail.busi.bo.ActQueryShopActiveBusiReqBO;
import com.tydic.newretail.busi.bo.ActQueryShopActiveBusiRspBO;
import com.tydic.newretail.busi.dict.ActSelectDictByCodeAndPcodeBusiService;
import com.tydic.newretail.busi.dict.bo.ActSelectDictByCodeAndPcodeBusiReqBO;
import com.tydic.newretail.busi.dict.bo.ActSelectDictByCodeAndPcodeBusiRspBO;
import com.tydic.newretail.common.bo.ActivityBO;
import com.tydic.newretail.common.bo.ShopActiveInfoBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQueryShopActiveAbilityService")
public class ActQueryShopActiveAbilityServiceImpl
implements ActQueryShopActiveAbilityService {
    private static final String PARAM_MSG = "\u5e97\u94fa\u6d3b\u52a8\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2";
    private ActQueryShopActiveBusiService actQueryShopActiveBusiService;
    private ActSelectDictByCodeAndPcodeBusiService actSelectDictByCodeAndPcodeBusiService;
    private CacheClient cacheClient;

    @Autowired
    private ActQueryShopActiveAbilityServiceImpl(ActQueryShopActiveBusiService actQueryShopActiveBusiService, ActSelectDictByCodeAndPcodeBusiService actSelectDictByCodeAndPcodeBusiService, CacheClient cacheClient) {
        this.actQueryShopActiveBusiService = actQueryShopActiveBusiService;
        this.actSelectDictByCodeAndPcodeBusiService = actSelectDictByCodeAndPcodeBusiService;
        this.cacheClient = cacheClient;
    }

    public ActQueryShopActiveAbilityRspBO queryShopActive(ActQueryShopActiveAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActQueryShopActiveAbilityRspBO rspBO = new ActQueryShopActiveAbilityRspBO();
        String redisKey = "MSC_SHOP_" + reqBO.getShopId().toString();
        Object redisObj = this.cacheClient.get(redisKey);
        if (redisObj != null) {
            rspBO = (ActQueryShopActiveAbilityRspBO)redisObj;
        } else {
            this.queryShopActiveInfoFromDB(reqBO, rspBO);
            if (!CollectionUtils.isEmpty((Collection)rspBO.getShopActiveInfoList())) {
                this.cacheClient.set(redisKey, (Object)rspBO, 76400);
            }
        }
        return rspBO;
    }

    private void validateArg(ActQueryShopActiveAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u5e97\u94fa\u6d3b\u52a8\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShopId()) {
            throw new BusinessException("8000", "\u5e97\u94fa\u6d3b\u52a8\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5165\u53c2\u5e97\u94faID[shopId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void queryShopActiveInfoFromDB(ActQueryShopActiveAbilityReqBO reqBO, ActQueryShopActiveAbilityRspBO rspBO) {
        ActQueryShopActiveBusiReqBO busiReqBO = new ActQueryShopActiveBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        ActQueryShopActiveBusiRspBO busiRspBO = this.actQueryShopActiveBusiService.queryShopActive(busiReqBO);
        if (!CollectionUtils.isEmpty((Collection)busiRspBO.getShopActiveInfoList())) {
            rspBO.setShopActiveInfoList(busiRspBO.getShopActiveInfoList());
            for (ShopActiveInfoBO shopActiveInfoBO : rspBO.getShopActiveInfoList()) {
                this.translateActType(shopActiveInfoBO.getActivityBO());
            }
        }
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
    }

    private void translateActType(ActivityBO activityBO) {
        if (!StringUtils.isBlank((CharSequence)activityBO.getActiveType())) {
            ActSelectDictByCodeAndPcodeBusiReqBO reqBO = new ActSelectDictByCodeAndPcodeBusiReqBO();
            reqBO.setCode(activityBO.getActiveType());
            reqBO.setPCode("ACTIVE_TYPE");
            ActSelectDictByCodeAndPcodeBusiRspBO rspBO = this.actSelectDictByCodeAndPcodeBusiService.queryDictByCodeAndPcode(reqBO);
            if (null != rspBO && null != rspBO.getDictionaryInfo()) {
                activityBO.setActiveTypeStr(rspBO.getDictionaryInfo().getDescrip());
            }
        }
    }
}

