/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActDeleteRedisCacheAtomService;
import com.tydic.newretail.atom.bo.ActDeleteRedisCacheAtomReqBO;
import com.tydic.newretail.busi.ActActDeleteBusiService;
import com.tydic.newretail.busi.bo.ActActDeleteBusiReqBO;
import com.tydic.newretail.busi.bo.ActActDeleteBusiRspBO;
import com.tydic.newretail.common.bo.ChooseActivityBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActivityMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActivityPO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActDeleteBusiService")
public class ActActDeleteBusiServiceImpl
implements ActActDeleteBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActDeleteBusiServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private ActivityMapper activityMapper;
    private SkuActiveMapper skuActiveMapper;
    private ActDeleteRedisCacheAtomService actDeleteRedisCacheAtomService;

    @Autowired
    private ActActDeleteBusiServiceImpl(ActivityMapper activityMapper, SkuActiveMapper skuActiveMapper, ActDeleteRedisCacheAtomService actDeleteRedisCacheAtomService) {
        this.activityMapper = activityMapper;
        this.skuActiveMapper = skuActiveMapper;
        this.actDeleteRedisCacheAtomService = actDeleteRedisCacheAtomService;
    }

    public ActActDeleteBusiRspBO deleteActivity(ActActDeleteBusiReqBO reqBO) {
        ActActDeleteBusiRspBO rspBO = new ActActDeleteBusiRspBO();
        for (ChooseActivityBO chooseActivityBO : reqBO.getDeleteActivityInfoList()) {
            ActivityPO actPO = new ActivityPO();
            actPO.setActiveId(chooseActivityBO.getActiveId());
            actPO.setActiveCode(chooseActivityBO.getActiveCode());
            actPO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
            ActivityPO activityPO = this.activityMapper.getModelBy(actPO);
            if (null == activityPO) {
                if (IS_DEBUG_ENABLED) {
                    LOGGER.debug("Id[" + chooseActivityBO.getActiveId() + "],Code[" + chooseActivityBO.getActiveCode() + "]\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
                }
                throw new BusinessException("6021", "Id[" + chooseActivityBO.getActiveId() + "],Code[" + chooseActivityBO.getActiveCode() + "]\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            }
            chooseActivityBO.setActiveId(activityPO.getActiveId());
            if (!StringUtils.isBlank((CharSequence)chooseActivityBO.getSkuId()) && null != chooseActivityBO.getShopId()) {
                this.deleteSkuAct(chooseActivityBO);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)chooseActivityBO.getSkuId()) && null != chooseActivityBO.getShopId()) {
                this.deleteShopAct(chooseActivityBO);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)chooseActivityBO.getSkuId()) && null == chooseActivityBO.getShopId()) {
                this.deleteAllAct(chooseActivityBO.getActiveId());
                continue;
            }
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug(JSON.toJSONString((Object)chooseActivityBO) + "\u65e0\u6cd5\u5339\u914d\u5230\u9700\u8981\u5220\u9664\u7684\u6d3b\u52a8");
            }
            throw new BusinessException("6022", JSON.toJSONString((Object)chooseActivityBO) + "\u65e0\u6cd5\u5339\u914d\u5230\u9700\u8981\u5220\u9664\u7684\u6d3b\u52a8");
        }
        ActDeleteRedisCacheAtomReqBO deleteRedisCacheAtomReqBO = new ActDeleteRedisCacheAtomReqBO();
        ArrayList<String> redisKeys = new ArrayList<String>();
        deleteRedisCacheAtomReqBO.setRedisKeys(redisKeys);
        for (ChooseActivityBO chooseActivityBO : reqBO.getDeleteActivityInfoList()) {
            if (StringUtils.isNotBlank((CharSequence)chooseActivityBO.getSkuId())) {
                redisKeys.add("MSC_SKU_" + chooseActivityBO.getSkuId());
                continue;
            }
            if (null != chooseActivityBO.getShopId()) {
                redisKeys.add("MSC_SHOP_" + chooseActivityBO.getShopId().toString());
                continue;
            }
            redisKeys.add("MSC_INFO_" + chooseActivityBO.getActiveId().toString());
        }
        this.actDeleteRedisCacheAtomService.deleteRedisCache(deleteRedisCacheAtomReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u5220\u9664\u6210\u529f");
        return rspBO;
    }

    private void deleteSkuAct(ChooseActivityBO chooseActivityBO) {
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(chooseActivityBO.getActiveId());
        skuActivePO.setSkuId(chooseActivityBO.getSkuId());
        skuActivePO.setShopId(chooseActivityBO.getShopId());
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (updateSkuActResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u8303\u56f4\u8868\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteShopAct(ChooseActivityBO chooseActivityBO) {
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(chooseActivityBO.getActiveId());
        skuActivePO.setShopId(chooseActivityBO.getShopId());
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateShopActResult = this.skuActiveMapper.update4DeleteShopAct(skuActivePO);
        if (updateShopActResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u8303\u56f4\u8868\u66f4\u65b0\u5e97\u94fa\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }

    private void deleteAllAct(Long activeId) {
        ActivityPO activePO = new ActivityPO();
        activePO.setActiveId(activeId);
        activePO.setActiveStatus(ActCommConstant.ActivityState.DISABLED);
        activePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateActResult = this.activityMapper.updateById(activePO);
        if (updateActResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u8868\u66f4\u65b0\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(activeId);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        int checkSku = this.skuActiveMapper.getCheckBy(skuActivePO);
        skuActivePO.setStatus(ActCommConstant.ActivityState.DISABLED);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.DELETED);
        int updateSkuActResult = this.skuActiveMapper.updateByCondition(skuActivePO);
        if (checkSku > 0 && updateSkuActResult < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u6d3b\u52a8\u8303\u56f4\u8868\u66f4\u65b0\u5355\u54c1\u6d3b\u52a8\u72b6\u6001\u5931\u8d25");
            }
            throw new BusinessException("6023", "\u6d3b\u52a8\u5220\u9664\u5931\u8d25");
        }
    }
}

