/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.timetask.impl;

import com.tydic.newretail.busi.ActActStartStopBusiService;
import com.tydic.newretail.busi.ActSeckActStartStopBusiService;
import com.tydic.newretail.busi.bo.ActActStartStopBusiReqBO;
import com.tydic.newretail.busi.bo.ActActStartStopBusiRspBO;
import com.tydic.newretail.busi.bo.ActSeckActStartStopBusiReqBO;
import com.tydic.newretail.busi.bo.ActSeckActStartStopBusiRspBO;
import com.tydic.newretail.common.bo.ChooseActivityBO;
import com.tydic.newretail.dao.CommodityKillCycleMapper;
import com.tydic.newretail.dao.DicDictionaryMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.CommodityKillCyclePO;
import com.tydic.newretail.dao.po.DicDictionaryPO;
import com.tydic.newretail.dao.po.SkuActivePO;
import com.tydic.newretail.timetask.ActStartStopActTimeTaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actStartStopActTimeTaskService")
public class ActStartStopActTimeTaskServiceImpl
implements ActStartStopActTimeTaskService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActStartStopActTimeTaskServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean IS_INFO_ENABLED = LOGGER.isInfoEnabled();
    private static final Integer START = 0;
    private static final Integer STOP = 1;
    private DicDictionaryMapper dicDictionaryMapper;
    private SkuActiveMapper skuActiveMapper;
    private CommodityKillCycleMapper commodityKillCycleMapper;
    private ActSeckActStartStopBusiService actSeckActStartStopBusiService;
    private ActActStartStopBusiService actActStartStopBusiService;

    @Autowired
    private ActStartStopActTimeTaskServiceImpl(DicDictionaryMapper dicDictionaryMapper, SkuActiveMapper skuActiveMapper, CommodityKillCycleMapper commodityKillCycleMapper, ActSeckActStartStopBusiService actSeckActStartStopBusiService, ActActStartStopBusiService actActStartStopBusiService) {
        this.dicDictionaryMapper = dicDictionaryMapper;
        this.skuActiveMapper = skuActiveMapper;
        this.commodityKillCycleMapper = commodityKillCycleMapper;
        this.actSeckActStartStopBusiService = actSeckActStartStopBusiService;
        this.actActStartStopBusiService = actActStartStopBusiService;
    }

    public void execute(String currentShardValue) {
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u5f00\u59cb\u6267\u884c\u6d3b\u52a8\u542f\u505c\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + currentShardValue + "]==========");
        }
        DicDictionaryPO dicDictionaryPO = new DicDictionaryPO();
        dicDictionaryPO.setPCode("totalShardCount");
        dicDictionaryPO.setCode("totalShardCount");
        DicDictionaryPO dictionaryPO = this.dicDictionaryMapper.getModelBy(dicDictionaryPO);
        if (null == dictionaryPO) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            }
            return;
        }
        Date now = new Date();
        List<SkuActivePO> skuActivePOList = this.skuActiveMapper.getList4StartStopTimeTask(dictionaryPO.getTitle(), currentShardValue, now);
        this.startOrStopAct(skuActivePOList, now);
        List<CommodityKillCyclePO> killCyclePOList = this.commodityKillCycleMapper.getList4StartStopTimeTask(dictionaryPO.getTitle(), currentShardValue, now);
        this.startOrStopSeck(killCyclePOList, now);
        if (IS_INFO_ENABLED || IS_DEBUG_ENABLED) {
            LOGGER.info("==========\u6d3b\u52a8\u542f\u505c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + currentShardValue + "]==========");
        }
    }

    private void startOrStopAct(List<SkuActivePO> skuActivePOList, Date now) {
        ArrayList<ChooseActivityBO> startActivityBOList = new ArrayList<ChooseActivityBO>();
        ArrayList<ChooseActivityBO> stopActivityBOList = new ArrayList<ChooseActivityBO>();
        for (SkuActivePO skuActivePO : skuActivePOList) {
            ChooseActivityBO chooseActivityBO = new ChooseActivityBO();
            if (now.after(skuActivePO.getStartTime()) && now.before(skuActivePO.getEndTime())) {
                BeanUtils.copyProperties((Object)skuActivePO, (Object)chooseActivityBO);
                startActivityBOList.add(chooseActivityBO);
                continue;
            }
            if (now.after(skuActivePO.getEndTime())) {
                BeanUtils.copyProperties((Object)skuActivePO, (Object)chooseActivityBO);
                stopActivityBOList.add(chooseActivityBO);
                continue;
            }
            if (!now.before(skuActivePO.getStartTime())) continue;
            BeanUtils.copyProperties((Object)skuActivePO, (Object)chooseActivityBO);
            stopActivityBOList.add(chooseActivityBO);
        }
        ActActStartStopBusiReqBO startBusiReqBO = new ActActStartStopBusiReqBO();
        startBusiReqBO.setOperType(START);
        startBusiReqBO.setStartStopActivityInfoList(startActivityBOList);
        ActActStartStopBusiRspBO startBusiRspBO = this.actActStartStopBusiService.dealStartStop(startBusiReqBO);
        if (!"0000".equals(startBusiRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8\u542f\u505c\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u542f\u52a8\u6d3b\u52a8\u5931\u8d25\uff01" + startBusiRspBO.getRespDesc());
        }
        ActActStartStopBusiReqBO stopBusiReqBO = new ActActStartStopBusiReqBO();
        stopBusiReqBO.setOperType(STOP);
        stopBusiReqBO.setStartStopActivityInfoList(stopActivityBOList);
        ActActStartStopBusiRspBO stopBusiRspBO = this.actActStartStopBusiService.dealStartStop(stopBusiReqBO);
        if (!"0000".equals(stopBusiRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8\u542f\u505c\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u505c\u6b62\u6d3b\u52a8\u5931\u8d25\uff01" + stopBusiRspBO.getRespDesc());
        }
    }

    private void startOrStopSeck(List<CommodityKillCyclePO> killCyclePOList, Date now) {
        ArrayList<Long> startSeckBOList = new ArrayList<Long>();
        ArrayList<Long> stopSeckBOList = new ArrayList<Long>();
        for (CommodityKillCyclePO killCyclePO : killCyclePOList) {
            if (now.after(killCyclePO.getStartTime()) && now.before(killCyclePO.getEndTime())) {
                startSeckBOList.add(killCyclePO.getKillCycleId());
                continue;
            }
            if (now.after(killCyclePO.getEndTime())) {
                stopSeckBOList.add(killCyclePO.getKillCycleId());
                continue;
            }
            if (!now.before(killCyclePO.getStartTime())) continue;
            stopSeckBOList.add(killCyclePO.getKillCycleId());
        }
        ActSeckActStartStopBusiReqBO startBusiReqBO = new ActSeckActStartStopBusiReqBO();
        startBusiReqBO.setOperType(START);
        startBusiReqBO.setKillCycleIdList(startSeckBOList);
        ActSeckActStartStopBusiRspBO startBusiRspBO = this.actSeckActStartStopBusiService.dealSeckActStartStop(startBusiReqBO);
        if (!"0000".equals(startBusiRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8\u542f\u505c\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u542f\u52a8\u79d2\u6740\u6d3b\u52a8\u5931\u8d25\uff01" + startBusiRspBO.getRespDesc());
        }
        ActSeckActStartStopBusiReqBO stopBusiReqBO = new ActSeckActStartStopBusiReqBO();
        stopBusiReqBO.setOperType(STOP);
        stopBusiReqBO.setKillCycleIdList(stopSeckBOList);
        ActSeckActStartStopBusiRspBO stopBusiRspBO = this.actSeckActStartStopBusiService.dealSeckActStartStop(stopBusiReqBO);
        if (!"0000".equals(stopBusiRspBO.getRespCode())) {
            LOGGER.error("\u6d3b\u52a8\u542f\u505c\u5b9a\u65f6\u4efb\u52a1\u8c03\u7528\u79d2\u6740\u6d3b\u52a8\u542f\u505c\u4e1a\u52a1\u670d\u52a1\u505c\u6b62\u79d2\u6740\u6d3b\u52a8\u5931\u8d25\uff01" + stopBusiRspBO.getRespDesc());
        }
    }
}

