/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActActivityValidCheckAtomService;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomReqBO;
import com.tydic.newretail.atom.bo.ActActivityValidCheckAtomRspBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.ActiveStockMapper;
import com.tydic.newretail.dao.SkuActiveMapper;
import com.tydic.newretail.dao.po.ActiveStockPO;
import com.tydic.newretail.dao.po.SkuActivePO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActivityValidCheckAtomService")
public class ActActivityValidCheckAtomServiceImpl
implements ActActivityValidCheckAtomService {
    private SkuActiveMapper skuActiveMapper;
    private ActiveStockMapper activeStockMapper;

    @Autowired
    private ActActivityValidCheckAtomServiceImpl(SkuActiveMapper skuActiveMapper, ActiveStockMapper activeStockMapper) {
        this.skuActiveMapper = skuActiveMapper;
        this.activeStockMapper = activeStockMapper;
    }

    @Override
    public ActActivityValidCheckAtomRspBO checkActivityValid(ActActivityValidCheckAtomReqBO atomReqBO) {
        if (null == atomReqBO.getActiveId()) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ActiveId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == atomReqBO.getShopId()) {
            throw new BusinessException("8888", "\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6709\u6548\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010ShopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActActivityValidCheckAtomRspBO rsp = new ActActivityValidCheckAtomRspBO();
        SkuActivePO skuActivePO = new SkuActivePO();
        skuActivePO.setActiveId(atomReqBO.getActiveId());
        skuActivePO.setShopId(atomReqBO.getShopId());
        skuActivePO.setSkuId(atomReqBO.getSkuId());
        skuActivePO.setStatus(ActCommConstant.ActivityState.STATE_EFFECTIVE);
        skuActivePO.setIsDelete(ActCommConstant.ActivityIsDelete.NORMAL);
        List<SkuActivePO> skuActivePOList = this.skuActiveMapper.getListByCheck(skuActivePO);
        if (null == skuActivePOList || skuActivePOList.size() <= 0) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6d3b\u52a8\u4fe1\u606f");
            return rsp;
        }
        ActiveStockPO activeStockPO = new ActiveStockPO();
        activeStockPO.setActiveId(atomReqBO.getActiveId());
        activeStockPO = this.activeStockMapper.getModelBy(activeStockPO);
        if (activeStockPO != null && activeStockPO.getActCount() > 0 && activeStockPO.getActCount() <= activeStockPO.getSaleCount()) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u8be5\u6d3b\u52a8\u5e93\u5b58\u4e0d\u8db3");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6d3b\u52a8\u6709\u6548");
        return rsp;
    }
}

