/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActDeleteRedisCacheAtomService;
import com.tydic.newretail.atom.bo.ActDeleteRedisCacheAtomReqBO;
import com.tydic.newretail.busi.ActActNumUpdateBusiService;
import com.tydic.newretail.busi.bo.ActActNumUpdateBusiReqBO;
import com.tydic.newretail.busi.bo.ActActNumUpdateBusiRspBO;
import com.tydic.newretail.dao.ActiveStockMapper;
import com.tydic.newretail.dao.po.ActiveStockPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actActNumUpdateBusiService")
public class ActActNumUpdateBusiServiceImpl
implements ActActNumUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActNumUpdateBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private static final Integer ADD = 0;
    private static final Integer SUB = 1;
    private ActiveStockMapper activeStockMapper;
    private ActDeleteRedisCacheAtomService actDeleteRedisCacheAtomService;

    @Autowired
    private ActActNumUpdateBusiServiceImpl(ActiveStockMapper activeStockMapper, ActDeleteRedisCacheAtomService actDeleteRedisCacheAtomService) {
        this.activeStockMapper = activeStockMapper;
        this.actDeleteRedisCacheAtomService = actDeleteRedisCacheAtomService;
    }

    public ActActNumUpdateBusiRspBO updateActNum(ActActNumUpdateBusiReqBO reqBO) {
        int num;
        ActActNumUpdateBusiRspBO rspBO = new ActActNumUpdateBusiRspBO();
        ActiveStockPO activeStockPO = new ActiveStockPO();
        activeStockPO.setActiveId(reqBO.getActiveId());
        ActiveStockPO stockPO = this.activeStockMapper.getModelBy(activeStockPO);
        if (null == stockPO) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6d3b\u52a8\u6570\u91cf\u65e0\u914d\u7f6e\uff0c\u65e0\u9700\u66f4\u65b0");
            return rspBO;
        }
        if (ADD.equals(reqBO.getOperType())) {
            num = stockPO.getSaleCount() + reqBO.getOperNum();
            if (num > stockPO.getActCount()) {
                rspBO.setRespCode("2004");
                rspBO.setRespDesc("\u53ef\u64cd\u4f5c\u4f59\u91cf\u4e0d\u8db3");
                return rspBO;
            }
            stockPO.setSaleCount(num);
            stockPO.setActCount(null);
            int update = this.activeStockMapper.updateById(stockPO);
            if (update < 1) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6024", "\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u670d\u52a1\u6267\u884c\u66f4\u65b0\u5931\u8d25");
            }
        } else if (SUB.equals(reqBO.getOperType())) {
            num = stockPO.getSaleCount() - reqBO.getOperNum();
            if (num < 0) {
                rspBO.setRespCode("2004");
                rspBO.setRespDesc("\u53ef\u64cd\u4f5c\u4f59\u91cf\u4e0d\u8db3");
                return rspBO;
            }
            stockPO.setSaleCount(num);
            stockPO.setActCount(null);
            int update = this.activeStockMapper.updateById(stockPO);
            if (update < 1) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u4e1a\u52a1\u670d\u52a1\uff0c\u6570\u636e\u5e93\u66f4\u65b0\u5931\u8d25\uff0cupdate\u8fd4\u56de\u503c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6024", "\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u670d\u52a1\u6267\u884c\u66f4\u65b0\u5931\u8d25");
            }
        } else {
            rspBO.setRespCode("2004");
            rspBO.setRespDesc("\u6ca1\u6709\u5bf9\u5e94\u7684\u64cd\u4f5c\u7c7b\u578b");
            return rspBO;
        }
        ActDeleteRedisCacheAtomReqBO deleteRedisCacheAtomReqBO = new ActDeleteRedisCacheAtomReqBO();
        deleteRedisCacheAtomReqBO.setRedisKeys(Lists.newArrayList((Object[])new String[]{"MSC_DETAIL_" + reqBO.getActiveId().toString()}));
        this.actDeleteRedisCacheAtomService.deleteRedisCache(deleteRedisCacheAtomReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d3b\u52a8\u4e2d\u5fc3\u6d3b\u52a8\u6570\u91cf\u66f4\u65b0\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }
}

