/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.newretail.atom.ActQueryActiveInfoAtomService;
import com.tydic.newretail.atom.bo.ActQueryActiveInfoAtomReqBO;
import com.tydic.newretail.atom.bo.ActQueryActiveInfoAtomRspBO;
import com.tydic.newretail.busi.ActQryGroupActivityBusiService;
import com.tydic.newretail.busi.bo.ActQryGroupActivityBusiReqBO;
import com.tydic.newretail.busi.bo.ActQryGroupActivityBusiRspBO;
import com.tydic.newretail.common.bo.ActQryGroupActivityBO;
import com.tydic.newretail.common.bo.AllActiveInfoBO;
import com.tydic.newretail.dao.SpecialSqlMapper;
import com.tydic.newretail.dao.po.ShopActivePO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actQryGroupActivityCombService")
public class ActQryGroupActivityBusiServiceImpl
implements ActQryGroupActivityBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActQryGroupActivityBusiServiceImpl.class);
    private SpecialSqlMapper specialSqlMapper;
    private ActQueryActiveInfoAtomService actQueryActiveInfoAtomService;

    @Autowired
    private ActQryGroupActivityBusiServiceImpl(SpecialSqlMapper specialSqlMapper, ActQueryActiveInfoAtomService actQueryActiveInfoAtomService) {
        this.specialSqlMapper = specialSqlMapper;
        this.actQueryActiveInfoAtomService = actQueryActiveInfoAtomService;
    }

    public ActQryGroupActivityBusiRspBO qryGroupActivity(ActQryGroupActivityBusiReqBO reqBO) {
        ActQryGroupActivityBusiRspBO rspBO = new ActQryGroupActivityBusiRspBO();
        ArrayList<ActQryGroupActivityBO> shopActiveInfoList = new ArrayList<ActQryGroupActivityBO>();
        rspBO.setActiveInfoList(shopActiveInfoList);
        rspBO.setRespCode("0000");
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setLimit(reqBO.getPageSize().intValue());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        ShopActivePO shopActivePO = new ShopActivePO();
        List<ActQryGroupActivityBO> shopList = this.specialSqlMapper.qryValidShopGroupByPage(shopActivePO, (Page<Map<String, Object>>)page);
        rspBO.setTotalRecords(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotalPages(Integer.valueOf(page.getTotalPages()));
        if (CollectionUtils.isEmpty(shopList)) {
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6709\u6548\u6d3b\u52a8\u4fe1\u606f");
            return rspBO;
        }
        for (ActQryGroupActivityBO shop : shopList) {
            ActQryGroupActivityBO groupActivityBO = new ActQryGroupActivityBO();
            ArrayList<AllActiveInfoBO> activeInfoList = new ArrayList<AllActiveInfoBO>();
            groupActivityBO.setShopId(shop.getShopId());
            groupActivityBO.setShopName(shop.getShopName());
            groupActivityBO.setActiveInfoList(activeInfoList);
            shopActiveInfoList.add(groupActivityBO);
            List<AllActiveInfoBO> allActiveList = this.specialSqlMapper.qryActivityInfo(shop);
            if (CollectionUtils.isEmpty(allActiveList)) {
                LOGGER.error("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u4fe1\u606f[shopId=" + shop.getShopId() + "]");
                continue;
            }
            Integer noQueryDetail = 1;
            for (AllActiveInfoBO activeInfoBO : allActiveList) {
                if (!noQueryDetail.equals(reqBO.getIsQueryDetail())) {
                    ActQueryActiveInfoAtomReqBO qryActiveInfoReqBO = new ActQueryActiveInfoAtomReqBO();
                    qryActiveInfoReqBO.setActiveId(activeInfoBO.getActiveId());
                    ActQueryActiveInfoAtomRspBO qryActiveInfoRspBO = this.actQueryActiveInfoAtomService.queryActiveInfo(qryActiveInfoReqBO);
                    if (!"0000".equals(qryActiveInfoRspBO.getRespCode())) {
                        LOGGER.error("\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u6d3b\u52a8\u8be6\u7ec6\u4fe1\u606f[activeId=" + activeInfoBO.getActiveId() + "]");
                    }
                    activeInfoBO.setActiveAttributeList(qryActiveInfoRspBO.getActiveAttributeList());
                    activeInfoBO.setActiveExclusionRuleList(qryActiveInfoRspBO.getActiveExclusionRuleList());
                    activeInfoBO.setActiveGiftList(qryActiveInfoRspBO.getActiveGiftList());
                    activeInfoBO.setActiveGiftPkgList(qryActiveInfoRspBO.getActiveGiftPkgList());
                }
                activeInfoList.add(activeInfoBO);
            }
        }
        rspBO.setRespDesc("\u6d3b\u52a8\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }
}

