/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.ability.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.ability.ActCreateCouponAppAbilityService;
import com.tydic.newretail.ability.bo.ActCreateCouponAppAbilityReqBO;
import com.tydic.newretail.ability.bo.ActCreateCouponAppAbilityRspBO;
import com.tydic.newretail.busi.ActCreateCouponAppBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponAppBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponAppBusiRspBO;
import com.tydic.newretail.common.bo.CouponTaskBO;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponAppAbilityService")
public class ActCreateCouponAppAbilityServiceImpl
implements ActCreateCouponAppAbilityService {
    private ActCreateCouponAppBusiService actCreateCouponAppBusiService;

    @Autowired
    private ActCreateCouponAppAbilityServiceImpl(ActCreateCouponAppBusiService actCreateCouponAppBusiService) {
        this.actCreateCouponAppBusiService = actCreateCouponAppBusiService;
    }

    public ActCreateCouponAppAbilityRspBO createCouponApp(ActCreateCouponAppAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        ActCreateCouponAppAbilityRspBO rspBO = new ActCreateCouponAppAbilityRspBO();
        ActCreateCouponAppBusiReqBO busiReqBO = new ActCreateCouponAppBusiReqBO();
        busiReqBO.setCouponTaskList(reqBO.getCouponTaskList());
        ActCreateCouponAppBusiRspBO busiRspBO = this.actCreateCouponAppBusiService.createCouponApp(busiReqBO);
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private void validateArg(ActCreateCouponAppAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u5bf9\u8c61[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCouponTaskList())) {
            throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponTaskList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (CouponTaskBO couponTaskBO : reqBO.getCouponTaskList()) {
            if (null == couponTaskBO.getFmId()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponTaskList]\u4e2d\u7684\u89c4\u683cID[fmId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponTaskBO.getCouponType()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponTaskList]\u4e2d\u7684\u4f18\u60e0\u5238\u7c7b\u578b[couponType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == couponTaskBO.getPatchNum()) {
                throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponTaskList]\u4e2d\u7684\u521b\u5efa\u6570\u91cf[patchNum]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isBlank((CharSequence)couponTaskBO.getEffTime())) continue;
            throw new BusinessException("8000", "\u4efb\u52a1\u4fe1\u606f\u5217\u8868[couponTaskList]\u4e2d\u7684\u751f\u6548\u65f6\u95f4[effTime]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

