/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.atom.ActOrderActivityCountAtomService;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomReqBO;
import com.tydic.newretail.atom.bo.ActOrderActivityCountAtomRspBO;
import com.tydic.newretail.busi.ActActivityCountBusiService;
import com.tydic.newretail.busi.ActCouponDiscountBusiService;
import com.tydic.newretail.busi.bo.ActActivityCountBusiReqBO;
import com.tydic.newretail.busi.bo.ActActivityCountBusiRspBO;
import com.tydic.newretail.busi.bo.ActCouponDiscountBusiReqBO;
import com.tydic.newretail.busi.bo.ActCouponDiscountBusiRspBO;
import com.tydic.newretail.comb.ActActivityCountCombService;
import com.tydic.newretail.comb.bo.ActActivityCountCombReqBO;
import com.tydic.newretail.comb.bo.ActActivityCountCombRspBO;
import com.tydic.newretail.comb.bo.ActivityCountCombBO;
import com.tydic.newretail.common.bo.ActivityChoiceBO;
import com.tydic.newretail.common.bo.CouponCountDetailRspBO;
import com.tydic.newretail.common.bo.SkuCountDetailRspBO;
import com.tydic.newretail.common.bo.SkuDetailBO;
import com.tydic.newretail.common.bo.SkuDetailReqBO;
import com.tydic.umc.ability.UmcIntegralDedAbilityService;
import com.tydic.umc.ability.bo.UmcIntegralDedAbilityReqBO;
import com.tydic.umc.ability.bo.UmcIntegralDedAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actActivityCountCombService")
public class ActActivityCountCombServiceImpl
implements ActActivityCountCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActActivityCountCombServiceImpl.class);
    private ActActivityCountBusiService actActivityCountBusiService;
    private ActOrderActivityCountAtomService actOrderActivityCountAtomService;
    private ActCouponDiscountBusiService actCouponDiscountBusiService;
    private UmcIntegralDedAbilityService umcIntegralDedAbilityService;

    @Autowired
    private ActActivityCountCombServiceImpl(ActActivityCountBusiService actActivityCountBusiService, ActOrderActivityCountAtomService actOrderActivityCountAtomService, ActCouponDiscountBusiService actCouponDiscountBusiService, UmcIntegralDedAbilityService umcIntegralDedAbilityService) {
        this.actActivityCountBusiService = actActivityCountBusiService;
        this.actOrderActivityCountAtomService = actOrderActivityCountAtomService;
        this.actCouponDiscountBusiService = actCouponDiscountBusiService;
        this.umcIntegralDedAbilityService = umcIntegralDedAbilityService;
    }

    public ActActivityCountCombRspBO activityCount(ActActivityCountCombReqBO reqBO) {
        ActActivityCountCombRspBO rspBO = new ActActivityCountCombRspBO();
        rspBO.setDisTotalAmo(BigDecimal.ZERO);
        rspBO.setActivityDisAmo(BigDecimal.ZERO);
        rspBO.setTotalAmount(BigDecimal.ZERO);
        rspBO.setSkuDetailList((List)Lists.newArrayList());
        rspBO.setOrderGiftList((List)Lists.newArrayList());
        rspBO.setOrderGiftPkgList((List)Lists.newArrayList());
        List<SkuDetailBO> allCountSkuList = this.combActivityCount(reqBO.getActivityCountCombList(), rspBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderActivityList()) && !CollectionUtils.isEmpty(allCountSkuList)) {
            this.orderActivityCount(allCountSkuList, reqBO.getOrderActivityList(), reqBO.getFreightAmount(), rspBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCouponCodes()) && !CollectionUtils.isEmpty(allCountSkuList)) {
            this.couponCount(allCountSkuList, reqBO.getCouponCodes(), rspBO.getFreightAmount(), rspBO);
        }
        if (reqBO.getMemId() != null && reqBO.getUsedIntegral() != null && !CollectionUtils.isEmpty(allCountSkuList)) {
            this.integralCount(allCountSkuList, rspBO.getTotalAmount(), reqBO.getUsedIntegral(), reqBO.getMemId(), rspBO);
        }
        rspBO.setFinalTotalAmount(rspBO.getTotalAmount().add(rspBO.getFreightAmount()).setScale(2, 5));
        rspBO.setRespTime(new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7ec4\u5408\u6d3b\u52a8\u8ba1\u7b97\u6210\u529f");
        return rspBO;
    }

    private List<SkuDetailBO> combActivityCount(List<ActivityCountCombBO> activityCountCombList, ActActivityCountCombRspBO rspBO) {
        ArrayList<SkuDetailBO> allCountSkuList = new ArrayList<SkuDetailBO>();
        for (ActivityCountCombBO activityCountCombBO : activityCountCombList) {
            ActActivityCountBusiReqBO combActCountReqBO = new ActActivityCountBusiReqBO();
            combActCountReqBO.setSkuDetailList(activityCountCombBO.getSkuDetailList());
            combActCountReqBO.setOrderActivityList(activityCountCombBO.getActivityCombList());
            ActActivityCountBusiRspBO combActCountRspBO = this.actActivityCountBusiService.countActivity(combActCountReqBO);
            if (!"0000".equals(combActCountRspBO.getRespCode())) {
                throw new BusinessException(combActCountRspBO.getRespCode(), combActCountRspBO.getRespDesc());
            }
            rspBO.setDisTotalAmo(rspBO.getDisTotalAmo().add(combActCountRspBO.getDisTotalAmo()));
            rspBO.setTotalAmount(rspBO.getTotalAmount().add(combActCountRspBO.getTotalAmount()));
            rspBO.setActivityDisAmo(rspBO.getActivityDisAmo().add(combActCountRspBO.getActivityDisAmo()));
            rspBO.getSkuDetailList().addAll(combActCountRspBO.getSkuDetailList());
            rspBO.getOrderGiftList().addAll(combActCountRspBO.getOrderGiftList());
            rspBO.getOrderGiftPkgList().addAll(combActCountRspBO.getOrderGiftPkgList());
            if (!"0".equals(combActCountRspBO.getSeckillFlag())) continue;
            HashMap<String, ArrayList> skuDetailMap = new HashMap<String, ArrayList>(16);
            for (SkuDetailReqBO skuDetailReqBO : activityCountCombBO.getSkuDetailList()) {
                SkuDetailBO skuDetailBO = new SkuDetailBO();
                BeanUtils.copyProperties((Object)skuDetailReqBO, (Object)skuDetailBO);
                skuDetailBO.setSkuNum(BigDecimal.ONE);
                if (skuDetailMap.containsKey(skuDetailBO.getSkuId())) {
                    ((List)skuDetailMap.get(skuDetailBO.getSkuId())).add(skuDetailBO);
                    continue;
                }
                skuDetailMap.put(skuDetailBO.getSkuId(), Lists.newArrayList((Object[])new SkuDetailBO[]{skuDetailBO}));
            }
            for (SkuCountDetailRspBO countDetailRspBO : combActCountRspBO.getSkuDetailList()) {
                List skuDetailList = (List)skuDetailMap.get(countDetailRspBO.getSkuId());
                ((SkuDetailBO)skuDetailList.get(0)).setSkuPrice(countDetailRspBO.getSkuTotalPrice());
                if (countDetailRspBO.getSkuTotalPrice().compareTo(BigDecimal.ZERO) > 0) {
                    allCountSkuList.add((SkuDetailBO)skuDetailList.get(0));
                }
                if (skuDetailList.size() <= 1) continue;
                skuDetailList.remove(0);
            }
        }
        return allCountSkuList;
    }

    private void orderActivityCount(List<SkuDetailBO> allCountSkuList, List<ActivityChoiceBO> activityList, BigDecimal freightAmount, ActActivityCountCombRspBO rspBO) {
        ActOrderActivityCountAtomReqBO orderActCountReqBO = new ActOrderActivityCountAtomReqBO();
        orderActCountReqBO.setSkuDetailList(allCountSkuList);
        orderActCountReqBO.setActivityAtomList(activityList);
        orderActCountReqBO.setFreightAmount(freightAmount);
        ActOrderActivityCountAtomRspBO orderActCountRspBO = this.actOrderActivityCountAtomService.orderActivityCount(orderActCountReqBO);
        if (!"0000".equals(orderActCountRspBO.getRespCode())) {
            throw new BusinessException(orderActCountRspBO.getRespCode(), orderActCountRspBO.getRespDesc());
        }
        rspBO.setDisTotalAmo(rspBO.getDisTotalAmo().add(orderActCountRspBO.getDisTotalAmo()));
        rspBO.setActivityDisAmo(rspBO.getActivityDisAmo().add(orderActCountRspBO.getDisTotalAmo()));
        rspBO.setTotalAmount(rspBO.getTotalAmount().subtract(orderActCountRspBO.getDisTotalAmo()));
        rspBO.setDisFreightAmo(orderActCountRspBO.getDisFreightAmo());
        rspBO.setFreightAmount(orderActCountRspBO.getFreightAmount());
        rspBO.getOrderGiftList().addAll(orderActCountRspBO.getOrderGiftList());
        rspBO.getOrderGiftPkgList().addAll(orderActCountRspBO.getOrderGiftPkgList());
        if (orderActCountRspBO.getDisTotalAmo().compareTo(BigDecimal.ZERO) > 0) {
            Map<String, List<SkuDetailBO>> skuDetailMap = this.returnSkuRateMap(allCountSkuList);
            int skuCount = allCountSkuList.size();
            int shareTime = 0;
            BigDecimal shareDiscount = BigDecimal.ZERO;
            for (SkuCountDetailRspBO detailRspBO : rspBO.getSkuDetailList()) {
                BigDecimal shareCount;
                List<SkuDetailBO> disSkuList = skuDetailMap.get(detailRspBO.getSkuId());
                if (CollectionUtils.isEmpty(disSkuList)) continue;
                SkuDetailBO disSkuDetail = disSkuList.get(0);
                if (++shareTime == skuCount) {
                    shareCount = orderActCountRspBO.getDisTotalAmo().subtract(shareDiscount);
                } else {
                    shareCount = orderActCountRspBO.getDisTotalAmo().multiply(disSkuDetail.getSkuNum()).setScale(0, 5);
                    shareDiscount = shareDiscount.add(shareCount);
                }
                detailRspBO.setSkuTotalAmount(detailRspBO.getSkuTotalAmount().add(shareCount));
                BigDecimal skuDisPrice = detailRspBO.getSkuTotalPrice().subtract(shareCount);
                if (skuDisPrice.compareTo(BigDecimal.ZERO) > 0) {
                    detailRspBO.setSkuTotalPrice(skuDisPrice.setScale(2, 5));
                    disSkuDetail.setSkuPrice(detailRspBO.getSkuTotalPrice());
                    disSkuDetail.setSkuNum(BigDecimal.ONE);
                } else {
                    detailRspBO.setSkuTotalPrice(BigDecimal.ZERO);
                    allCountSkuList.remove(disSkuDetail);
                }
                if (disSkuList.size() > 1) {
                    disSkuList.remove(0);
                }
                if (shareTime != skuCount) continue;
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("-----\u8ba2\u5355\u6d3b\u52a8\u4f18\u60e0\u8ba1\u7b97\u5b8c\u6210------");
                break;
            }
        }
    }

    private void couponCount(List<SkuDetailBO> allCountSkuList, List<String> couponCodes, BigDecimal freightAmount, ActActivityCountCombRspBO rspBO) {
        ActCouponDiscountBusiReqBO couponCountReqBO = new ActCouponDiscountBusiReqBO();
        couponCountReqBO.setCouponCodes(couponCodes);
        couponCountReqBO.setFreightAmount(freightAmount);
        couponCountReqBO.setSkuDetailList(allCountSkuList);
        ActCouponDiscountBusiRspBO couponCountRspBO = this.actCouponDiscountBusiService.couponDiscount(couponCountReqBO);
        if (!"0000".equals(couponCountRspBO.getRespCode())) {
            throw new BusinessException(couponCountRspBO.getRespCode(), couponCountRspBO.getRespDesc());
        }
        if (couponCountRspBO.getDisFreightAmo().compareTo(BigDecimal.ZERO) > 0) {
            rspBO.setDisFreightAmo(rspBO.getDisFreightAmo().add(couponCountRspBO.getDisFreightAmo()));
            rspBO.setFreightAmount(couponCountRspBO.getFreightAmount());
        }
        if (couponCountRspBO.getDisTotalAmo().compareTo(BigDecimal.ZERO) > 0) {
            rspBO.setDisTotalAmo(rspBO.getDisTotalAmo().add(couponCountRspBO.getDisTotalAmo()));
            rspBO.setTotalAmount(rspBO.getTotalAmount().subtract(couponCountRspBO.getDisTotalAmo()));
            HashMap couponCountMap = Maps.newHashMapWithExpectedSize((int)couponCountRspBO.getSkuDetailList().size());
            for (CouponCountDetailRspBO couponDetailRspBO : couponCountRspBO.getSkuDetailList()) {
                if (couponDetailRspBO.getSkuTotalAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (couponCountMap.get(couponDetailRspBO.getSkuId()) != null) {
                    ((List)couponCountMap.get(couponDetailRspBO.getSkuId())).add(couponDetailRspBO);
                    continue;
                }
                couponCountMap.put(couponDetailRspBO.getSkuId(), Lists.newArrayList((Object[])new CouponCountDetailRspBO[]{couponDetailRspBO}));
            }
            int skuCount = couponCountRspBO.getSkuDetailList().size();
            int shareTime = 0;
            for (SkuCountDetailRspBO detailRspBO : rspBO.getSkuDetailList()) {
                List countDetails = (List)couponCountMap.get(detailRspBO.getSkuId());
                if (CollectionUtils.isEmpty((Collection)countDetails)) continue;
                ++shareTime;
                CouponCountDetailRspBO couponDetailRspBO = (CouponCountDetailRspBO)countDetails.get(0);
                detailRspBO.setSkuTotalAmount(detailRspBO.getSkuTotalAmount().add(couponDetailRspBO.getSkuTotalAmount()));
                detailRspBO.setSkuTotalPrice(couponDetailRspBO.getSkuTotalPrice());
                if (couponDetailRspBO.getSkuTotalPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    int size = allCountSkuList.size();
                    for (int i = 0; i < size; ++i) {
                        if (!allCountSkuList.get(i).getSkuId().equals(couponDetailRspBO.getSkuId()) || !allCountSkuList.get(i).getShopId().equals(couponDetailRspBO.getShopId())) continue;
                        allCountSkuList.remove(i);
                        break;
                    }
                }
                if (countDetails.size() > 1) {
                    countDetails.remove(0);
                }
                if (shareTime != skuCount) continue;
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("-----\u4f18\u60e0\u5238\u62b5\u6263\u8ba1\u7b97\u5b8c\u6210------");
                break;
            }
        }
    }

    private void integralCount(List<SkuDetailBO> allCountSkuList, BigDecimal totalPrice, Long usedIntegral, Long memId, ActActivityCountCombRspBO rspBO) {
        UmcIntegralDedAbilityReqBO integralDedReqBO = new UmcIntegralDedAbilityReqBO();
        integralDedReqBO.setTotalMoney(totalPrice);
        integralDedReqBO.setUsedIntegral(usedIntegral);
        integralDedReqBO.setMemId(memId);
        UmcIntegralDedAbilityRspBO integralDedRspBO = this.umcIntegralDedAbilityService.integralDed(integralDedReqBO);
        if (!"0000".equals(integralDedRspBO.getRespCode())) {
            throw new BusinessException(integralDedRspBO.getRespCode(), integralDedRspBO.getRespDesc());
        }
        rspBO.setDisTotalAmo(rspBO.getDisTotalAmo().add(integralDedRspBO.getDeductionMoney()));
        rspBO.setTotalAmount(rspBO.getTotalAmount().subtract(integralDedRspBO.getDeductionMoney()));
        Map<String, List<SkuDetailBO>> skuDetailMap = this.returnSkuRateMap(allCountSkuList);
        int skuCount = allCountSkuList.size();
        int shareTime = 0;
        BigDecimal shareDiscount = BigDecimal.ZERO;
        BigDecimal shareIntegral = BigDecimal.ZERO;
        for (SkuCountDetailRspBO detailRspBO : rspBO.getSkuDetailList()) {
            BigDecimal shareInt;
            BigDecimal shareCount;
            List<SkuDetailBO> disSkuList = skuDetailMap.get(detailRspBO.getSkuId());
            if (CollectionUtils.isEmpty(disSkuList)) continue;
            SkuDetailBO skuDetailBO = disSkuList.get(0);
            if (++shareTime == skuCount) {
                shareCount = integralDedRspBO.getDeductionMoney().subtract(shareDiscount);
                shareInt = BigDecimal.valueOf(integralDedRspBO.getUsedIntegral()).subtract(shareIntegral);
            } else {
                shareCount = integralDedRspBO.getDeductionMoney().multiply(skuDetailBO.getSkuNum()).setScale(0, 5);
                shareInt = BigDecimal.valueOf(integralDedRspBO.getUsedIntegral()).multiply(skuDetailBO.getSkuNum()).setScale(0, 5);
                shareDiscount = shareDiscount.add(shareCount);
                shareIntegral = shareIntegral.add(shareInt);
            }
            detailRspBO.setSkuTotalAmount(detailRspBO.getSkuTotalAmount().add(shareCount));
            detailRspBO.setSkuTotalIntegral(Long.valueOf(shareInt.longValue()));
            BigDecimal skuDisPrice = detailRspBO.getSkuTotalPrice().subtract(shareCount);
            if (skuDisPrice.compareTo(BigDecimal.ZERO) > 0) {
                detailRspBO.setSkuTotalPrice(skuDisPrice.setScale(2, 5));
            } else {
                detailRspBO.setSkuTotalPrice(BigDecimal.ZERO);
            }
            if (disSkuList.size() > 1) {
                disSkuList.remove(0);
            }
            if (shareTime != skuCount) continue;
            if (!LOGGER.isDebugEnabled()) break;
            LOGGER.debug("-----\u79ef\u5206\u62b5\u6263\u8ba1\u7b97\u5b8c\u6210------");
            break;
        }
    }

    private Map<String, List<SkuDetailBO>> returnSkuRateMap(List<SkuDetailBO> allCountSkuList) {
        BigDecimal totalPrice = allCountSkuList.stream().map(SkuDetailBO::getSkuPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap skuDetailMap = Maps.newHashMapWithExpectedSize((int)allCountSkuList.size());
        for (SkuDetailBO disSkuDetail : allCountSkuList) {
            BigDecimal skuRate = disSkuDetail.getSkuPrice().divide(totalPrice, 2, 5);
            disSkuDetail.setSkuNum(skuRate);
            if (skuDetailMap.containsKey(disSkuDetail.getSkuId())) {
                ((List)skuDetailMap.get(disSkuDetail.getSkuId())).add(disSkuDetail);
                continue;
            }
            skuDetailMap.put(disSkuDetail.getSkuId(), Lists.newArrayList((Object[])new SkuDetailBO[]{disSkuDetail}));
        }
        return skuDetailMap;
    }
}

