/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.newretail.busi.ActCreateCouponFormBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponFormBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponFormBusiRspBO;
import com.tydic.newretail.common.bo.CouponAmoInfoBO;
import com.tydic.newretail.common.bo.CouponRangeInfoBO;
import com.tydic.newretail.common.bo.CreateCouponFormInfoBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponAmountMapper;
import com.tydic.newretail.dao.CouponAttrMapper;
import com.tydic.newretail.dao.CouponFormMapper;
import com.tydic.newretail.dao.CouponModMapper;
import com.tydic.newretail.dao.CouponRangeMapper;
import com.tydic.newretail.dao.ParamMapper;
import com.tydic.newretail.dao.TemplateMapper;
import com.tydic.newretail.dao.po.CouponAmountPO;
import com.tydic.newretail.dao.po.CouponAttrPO;
import com.tydic.newretail.dao.po.CouponFormPO;
import com.tydic.newretail.dao.po.CouponModPO;
import com.tydic.newretail.dao.po.CouponRangePO;
import com.tydic.newretail.dao.po.ParamPO;
import com.tydic.newretail.dao.po.TemplatePO;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actCreateCouponFormBusiService")
public class ActCreateCouponFormBusiServiceImpl
implements ActCreateCouponFormBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponFormBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private CouponFormMapper couponFormMapper;
    private CouponAmountMapper couponAmountMapper;
    private CouponRangeMapper couponRangeMapper;
    private CouponModMapper couponModMapper;
    private CouponAttrMapper couponAttrMapper;
    private ParamMapper paramMapper;
    private TemplateMapper templateMapper;

    @Autowired
    private ActCreateCouponFormBusiServiceImpl(CouponFormMapper couponFormMapper, CouponAmountMapper couponAmountMapper, CouponRangeMapper couponRangeMapper, CouponModMapper couponModMapper, CouponAttrMapper couponAttrMapper, ParamMapper paramMapper, TemplateMapper templateMapper) {
        this.couponFormMapper = couponFormMapper;
        this.couponAmountMapper = couponAmountMapper;
        this.couponRangeMapper = couponRangeMapper;
        this.couponModMapper = couponModMapper;
        this.couponAttrMapper = couponAttrMapper;
        this.paramMapper = paramMapper;
        this.templateMapper = templateMapper;
    }

    public ActCreateCouponFormBusiRspBO createCouponForm(ActCreateCouponFormBusiReqBO reqBO) {
        ActCreateCouponFormBusiRspBO rspBO = new ActCreateCouponFormBusiRspBO();
        for (CreateCouponFormInfoBO couponFormInfoBO : reqBO.getCouponFormInfoList()) {
            CouponFormPO couponFormPO = new CouponFormPO();
            BeanUtils.copyProperties((Object)couponFormInfoBO, (Object)couponFormPO);
            if (StringUtils.isBlank((CharSequence)couponFormInfoBO.getCreateTime())) {
                couponFormPO.setCreateTime(new Date());
            } else {
                couponFormPO.setCreateTime(DateUtils.strToDateLong((String)couponFormInfoBO.getCreateTime()));
            }
            int formInsertResult = this.couponFormMapper.insert(couponFormPO);
            if (formInsertResult < 1) {
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u89c4\u683c\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u89c4\u683c\u8868\u5931\u8d25");
            }
            this.createCouponRange(couponFormInfoBO.getCouponRangeList(), couponFormPO.getFmId());
            this.createCouponAmount(couponFormInfoBO.getCouponAmountList(), couponFormPO.getFmId());
            if (ActCommConstant.CouponTypeCode.FULL_SUBTRACTION.equals(couponFormInfoBO.getCouponType())) {
                this.insertFullSub(couponFormInfoBO, couponFormPO.getFmId());
                continue;
            }
            if (ActCommConstant.CouponTypeCode.FULL_DISCOUNT.equals(couponFormInfoBO.getCouponType())) {
                this.insertFullDiscout(couponFormInfoBO, couponFormPO.getFmId());
                continue;
            }
            if (ActCommConstant.CouponTypeCode.FREIGHT_SPECIFIED_AMOUNT.equals(couponFormInfoBO.getCouponType())) {
                this.insertFreightSpecAmo(couponFormInfoBO, couponFormPO.getFmId());
                continue;
            }
            if (ActCommConstant.CouponTypeCode.DEDUCTION.equals(couponFormInfoBO.getCouponType())) {
                this.insertDeduction(couponFormInfoBO, couponFormPO.getFmId());
                continue;
            }
            if (!ActCommConstant.CouponTypeCode.FREIGHT_FREE_ALL.equals(couponFormInfoBO.getCouponType())) continue;
            this.insertFreightAll(couponFormPO.getFmId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u5b8c\u6210");
        return rspBO;
    }

    private void createCouponRange(List<CouponRangeInfoBO> couponRangeList, long fmId) {
        if (!CollectionUtils.isEmpty(couponRangeList)) {
            for (CouponRangeInfoBO couponRangeInfoBO : couponRangeList) {
                CouponRangePO couponRangePO = new CouponRangePO();
                BeanUtils.copyProperties((Object)couponRangeInfoBO, (Object)couponRangePO);
                couponRangePO.setFmId(fmId);
                int rangeInsertResult = this.couponRangeMapper.insert(couponRangePO);
                if (rangeInsertResult >= 1) continue;
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u8303\u56f4\u63a7\u5236\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u8303\u56f4\u63a7\u5236\u8868\u5931\u8d25");
            }
        }
    }

    private void createCouponAmount(List<CouponAmoInfoBO> couponAmountList, long fmId) {
        if (!CollectionUtils.isEmpty(couponAmountList)) {
            for (CouponAmoInfoBO couponAmoInfoBO : couponAmountList) {
                CouponAmountPO couponAmountPO = new CouponAmountPO();
                BeanUtils.copyProperties((Object)couponAmoInfoBO, (Object)couponAmountPO);
                couponAmountPO.setFmId(fmId);
                int AmountInsertResult = this.couponAmountMapper.insert(couponAmountPO);
                if (AmountInsertResult >= 1) continue;
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u6570\u91cf\u63a7\u5236\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
                }
                throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u6570\u91cf\u63a7\u5236\u8868\u5931\u8d25");
            }
        }
    }

    private void insertFullSub(CreateCouponFormInfoBO couponFormInfoBO, long fmId) {
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        CouponModPO couponModPO1 = new CouponModPO();
        couponModPO1.setFmId(fmId);
        couponModPO1.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        couponModPO1.setTemplateType(templatePO1.getTemplateType());
        int modInsertResult1 = this.couponModMapper.insert(couponModPO1);
        if (modInsertResult1 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        CouponModPO couponModPO2 = new CouponModPO();
        couponModPO2.setFmId(fmId);
        couponModPO2.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        couponModPO2.setTemplateType(templatePO2.getTemplateType());
        int modInsertResult2 = this.couponModMapper.insert(couponModPO2);
        if (modInsertResult2 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
        CouponAttrPO couponAttrPO1 = new CouponAttrPO();
        couponAttrPO1.setFmId(fmId);
        couponAttrPO1.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            couponAttrPO1.setParaName(paramPO1.getParaName());
        }
        couponAttrPO1.setParaCode("total_fee_reach");
        couponAttrPO1.setParaValue(couponFormInfoBO.getTotalFeeReach());
        int attrInsertResult1 = this.couponAttrMapper.insert(couponAttrPO1);
        if (attrInsertResult1 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25");
        }
        CouponAttrPO couponAttrPO2 = new CouponAttrPO();
        couponAttrPO2.setFmId(fmId);
        couponAttrPO2.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_discount");
        if (null != paramPO2) {
            couponAttrPO2.setParaName(paramPO2.getParaName());
        }
        couponAttrPO2.setParaCode("total_fee_discount");
        couponAttrPO2.setParaValue(couponFormInfoBO.getFeeDiscount());
        int attrInsertResult2 = this.couponAttrMapper.insert(couponAttrPO2);
        if (attrInsertResult2 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25");
        }
    }

    private void insertFullDiscout(CreateCouponFormInfoBO couponFormInfoBO, long fmId) {
        TemplatePO templatePO1 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        CouponModPO couponModPO1 = new CouponModPO();
        couponModPO1.setFmId(fmId);
        couponModPO1.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        couponModPO1.setTemplateType(templatePO1.getTemplateType());
        int modInsertResult1 = this.couponModMapper.insert(couponModPO1);
        if (modInsertResult1 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
        TemplatePO templatePO2 = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID);
        CouponModPO couponModPO2 = new CouponModPO();
        couponModPO2.setFmId(fmId);
        couponModPO2.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID);
        couponModPO2.setTemplateType(templatePO2.getTemplateType());
        int modInsertResult2 = this.couponModMapper.insert(couponModPO2);
        if (modInsertResult2 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
        CouponAttrPO couponAttrPO1 = new CouponAttrPO();
        couponAttrPO1.setFmId(fmId);
        couponAttrPO1.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_STD_TEMP_ID);
        ParamPO paramPO1 = this.paramMapper.getModelById("total_fee_reach");
        if (null != paramPO1) {
            couponAttrPO1.setParaName(paramPO1.getParaName());
        }
        couponAttrPO1.setParaCode("total_fee_reach");
        couponAttrPO1.setParaValue(couponFormInfoBO.getTotalFeeReach());
        int attrInsertResult1 = this.couponAttrMapper.insert(couponAttrPO1);
        if (attrInsertResult1 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25");
        }
        CouponAttrPO couponAttrPO2 = new CouponAttrPO();
        couponAttrPO2.setFmId(fmId);
        couponAttrPO2.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_DCT_TEMP_ID);
        ParamPO paramPO2 = this.paramMapper.getModelById("total_fee_discount_rate");
        if (null != paramPO2) {
            couponAttrPO2.setParaName(paramPO2.getParaName());
        }
        couponAttrPO2.setParaCode("total_fee_discount_rate");
        couponAttrPO2.setParaValue(couponFormInfoBO.getDiscountRate());
        int attrInsertResult2 = this.couponAttrMapper.insert(couponAttrPO2);
        if (attrInsertResult2 < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25");
        }
    }

    private void insertFreightSpecAmo(CreateCouponFormInfoBO couponFormInfoBO, Long fmId) {
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_DCT_TEMP_ID);
        CouponModPO couponModPO = new CouponModPO();
        couponModPO.setFmId(fmId);
        couponModPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_DCT_TEMP_ID);
        couponModPO.setTemplateType(templatePO.getTemplateType());
        int modInsertResult = this.couponModMapper.insert(couponModPO);
        if (modInsertResult < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
        CouponAttrPO couponAttrPO = new CouponAttrPO();
        couponAttrPO.setFmId(fmId);
        couponAttrPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_DCT_TEMP_ID);
        ParamPO paramPO = this.paramMapper.getModelById("total_fee_discount");
        if (null != paramPO) {
            couponAttrPO.setParaName(paramPO.getParaName());
        }
        couponAttrPO.setParaCode("total_fee_discount");
        couponAttrPO.setParaValue(couponFormInfoBO.getFeeDiscount());
        int attrInsertResult = this.couponAttrMapper.insert(couponAttrPO);
        if (attrInsertResult < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25");
        }
    }

    private void insertDeduction(CreateCouponFormInfoBO couponFormInfoBO, long fmId) {
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        CouponModPO couponModPO = new CouponModPO();
        couponModPO.setFmId(fmId);
        couponModPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        couponModPO.setTemplateType(templatePO.getTemplateType());
        int modInsertResult = this.couponModMapper.insert(couponModPO);
        if (modInsertResult < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
        CouponAttrPO couponAttrPO = new CouponAttrPO();
        couponAttrPO.setFmId(fmId);
        couponAttrPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_DCT_TEMP_ID);
        ParamPO paramPO = this.paramMapper.getModelById("total_fee_discount");
        if (null != paramPO) {
            couponAttrPO.setParaName(paramPO.getParaName());
        }
        couponAttrPO.setParaCode("total_fee_discount");
        couponAttrPO.setParaValue(couponFormInfoBO.getFeeDiscount());
        int attrInsertResult = this.couponAttrMapper.insert(couponAttrPO);
        if (attrInsertResult < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u5c5e\u6027\u8868\u5931\u8d25");
        }
    }

    private void insertFreightAll(Long fmId) {
        TemplatePO templatePO = this.templateMapper.getModelById(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_FREE_TEMP_ID);
        CouponModPO couponModPO = new CouponModPO();
        couponModPO.setFmId(fmId);
        couponModPO.setTemplateId(ActCommConstant.DifActivityTempIds.TOTAL_MONEY_SEND_FREE_TEMP_ID);
        couponModPO.setTemplateType(templatePO.getTemplateType());
        int modInsertResult = this.couponModMapper.insert(couponModPO);
        if (modInsertResult < 1) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25,insert\u8fd4\u56de\u7ed3\u679c\u5c0f\u4e8e1");
            }
            throw new BusinessException("6037", "\u4f18\u60e0\u5238\u89c4\u683c\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u63d2\u5165\u4f18\u60e0\u5238\u6a21\u677f\u8868\u5931\u8d25");
        }
    }
}

