/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.comb.impl;

import com.tydic.newretail.busi.ActCreateCouponBusiService;
import com.tydic.newretail.busi.ActUpdateCouponCreAppBusiService;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiReqBO;
import com.tydic.newretail.busi.bo.ActCreateCouponBusiRspBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponCreAppBusiReqBO;
import com.tydic.newretail.busi.bo.ActUpdateCouponCreAppBusiRspBO;
import com.tydic.newretail.comb.ActCreateCouponCombService;
import com.tydic.newretail.comb.bo.ActCreateCouponCombReqBO;
import com.tydic.newretail.comb.bo.ActCreateCouponCombRspBO;
import com.tydic.newretail.common.bo.CouponInstBO;
import com.tydic.newretail.common.bo.CouponTaskBO;
import com.tydic.newretail.constant.ActCommConstant;
import com.tydic.newretail.dao.CouponTaskMapper;
import com.tydic.newretail.dao.po.CouponTaskPO;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actCreateCouponCombService")
public class ActCreateCouponCombServiceImpl
implements ActCreateCouponCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActCreateCouponCombServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private CouponTaskMapper couponTaskMapper;
    private ActCreateCouponBusiService actCreateCouponBusiService;
    private ActUpdateCouponCreAppBusiService actUpdateCouponCreAppBusiService;

    @Autowired
    private ActCreateCouponCombServiceImpl(CouponTaskMapper couponTaskMapper, ActCreateCouponBusiService actCreateCouponBusiService, ActUpdateCouponCreAppBusiService actUpdateCouponCreAppBusiService) {
        this.couponTaskMapper = couponTaskMapper;
        this.actCreateCouponBusiService = actCreateCouponBusiService;
        this.actUpdateCouponCreAppBusiService = actUpdateCouponCreAppBusiService;
    }

    public ActCreateCouponCombRspBO createCoupon(ActCreateCouponCombReqBO reqBO) {
        ActCreateCouponCombRspBO rspBO = new ActCreateCouponCombRspBO();
        CouponTaskPO taskPO = this.couponTaskMapper.getModelById(reqBO.getTaskId());
        if (null == taskPO) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4efb\u52a1ID[" + reqBO.getTaskId() + "],\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4fe1\u606f");
            }
            rspBO.setRespCode("3001");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4fe1\u606f");
            return rspBO;
        }
        if (ActCommConstant.CouponTaskState.PENDING_AUDIT.equals(taskPO.getTaskState()) || ActCommConstant.CouponTaskState.AUDIT_NOT_PASS.equals(taskPO.getTaskState())) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4efb\u52a1ID[" + reqBO.getTaskId() + "],\u4efb\u52a1\u5904\u4e8e\u5f85\u5ba1\u6838\u6216\u5ba1\u6838\u4e0d\u5408\u683c\u72b6\u6001\uff0c\u65e0\u6cd5\u6267\u884c");
            }
            rspBO.setRespCode("3001");
            rspBO.setRespDesc("\u4efb\u52a1\u5904\u4e8e\u5ba1\u6838\u672a\u901a\u8fc7\u72b6\u6001\uff0c\u65e0\u6cd5\u6267\u884c");
            return rspBO;
        }
        if (ActCommConstant.CouponTaskState.EXECUTIVE_COMPLETION.equals(taskPO.getTaskState())) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4efb\u52a1ID[" + reqBO.getTaskId() + "],\u4efb\u52a1\u5904\u4e8e\u6267\u884c\u5b8c\u6210\u72b6\u6001\uff0c\u65e0\u9700\u518d\u6b21\u6267\u884c");
            }
            rspBO.setRespCode("3001");
            rspBO.setRespDesc("\u4efb\u52a1\u5904\u4e8e\u6267\u884c\u5b8c\u6210\u72b6\u6001\uff0c\u65e0\u9700\u518d\u6b21\u6267\u884c");
            return rspBO;
        }
        CouponInstBO couponInstBO = new CouponInstBO();
        BeanUtils.copyProperties((Object)taskPO, (Object)couponInstBO);
        Date eff = couponInstBO.getEffTime();
        Date exp = couponInstBO.getExpTime();
        Date now = new Date();
        couponInstBO.setCreateTime(now);
        if (now.after(eff) && now.before(exp)) {
            couponInstBO.setState(ActCommConstant.CouponState.TO_BE_RECEIVED);
        }
        if (exp.before(new Date())) {
            couponInstBO.setState(ActCommConstant.CouponState.EXPIRED);
        }
        if (eff.after(new Date())) {
            couponInstBO.setState(ActCommConstant.CouponState.CREATED);
        }
        int failedCount = 0;
        int totalCount = taskPO.getPatchNum() - taskPO.getTotalNum();
        for (int i = 0; i < totalCount; ++i) {
            ActCreateCouponBusiReqBO busiReqBO = new ActCreateCouponBusiReqBO();
            busiReqBO.setCouponInfo(couponInstBO);
            ActCreateCouponBusiRspBO busiRspBO = this.actCreateCouponBusiService.createCoupon(busiReqBO);
            if ("0000".equals(busiRspBO.getRespCode())) continue;
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u4f18\u60e0\u5238\u521b\u5efa\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u4f18\u60e0\u5238\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0\uff1a" + busiRspBO.getRespDesc());
            }
            ++failedCount;
        }
        int onceNum = totalCount - failedCount;
        int totalNum = taskPO.getTotalNum() + totalCount - failedCount;
        int result = this.updateTaskInfo(taskPO, onceNum, totalNum, now);
        if (1 == result) {
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u5b8c\u6210\uff0c\u4f46\u4efb\u52a1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        } else {
            rspBO.setRespDesc("\u4f18\u60e0\u5238\u521b\u5efa\u5b8c\u6210\uff0c\u4e14\u4efb\u52a1\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private int updateTaskInfo(CouponTaskPO taskPO, int onceNum, int totalNum, Date beginTime) {
        ActUpdateCouponCreAppBusiReqBO updateCouponCreAppBusiReqBO = new ActUpdateCouponCreAppBusiReqBO();
        CouponTaskBO couponTaskBO = new CouponTaskBO();
        couponTaskBO.setTaskId(taskPO.getTaskId());
        couponTaskBO.setBeginTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beginTime));
        couponTaskBO.setEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        couponTaskBO.setOnceNum(Integer.valueOf(onceNum));
        couponTaskBO.setTotalNum(Integer.valueOf(totalNum));
        if (totalNum == taskPO.getPatchNum()) {
            couponTaskBO.setTaskState(ActCommConstant.CouponTaskState.EXECUTIVE_COMPLETION);
        } else if (0 == totalNum) {
            couponTaskBO.setTaskState(ActCommConstant.CouponTaskState.EXECUTION_FAILURE);
        } else {
            couponTaskBO.setTaskState(ActCommConstant.CouponTaskState.PARTIAL_EXECUTION_COMPLETED);
        }
        updateCouponCreAppBusiReqBO.setCouponTask(couponTaskBO);
        ActUpdateCouponCreAppBusiRspBO updateCouponCreAppBusiRspBO = this.actUpdateCouponCreAppBusiService.updateCouponCreApp(updateCouponCreAppBusiReqBO);
        if (!"0000".equals(updateCouponCreAppBusiRspBO.getRespCode())) {
            if (IS_DEBUGABLE) {
                LOGGER.debug("[" + taskPO.getTaskId() + "]\u4efb\u52a1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            }
            return 1;
        }
        return 0;
    }
}

