/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.newretail.busi.dict.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.newretail.busi.dict.ActSelectDictByCodeAndPcodeBusiService;
import com.tydic.newretail.busi.dict.bo.ActSelectDictByCodeAndPcodeBusiReqBO;
import com.tydic.newretail.busi.dict.bo.ActSelectDictByCodeAndPcodeBusiRspBO;
import com.tydic.newretail.busi.dict.bo.DicDictionaryBusiBO;
import com.tydic.newretail.dao.ActDicDictionaryMapper;
import com.tydic.newretail.dao.po.DicDictionaryPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="actSelectDictByCodeAndPcodeBusiService")
public class ActSelectDictByCodeAndPcodeBusiServiceImpl
implements ActSelectDictByCodeAndPcodeBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActSelectDictByCodeAndPcodeBusiServiceImpl.class);
    private static final boolean IS_DEBUGABLE = LOGGER.isDebugEnabled();
    private ActDicDictionaryMapper actDicDictionaryMapper;
    private CacheClient cacheService;

    @Autowired
    private ActSelectDictByCodeAndPcodeBusiServiceImpl(ActDicDictionaryMapper actDicDictionaryMapper, CacheClient cacheService) {
        this.actDicDictionaryMapper = actDicDictionaryMapper;
        this.cacheService = cacheService;
    }

    public ActSelectDictByCodeAndPcodeBusiRspBO queryDictByCodeAndPcode(ActSelectDictByCodeAndPcodeBusiReqBO reqBO) {
        ActSelectDictByCodeAndPcodeBusiRspBO rspBO = new ActSelectDictByCodeAndPcodeBusiRspBO();
        String pCode = reqBO.getPCode();
        String code = reqBO.getCode();
        Object object = this.cacheService.get(pCode);
        if (object != null) {
            List dicDictionaries = (List)object;
            for (DicDictionaryBusiBO dicDictionary : dicDictionaries) {
                if (!dicDictionary.getCode().equals(code)) continue;
                if (IS_DEBUGABLE) {
                    LOGGER.debug("redis\u7f13\u5b58\u4e2d\u83b7\u53d6\u5b57\u5178\u503c" + JSON.toJSONString((Object)dicDictionary));
                }
                rspBO.setDictionaryInfo(dicDictionary);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u4fe1\u606f\u6210\u529f");
                return rspBO;
            }
        } else {
            DicDictionaryPO dictionaryPO = new DicDictionaryPO();
            dictionaryPO.setPCode(pCode);
            List<DicDictionaryPO> dicDictionaryPOList = this.actDicDictionaryMapper.getList(dictionaryPO);
            if (IS_DEBUGABLE) {
                LOGGER.debug("\u6570\u636e\u5e93\u83b7\u53d6\u5b57\u5178\u503c\u5217\u8868:" + JSON.toJSONString(dicDictionaryPOList));
            }
            if (CollectionUtils.isEmpty(dicDictionaryPOList)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u503c\u4e0d\u5b58\u5728");
                return rspBO;
            }
            ArrayList<DicDictionaryBusiBO> dicDictionaryBOList = new ArrayList<DicDictionaryBusiBO>();
            for (DicDictionaryPO dicPO : dicDictionaryPOList) {
                DicDictionaryBusiBO dictionaryBO = new DicDictionaryBusiBO();
                BeanUtils.copyProperties((Object)dicPO, (Object)dictionaryBO);
                dicDictionaryBOList.add(dictionaryBO);
            }
            this.cacheService.set(pCode, dicDictionaryBOList, 129600);
            for (DicDictionaryBusiBO dicDictionary : dicDictionaryBOList) {
                if (!dicDictionary.getCode().equals(code)) continue;
                if (IS_DEBUGABLE) {
                    LOGGER.debug("\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5b57\u5178\u503c" + JSON.toJSONString((Object)dicDictionary));
                }
                rspBO.setDictionaryInfo(dicDictionary);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u4fe1\u606f\u6210\u529f");
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5b57\u5178\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }
}

